// NotesMailDB.h: interface for the CNotesMailDB class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_NOTESMAILDB_H__093520D5_6941_4F42_8C9A_521EDE2B4BBA__INCLUDED_)
#define AFX_NOTESMAILDB_H__093520D5_6941_4F42_8C9A_521EDE2B4BBA__INCLUDED_

#include "DnsblCache.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// normally should the define be imported from mq.h
// fails since C API 5.0.7 installed
#define NOPRIORITY MAXWORD
#include <lncppapi.h>
#include "Debugger.h"
#include "IPAddress.h"	// Added by ClassView
#include "NoteIDCache.h"	// Added by ClassView
#include "GoodDnsCache.h"	// Added by ClassView
#include "SearchThread.h"
#include "DSpamFilter.h"

class CNotesMailDB  
{
public:
	CNotesMailDB();
	virtual ~CNotesMailDB();

	BOOL searchSpam(CDebugger *debugger, CSearchThreadInfo* pSearchInfo);
	BOOL trainDSpam(CDebugger *debugger, CSearchThreadInfo* pSearchInfo);
	BOOL purgeDSpam(CDebugger *debugger, CSearchThreadInfo* pSearchInfo);
	LNDatetime GetLastModified();

protected:
	CString CopyIniFile();
	CGoodDnsCache m_goodDnsCache;
	CNoteIDCache m_noteIDCache;
	BOOL checkAgainstDnsbl(const CIPAddress &ip, CString &dnsbl);
	BOOL checkAgainstWhitelist(const CString &sender);
	CIPAddress extractIPAddress(const LNString& lnStr);

	CNotesAntiSpamApp* myApp;
	LNNotesSession     m_notesSession;
	LNDatabase         m_mailDb;
	LNViewFolder       m_inboxView;
	LNViewFolder       m_spamView;
	LNViewFolder       m_spamTrainView;
	LNViewFolder       m_hamTrainView;
	CDnsblCache        m_dnsblCache;
	CDSpamFilter       m_dSpamFilter;
};

#endif // !defined(AFX_NOTESMAILDB_H__093520D5_6941_4F42_8C9A_521EDE2B4BBA__INCLUDED_)
