// PersistantHashTable.h: interface for the CPersistantHashTable class.
//
//////////////////////////////////////////////////////////////////////
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_PERSISTANTHASHTABLE_H__C820FA7C_AC7C_4AA5_A4AC_97C006A56590__INCLUDED_)
#define AFX_PERSISTANTHASHTABLE_H__C820FA7C_AC7C_4AA5_A4AC_97C006A56590__INCLUDED_

// GDBM-Include-File
#ifdef STATIC_BUILD
# define DLLIMPORT
# define DLLEXPORT
#else
#ifdef WIN32
# define DLLEXPORT __declspec(dllexport)      // dll-creation
# define DLLIMPORT __declspec(dllimport)
#else
# define DLLIMPORT                            // static lib
# define DLLEXPORT
#endif
#endif

#ifdef USE_DLL
# define IMEXPORT DLLIMPORT
#else
# define IMEXPORT DLLEXPORT
#endif

#include <gdbm.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CPersistantHashTable  
{
public:
	CPersistantHashTable();
	CPersistantHashTable(const CString& filename, int flags);
	virtual ~CPersistantHashTable();

	int openFile(const CString& filename, int flags);
	void closeFile();

	int add(const CString& key,const CString& value);
	int replace(const CString& key,const CString& value);

	int del(const CString& key);

	CString get(const CString& key);
	bool    exists(const CString& key);

	CString getFirstKey();
	CString getNextKey(const CString& key);

protected:
	CString   m_filename;
	BOOL      m_isOpen;
	GDBM_FILE m_dbf;
};

#endif // !defined(AFX_PERSISTANTHASHTABLE_H__C820FA7C_AC7C_4AA5_A4AC_97C006A56590__INCLUDED_)
