// SearchThread.cpp : implementation file
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "SearchThread.h"
#include "NotesMailDB.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/* Create Mutex for SearchThreadProc */
static CMutex m_timerAccess(FALSE,NULL);
//static CCriticalSection m_timerAccess;
CSingleLock sLock(&m_timerAccess);

// The Notes Mail-DB
CNotesMailDB* notesMailDB=NULL;

/////////////////////////////////////////////////////////////////////////////
// CSearchThread
UINT SearchThreadProc(LPVOID pParam)
{
	CSearchThreadInfo* pSearchInfo = (CSearchThreadInfo*)pParam;

	// Time the Mail-DB was last changed
//	LNDatetime lastMod;

	// Get my Application
	CNotesAntiSpamApp* myApp=(CNotesAntiSpamApp*)AfxGetApp();

	myApp->debugger.Add(__FILE__,__LINE__,"Initialize NotesMailDB ...");
	notesMailDB=new CNotesMailDB();
	if(notesMailDB==NULL)
	{
		AfxMessageBox(IDS_UNABLETOCREATENOTESMAILDB,MB_OK|MB_ICONERROR);
		return FALSE;
	}

	// This Search thread runs in an infinite loop, waiting to Searchulate the
	// result whenever the main application thread sets the "start Search" event.
	// The Search thread exits the loop only when the main application sets the
	// "kill Search" event.

	BOOL bSearchCompleted;
	BOOL trainDSpam;
	BOOL purgeDSpam;

//	lastMod.SetDate(1,1,51);
//	lastMod.SetTime(0,0,0,0);
	while (TRUE)
	{
		bSearchCompleted = FALSE;
		trainDSpam=false;
		purgeDSpam=false;

		// Wait until the main application thread asks this thread to do
		//      another calculation.
		if (WaitForSingleObject(pSearchInfo->m_hEventStartSearch, INFINITE)
			!= WAIT_OBJECT_0)
			break;

		// Exit the thread if the main application sets the "kill Search"
		// event. The main application will set the "start Search" event
		// before setting the "kill Search" event.

		if (WaitForSingleObject(pSearchInfo->m_hEventKillSearchThread, 0)
			== WAIT_OBJECT_0)
			break; // Terminate this thread by existing the proc.

		// Check if we should train
		// The main application will set the "start Search" event
		// before setting the "Start Train" event.
		if (WaitForSingleObject(pSearchInfo->m_hEventStartTrainDSpam, 0)
			== WAIT_OBJECT_0)
			trainDSpam=true;
			
		// Check if we should purge
		// The main application will set the "start Search" event
		// before setting the "Start Purge" event.
		if (WaitForSingleObject(pSearchInfo->m_hEventStartPurgeDSpam, 0)
			== WAIT_OBJECT_0)
			purgeDSpam=true;

		// Reset event to indicate "not done", that is, Searchulation is in progress.
		ResetEvent(pSearchInfo->m_hEventSearchDone);

		// Send Message to Window
		::PostMessage(pSearchInfo->m_hwndNotifySearch,MYWM_SEARCHSPAMSTART, 0, 0);

		// If Mutex is already used, the search is already running
		if(sLock.IsLocked())
		{
			myApp->debugger.Add(__FILE__,__LINE__,"SearchSpam() : Mutex Locked.");
			return (LRESULT)0;
		}

		// Lock ressource
		sLock.Lock(5);

		if(!trainDSpam && !purgeDSpam)
		{
//			if(lastMod!=notesMailDB->GetLastModified())
//			{
//				lastMod=notesMailDB->GetLastModified();
				// search spam
				bSearchCompleted=notesMailDB->searchSpam(&(myApp->debugger),pSearchInfo);
//			}
//			else
//				bSearchCompleted=TRUE;
		}
		else if(trainDSpam)
		{
			// train DSpam
			bSearchCompleted=notesMailDB->trainDSpam(&(myApp->debugger),pSearchInfo);
		}
		else if(purgeDSpam)
		{
			// purge DSpam
			bSearchCompleted=notesMailDB->purgeDSpam(&(myApp->debugger),pSearchInfo);
		}

		// Release Mutex
		sLock.Unlock();

		// Set event to indicate that Searchulation is done (i.e., no longer in progres),
		// even if perhaps interrupted by "kill Search" event detected in the SlowAdd function.
		SetEvent(pSearchInfo->m_hEventSearchDone);

		if (!bSearchCompleted)  // If interrupted by kill then...
			break; // terminate this thread by exiting the proc.

		::PostMessage(pSearchInfo->m_hwndNotifySearch,MYWM_SEARCHSPAMSTOP, 0, 0);
	}

	// Delete Notes-Instance
	if(notesMailDB!=NULL)
	{
		myApp->debugger.Add(__FILE__,__LINE__,"Deleting notesMailDB...");
		delete notesMailDB;
		notesMailDB=NULL;
	}

	if (!bSearchCompleted)
		SetEvent(pSearchInfo->m_hEventSearchThreadKilled);

	return 0;
}
