// TrainIDCache.h: interface for the CTrainIDCache class.
//
//////////////////////////////////////////////////////////////////////
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_TRAINIDCACHE_H__21A8E24B_A59E_4372_8D3C_4C8E3B3508DB__INCLUDED_)
#define AFX_TRAINIDCACHE_H__21A8E24B_A59E_4372_8D3C_4C8E3B3508DB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// normally should the define be imported from mq.h
// fails since C API 5.0.7 installed
#define NOPRIORITY MAXWORD
#include <lncppapi.h>
#include "PersistantHashTable.h"

class CTrainIDCache  
{
public:
	CTrainIDCache(const CString& filename);
	virtual ~CTrainIDCache();

	void AddEntry(const CString& msgID);
	void DelEntry(const CString& msgID);
	BOOL Check(const CString& msgID);

protected:
	CPersistantHashTable m_cache;

};

#endif // !defined(AFX_TRAINIDCACHE_H__21A8E24B_A59E_4372_8D3C_4C8E3B3508DB__INCLUDED_)
