/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.action;

import java.util.List;
import java.util.Map;
import jp.nimbus.ide.action.EditAction;
import jp.nimbus.ide.beanflow.action.MethodExpression;
import jp.nimbus.ide.beanflow.editpart.ResultEditPart;
import jp.nimbus.ide.beanflow.editpart.StepEditPart;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.beanflow.util.BeanFlowUtil;
import jp.nimbus.ide.dialog.InvocationSelectionDialog;
import jp.nimbus.ide.util.JdtUtil;
import jp.nimbus.ide.util.WorkbenchUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.ui.IWorkbenchPart;

public class SelectInvocationAction
extends EditAction {
    public static final String DATA_INDEXER = "_data_indexer";
    private Flow flow;
    protected InvocationSelectionDialog.InvocationType invocationType;
    protected MethodExpression methodExpression;
    private String indexerExpression;

    public SelectInvocationAction(IWorkbenchPart part, String actionId, Flow flow, InvocationSelectionDialog.InvocationType invocationType) {
        super(part, actionId);
        this.flow = flow;
        this.invocationType = invocationType;
    }

    public void run() {
        this.methodExpression = null;
        this.indexerExpression = null;
        List editPartList = this.getSelectedObjects();
        if (editPartList != null && editPartList.size() == 1) {
            Step step;
            EditPart editPart = (EditPart)editPartList.get(0);
            Target target = null;
            if (editPart instanceof StepEditPart) {
                step = (Step)editPart.getModel();
                target = step.getTarget();
            } else if (editPart instanceof ResultEditPart) {
                step = (Step)editPart.getParent().getModel();
                target = step.getTarget();
            }
            if (target != null) {
                ReferenceType referenceType = target.getReferenceType();
                if (referenceType == ReferenceType.Object) {
                    this.openDialog(target.getExpression());
                } else if (referenceType == ReferenceType.StepRef) {
                    this.openDialog(BeanFlowUtil.searchObjectTarget(this.flow, target.getExpression()));
                }
            }
        }
    }

    protected Request createRequest() {
        Request request = super.createRequest();
        Map data = request.getExtendedData();
        data.put("_data_type", this.invocationType);
        data.put("_data_expression", this.methodExpression);
        data.put(DATA_INDEXER, this.indexerExpression);
        return request;
    }

    private void openDialog(String expression) {
        Object[] result;
        InvocationSelectionDialog dialog = new InvocationSelectionDialog(WorkbenchUtil.getShell(), this.invocationType, expression);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            IMethod method = (IMethod)result[0];
            this.createResult(method);
            if (this.invocationType == InvocationSelectionDialog.InvocationType.Property) {
                this.indexerExpression = dialog.getIndexerExpression();
            }
            this.executeAction();
        }
    }

    protected void executeAction() {
        super.run();
    }

    protected void createResult(IMethod method) {
        String methodName = method.getElementName();
        String[] parameterClassNames = null;
        if (method.isResolved()) {
            String[] parameterTypeExps = method.getParameterTypes();
            parameterClassNames = new String[parameterTypeExps.length];
            int i = 0;
            while (i < parameterTypeExps.length) {
                parameterClassNames[i] = Signature.toString((String)parameterTypeExps[i]);
                ++i;
            }
        } else {
            IMethodBinding methodBinding = (IMethodBinding)JdtUtil.getBinding((IMember)method);
            ITypeBinding[] parameterTypeBindings = methodBinding.getParameterTypes();
            parameterClassNames = new String[parameterTypeBindings.length];
            int i = 0;
            while (i < parameterTypeBindings.length) {
                parameterClassNames[i] = parameterTypeBindings[i].getQualifiedName();
                ++i;
            }
        }
        this.createMethodExpression(methodName, parameterClassNames);
    }

    protected void createMethodExpression(String methodName, String[] parameterClassNames) {
        this.methodExpression = new MethodExpression(methodName, parameterClassNames);
    }
}

