/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jp.nimbus.ide.action.EditAction;
import jp.nimbus.ide.beanflow.editpart.ArgumentEditPart;
import jp.nimbus.ide.beanflow.editpart.AttributeEditPart;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.Parameter;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Resource;
import jp.nimbus.ide.dialog.SimpleSelectionDialog;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.ui.IWorkbenchPart;

public class SelectResourceAction
extends EditAction {
    private static final String DIALOG_TITLE = "\u30ea\u30bd\u30fc\u30b9\u306e\u9078\u629e";
    private static final String DIALOG_MESSAGE = "\u30ea\u30bd\u30fc\u30b9\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private Flow flow;
    private String expression;

    public SelectResourceAction(IWorkbenchPart part, String actionId, Flow flow) {
        super(part, actionId);
        this.flow = flow;
    }

    public void run() {
        this.expression = null;
        List editPartList = this.getSelectedObjects();
        if (editPartList != null && editPartList.size() == 1) {
            Object[] result;
            Parameter parameter;
            String input = null;
            EditPart editPart = (EditPart)editPartList.get(0);
            if ((editPart instanceof AttributeEditPart || editPart instanceof ArgumentEditPart) && (parameter = (Parameter)editPart.getModel()).getReferenceType() == ReferenceType.ResourceRef) {
                input = (String)parameter.getValue();
            }
            ArrayList<String> resourceNameList = new ArrayList<String>();
            for (Resource resource : this.flow.getResources()) {
                resourceNameList.add(resource.getName());
            }
            Collections.sort(resourceNameList);
            SimpleSelectionDialog dialog = new SimpleSelectionDialog(this.getWorkbenchPart().getSite().getShell(), DIALOG_TITLE, DIALOG_MESSAGE, resourceNameList.toArray(new String[resourceNameList.size()]), input);
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                this.expression = (String)result[0];
                super.run();
            }
        }
    }

    protected Request createRequest() {
        Request request = super.createRequest();
        Map data = request.getExtendedData();
        data.put("_data_expression", this.expression);
        data.put("_data_type", ReferenceType.ResourceRef);
        return request;
    }
}

