/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.action;

import java.util.List;
import java.util.Map;
import jp.nimbus.ide.action.EditAction;
import jp.nimbus.ide.beanflow.editpart.ResourceEditPart;
import jp.nimbus.ide.beanflow.editpart.StepEditPart;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Resource;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.service.dialog.ServiceSelectionDialog;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.ui.IWorkbenchPart;

public class SelectServiceAction
extends EditAction {
    private String expression;

    public SelectServiceAction(IWorkbenchPart part, String actionId) {
        super(part, actionId);
    }

    public void run() {
        this.expression = null;
        List editPartList = this.getSelectedObjects();
        if (editPartList != null && editPartList.size() == 1) {
            Object[] result;
            ServiceSelectionDialog dialog;
            String input = null;
            EditPart editPart = (EditPart)editPartList.get(0);
            if (editPart instanceof StepEditPart) {
                Step step = (Step)editPart.getModel();
                Target target = step.getTarget();
                if (target.getReferenceType() == ReferenceType.ServiceRef) {
                    input = target.getExpression();
                }
            } else if (editPart instanceof ResourceEditPart) {
                Resource resource = (Resource)editPart.getModel();
                input = resource.getService();
            }
            if ((dialog = new ServiceSelectionDialog(this.getWorkbenchPart().getSite().getShell(), input)).open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                this.expression = (String)result[0];
                super.run();
            }
        }
    }

    protected Request createRequest() {
        Request request = super.createRequest();
        Map data = request.getExtendedData();
        data.put("_data_expression", this.expression);
        data.put("_data_type", ReferenceType.ServiceRef);
        return request;
    }
}

