/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.beanflow.editpart.Adjustable;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.Resource;
import jp.nimbus.ide.editpart.AbstractEditPart;
import jp.nimbus.ide.editpart.EditableLayoutEditPolicy;
import jp.nimbus.ide.figure.TiledImageFigure;
import jp.nimbus.ide.model.EditableModel;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowEditPart
extends AbstractEditPart
implements Adjustable {
    private FigureCanvas figureCanvas;
    private static final int CONTENTS_PADDING = 16;
    private static final int ACTIVITY_SPACING = 24;
    private static final int RESOURCE_SPACING = 8;
    private Point scrolledOffset = new Point(0, 0);

    protected IFigure createFigure() {
        this.figureCanvas = (FigureCanvas)this.getViewer().getControl();
        this.figureCanvas.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollBar scrollBar = (ScrollBar)e.getSource();
                ((FlowEditPart)FlowEditPart.this).scrolledOffset.x = scrollBar.getSelection();
                FlowEditPart.this.figureCanvas.redraw();
            }
        });
        this.figureCanvas.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScrollBar scrollBar = (ScrollBar)e.getSource();
                ((FlowEditPart)FlowEditPart.this).scrolledOffset.y = scrollBar.getSelection();
                FlowEditPart.this.figureCanvas.redraw();
            }
        });
        TiledImageFigure background = new TiledImageFigure(this.figureCanvas, Resources.getImage("_image_slash"));
        background.setLayoutManager((LayoutManager)new FreeformLayout());
        return background;
    }

    @Override
    public void adjustContents() {
        for (EditPart editPart : this.getChildren()) {
            if (!(editPart instanceof Adjustable)) continue;
            ((Adjustable)editPart).adjustContents();
        }
        Flow flow = (Flow)this.getModel();
        int yOffset = 16;
        List<Resource> resourceList = flow.getResources();
        EditableModel prevResource = null;
        for (Resource resource : resourceList) {
            Point location = new Point(16, 16);
            if (prevResource != null) {
                Rectangle prevBounds = prevResource.getBounds();
                location.y = prevBounds.y + prevBounds.height + 8;
            }
            resource.setLocation(location.x, location.y);
            prevResource = resource;
        }
        if (prevResource != null) {
            Rectangle prevBounds = prevResource.getBounds();
            yOffset += prevBounds.y + prevBounds.height;
        }
        List<Activity> activityList = flow.getActivities();
        EditableModel prevActivity = null;
        int maxWidth = 0;
        for (Activity activity : activityList) {
            if (prevActivity == null) {
                activity.setLocation(16, yOffset);
            } else {
                Rectangle prevBounds = prevActivity.getBounds();
                activity.setLocation(16, prevBounds.y + prevBounds.height + 24);
            }
            Rectangle bounds = activity.getBounds();
            if (bounds.width > maxWidth) {
                maxWidth = bounds.width;
            }
            prevActivity = activity;
        }
        int widthOffset = maxWidth / 2;
        for (Activity activity : activityList) {
            Rectangle bounds = activity.getBounds();
            activity.setLocation(bounds.x + widthOffset - bounds.width / 2, bounds.y);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_step") || propertyName.equals("_junction") || propertyName.equals("_loop") || propertyName.equals("_flow_invocation") || propertyName.equals("_resource")) {
            org.eclipse.swt.graphics.Point cursorLocation = Display.getCurrent().getCursorLocation();
            cursorLocation = this.getViewer().getControl().toControl(cursorLocation);
            EditableModel editableModel = (EditableModel)event.getNewValue();
            if (editableModel != null) {
                editableModel.setLocation(cursorLocation.x + this.scrolledOffset.x, cursorLocation.y + this.scrolledOffset.y);
            }
            this.refreshChildren();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new FlowEditPolicy());
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> childList = new ArrayList<Object>();
        Flow flow = (Flow)this.getModel();
        childList.addAll(flow.getResources());
        childList.addAll(flow.getActivities());
        return childList;
    }

    @Override
    public Point getScrolledOffset() {
        return this.scrolledOffset;
    }

    private class ChangeTransactionCommand
    extends Command {
        private Flow flow;
        private Flow.Transaction transaction;
        private Flow.Transaction oldTransaction;

        public ChangeTransactionCommand(Flow flow, Flow.Transaction transaction) {
            this.flow = flow;
            this.transaction = transaction;
        }

        public void execute() {
            this.oldTransaction = this.flow.getTransaction();
            this.flow.setTransaction(this.transaction);
        }

        public void undo() {
            this.flow.setTransaction(this.oldTransaction);
        }
    }

    private class CreateResourceCommand
    extends Command {
        private Flow flow;
        private Point location;
        private Resource resource;

        public CreateResourceCommand(Flow flow, Point location) {
            this.flow = flow;
            this.location = location;
        }

        public void execute() {
            this.resource = this.flow.createResource();
            this.resource.setLocation(this.location.x, this.location.y);
            this.flow.addResource(this.resource);
        }

        public void undo() {
            this.flow.removeResource(this.resource);
        }
    }

    private class FlowEditPolicy
    extends ComponentEditPolicy {
        private FlowEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            String type = (String)request.getType();
            if (type.startsWith("_change_transaction_")) {
                command = this.createChangeTransactionCommand(request);
            }
            return command;
        }

        private Command createChangeTransactionCommand(Request request) {
            Flow.Transaction transaction = (Flow.Transaction)((Object)request.getExtendedData().get("_data_expression"));
            Flow flow = (Flow)FlowEditPart.this.getModel();
            return new ChangeTransactionCommand(flow, transaction);
        }
    }

    private class FlowLayoutEditPolicy
    extends EditableLayoutEditPolicy {
        private FlowLayoutEditPolicy() {
        }

        protected Command getCreateCommand(CreateRequest request) {
            CreateResourceCommand command = null;
            Object type = request.getNewObjectType();
            if (type.equals(Resource.class)) {
                command = new CreateResourceCommand((Flow)FlowEditPart.this.getModel(), request.getLocation());
            }
            return command;
        }
    }
}

