/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.ActivityContainer;
import jp.nimbus.ide.beanflow.model.FlowInvocation;
import jp.nimbus.ide.beanflow.model.Junction;
import jp.nimbus.ide.beanflow.model.Loop;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.editpart.ConnectionEditPart;
import jp.nimbus.ide.model.ConnectableModel;
import jp.nimbus.ide.model.Connection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class ProgressEditPart
extends ConnectionEditPart {
    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ProgressLayoutEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    private abstract class CreateConnectableCommand
    extends Command {
        private Connection connection;
        protected ActivityContainer activityControl;
        private Connection newConnection;
        private ConnectableModel connectable;
        private ConnectableModel oldConnectable;

        public CreateConnectableCommand(ActivityContainer activityControl, Connection connection) {
            this.activityControl = activityControl;
            this.connection = connection;
        }

        public void execute() {
            this.connectable = this.createConnectable();
            this.oldConnectable = this.connection.getTarget();
            this.connection.detachTarget();
            this.connection.setTarget(this.connectable);
            this.newConnection = new Connection();
            this.newConnection.setSource(this.connectable);
            this.newConnection.setTarget(this.oldConnectable);
            this.executeCreation(this.connectable, this.oldConnectable);
        }

        public void undo() {
            this.newConnection.detachSource();
            this.newConnection.detachTarget();
            this.connection.setTarget(this.oldConnectable);
            this.executeRemove(this.connectable);
        }

        protected abstract ConnectableModel createConnectable();

        protected abstract void executeCreation(ConnectableModel var1, ConnectableModel var2);

        protected abstract void executeRemove(ConnectableModel var1);
    }

    private class CreateFlowInvocationCommand
    extends CreateConnectableCommand {
        public CreateFlowInvocationCommand(ActivityContainer activityControl, Connection connection) {
            super(activityControl, connection);
        }

        protected ConnectableModel createConnectable() {
            return this.activityControl.createFlowInvocation();
        }

        protected void executeCreation(ConnectableModel connectable, ConnectableModel targetConnectable) {
            this.activityControl.addFlowInvocation((FlowInvocation)connectable, (Activity)targetConnectable);
        }

        protected void executeRemove(ConnectableModel connectable) {
            this.activityControl.removeFlowInvocation((FlowInvocation)connectable);
        }
    }

    private class CreateJunctionCommand
    extends CreateConnectableCommand {
        public CreateJunctionCommand(ActivityContainer activityControl, Connection connection) {
            super(activityControl, connection);
        }

        protected ConnectableModel createConnectable() {
            return this.activityControl.createJunction();
        }

        protected void executeCreation(ConnectableModel connectable, ConnectableModel targetConnectable) {
            this.activityControl.addJunction((Junction)connectable, (Activity)targetConnectable);
        }

        protected void executeRemove(ConnectableModel connectable) {
            this.activityControl.removeJunction((Junction)connectable);
        }
    }

    private class CreateLoopCommand
    extends CreateConnectableCommand {
        public CreateLoopCommand(ActivityContainer activityControl, Connection connection) {
            super(activityControl, connection);
        }

        protected ConnectableModel createConnectable() {
            return this.activityControl.createLoop();
        }

        protected void executeCreation(ConnectableModel connectable, ConnectableModel targetConnectable) {
            this.activityControl.addLoop((Loop)connectable, (Activity)targetConnectable);
        }

        protected void executeRemove(ConnectableModel connectable) {
            this.activityControl.removeLoop((Loop)connectable);
        }
    }

    private class CreateStepCommand
    extends CreateConnectableCommand {
        public CreateStepCommand(ActivityContainer activityControl, Connection connection) {
            super(activityControl, connection);
        }

        protected ConnectableModel createConnectable() {
            return this.activityControl.createStep();
        }

        protected void executeCreation(ConnectableModel connectable, ConnectableModel targetConnectable) {
            this.activityControl.addStep((Step)connectable, (Activity)targetConnectable);
        }

        protected void executeRemove(ConnectableModel connectable) {
            this.activityControl.removeStep((Step)connectable);
        }
    }

    private class ProgressLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private ProgressLayoutEditPolicy() {
        }

        protected Command getCreateCommand(CreateRequest request) {
            CreateConnectableCommand command = null;
            Object type = request.getNewObjectType();
            Connection connection = (Connection)ProgressEditPart.this.getModel();
            ActivityContainer activityControl = (ActivityContainer)ProgressEditPart.this.getTarget().getParent().getModel();
            if (type.equals(Step.class)) {
                command = new CreateStepCommand(activityControl, connection);
            } else if (type.equals(Junction.class)) {
                command = new CreateJunctionCommand(activityControl, connection);
            } else if (type.equals(Loop.class)) {
                command = new CreateLoopCommand(activityControl, connection);
            } else if (type.equals(FlowInvocation.class)) {
                command = new CreateFlowInvocationCommand(activityControl, connection);
            }
            return command;
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            return null;
        }
    }
}

