/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.beanflow.figure.StatementFigure;
import jp.nimbus.ide.beanflow.model.Flow;
import jp.nimbus.ide.beanflow.model.Resource;
import jp.nimbus.ide.editpart.EditableModelEditPart;
import jp.nimbus.ide.util.WorkbenchUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class ResourceEditPart
extends EditableModelEditPart {
    protected IFigure createFigure() {
        Resource resource = (Resource)this.getModel();
        StatementFigure figure = new StatementFigure(resource.getName(), Resources.getImage("_icon_resource"));
        figure.setShortenedValue(false);
        figure.setValue(resource.getService());
        figure.setFont(WorkbenchUtil.getShell().getFont());
        Dimension size = figure.getPreferredSize();
        resource.setSize(size.width, size.height);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ResourceEditPolicy());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_bounds")) {
            this.refreshBounds();
        } else if (propertyName.equals("_name")) {
            StatementFigure figure = (StatementFigure)this.getFigure();
            figure.setName((String)event.getNewValue());
            this.updateModelBounds();
        } else if (propertyName.equals("_service")) {
            StatementFigure figure = (StatementFigure)this.getFigure();
            figure.setValue((String)event.getNewValue());
            this.updateModelBounds();
        }
    }

    private class DeleteCommand
    extends Command {
        private Flow flow;
        private Resource resource;

        public DeleteCommand(Flow flow, Resource resource) {
            this.flow = flow;
            this.resource = resource;
        }

        public void execute() {
            this.flow.removeResource(this.resource);
        }

        public void undo() {
            this.flow.addResource(this.resource);
        }
    }

    private class EditNameCommand
    extends Command {
        private Resource resource;
        private String name;
        private String oldName;

        public EditNameCommand(Resource resource, String name) {
            this.resource = resource;
            this.name = name;
        }

        public void execute() {
            this.oldName = this.resource.getName();
            this.resource.setName(this.name);
        }

        public void undo() {
            this.resource.setName(this.oldName);
        }
    }

    private class EditServiceCommand
    extends Command {
        private Resource resource;
        private String expression;
        private String oldExpression;

        public EditServiceCommand(Resource resource, String expression) {
            this.resource = resource;
            this.expression = expression;
        }

        public void execute() {
            this.oldExpression = this.resource.getService();
            this.resource.setService(this.expression);
        }

        public void undo() {
            this.resource.setService(this.oldExpression);
        }
    }

    private class ResourceEditPolicy
    extends ComponentEditPolicy {
        private ResourceEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            command = type.equals("_edit_values") ? this.createEditNameCommand(request) : (type.equals("_reference_service") ? this.createEditServiceCommand(request) : super.getCommand(request));
            return command;
        }

        private Command createEditNameCommand(Request request) {
            String name = (String)request.getExtendedData().get("_data_expression");
            Resource resource = (Resource)ResourceEditPart.this.getModel();
            return new EditNameCommand(resource, name);
        }

        private Command createEditServiceCommand(Request request) {
            Resource resource = (Resource)ResourceEditPart.this.getModel();
            String expression = (String)request.getExtendedData().get("_data_expression");
            return new EditServiceCommand(resource, expression);
        }

        protected Command createDeleteCommand(GroupRequest request) {
            Flow flow = (Flow)ResourceEditPart.this.getParent().getModel();
            Resource resource = (Resource)ResourceEditPart.this.getModel();
            return new DeleteCommand(flow, resource);
        }
    }
}

