/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.nimbus.ide.beanflow.action.MethodExpression;
import jp.nimbus.ide.beanflow.figure.ResultFigure;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.beanflow.model.Attribute;
import jp.nimbus.ide.beanflow.model.Invocation;
import jp.nimbus.ide.beanflow.model.Result;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.dialog.InvocationSelectionDialog;
import jp.nimbus.ide.editpart.EditableModelEditPart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultEditPart
extends EditableModelEditPart {
    protected IFigure createFigure() {
        Result result = (Result)this.getModel();
        ResultFigure figure = new ResultFigure(result){

            public void add(IFigure figure, Object constraint, int index) {
                super.add(figure, constraint, index);
                if (ResultFigure.isInvocationFigure(figure)) {
                    ResultEditPart.this.updateParentBounds();
                }
            }

            public void remove(IFigure figure) {
                super.remove(figure);
                if (ResultFigure.isInvocationFigure(figure)) {
                    ResultEditPart.this.updateParentBounds();
                }
            }
        };
        return figure;
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        Result result = (Result)this.getModel();
        children.addAll(result.getInvocationList());
        return children;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ResultLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ResultEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_bounds")) {
            this.refreshBounds();
        } else if (propertyName.equals("_value")) {
            this.refreshChildren();
        } else if (propertyName.equals("_attribute") || propertyName.equals("_invocation")) {
            this.refreshChildren();
            this.updateModelBounds();
        }
    }

    private class DeleteCommand
    extends Command {
        private Step step;
        private Result result;

        public DeleteCommand(Step step, Result result) {
            this.step = step;
            this.result = result;
        }

        public void execute() {
            this.step.removeResult(this.result);
        }

        public void undo() {
            this.step.setResult(this.result);
        }
    }

    private class EditInvocationCommand
    extends Command {
        private Result result;
        private InvocationSelectionDialog.InvocationType invocationType;
        private MethodExpression methodExpression;
        private String indexerExp;
        private Object invocation;

        public EditInvocationCommand(Result result, InvocationSelectionDialog.InvocationType invocationType, MethodExpression methodExpression, String indexerExp) {
            this.result = result;
            this.invocationType = invocationType;
            this.methodExpression = methodExpression;
            this.indexerExp = indexerExp;
        }

        public void execute() {
            String methodName = this.methodExpression.getName();
            String[] parameterTypeExps = this.methodExpression.getParameterTypes();
            if (this.invocationType == InvocationSelectionDialog.InvocationType.Property) {
                methodName = methodName.substring("set".length());
                if (this.indexerExp != null) {
                    methodName = String.valueOf(methodName) + this.indexerExp;
                }
                Attribute attribute = this.result.createAttribute();
                attribute.setName(methodName);
                attribute.setType(parameterTypeExps[0]);
                this.result.addAttribute(attribute);
                this.invocation = attribute;
            } else if (this.invocationType == InvocationSelectionDialog.InvocationType.Method) {
                Invocation invocation = this.result.createInvocation();
                invocation.setName(methodName);
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                String[] stringArray = parameterTypeExps;
                int n = parameterTypeExps.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterTypeExp = stringArray[n2];
                    Argument argument = invocation.createArgument();
                    argument.setType(parameterTypeExp);
                    arguments.add(argument);
                    ++n2;
                }
                invocation.setArguments(arguments);
                this.result.addInvocation(invocation);
                this.invocation = invocation;
            }
        }

        public void undo() {
            if (this.invocationType == InvocationSelectionDialog.InvocationType.Property) {
                this.result.removeAttribute((Attribute)this.invocation);
            } else if (this.invocationType == InvocationSelectionDialog.InvocationType.Method) {
                this.result.removeInvocation((Invocation)this.invocation);
            }
        }
    }

    private class ResultEditPolicy
    extends ComponentEditPolicy {
        private ResultEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            command = type.equals("_add_property") || type.equals("_add_method") ? this.createEditInvocationCommand(request) : super.getCommand(request);
            return command;
        }

        private Command createEditInvocationCommand(Request request) {
            Result result = (Result)ResultEditPart.this.getModel();
            Map data = request.getExtendedData();
            MethodExpression methodExpression = (MethodExpression)data.get("_data_expression");
            InvocationSelectionDialog.InvocationType invocationType = (InvocationSelectionDialog.InvocationType)((Object)data.get("_data_type"));
            String indexerExp = (String)data.get("_data_indexer");
            return new EditInvocationCommand(result, invocationType, methodExpression, indexerExp);
        }

        protected Command getDeleteCommand(GroupRequest request) {
            Step step = (Step)ResultEditPart.this.getParent().getModel();
            Result result = (Result)ResultEditPart.this.getModel();
            return new DeleteCommand(step, result);
        }
    }

    private class ResultLayoutEditPolicy
    extends LayoutEditPolicy {
        private ResultLayoutEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new NonResizableEditPolicy();
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command getMoveChildrenCommand(Request request) {
            return null;
        }
    }
}

