/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.nimbus.ide.ProjectHandler;
import jp.nimbus.ide.beanflow.action.MethodExpression;
import jp.nimbus.ide.beanflow.action.StaticMethodExpression;
import jp.nimbus.ide.beanflow.figure.StepFigure;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.ActivityContainer;
import jp.nimbus.ide.beanflow.model.Argument;
import jp.nimbus.ide.beanflow.model.Attribute;
import jp.nimbus.ide.beanflow.model.Invocation;
import jp.nimbus.ide.beanflow.model.ReferenceType;
import jp.nimbus.ide.beanflow.model.Result;
import jp.nimbus.ide.beanflow.model.StaticInvocation;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.dialog.InvocationSelectionDialog;
import jp.nimbus.ide.editpart.ConnectableModelEditPart;
import jp.nimbus.ide.editpart.ConnectableModelEditPolicy;
import jp.nimbus.ide.model.ConnectableModel;
import jp.nimbus.ide.model.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepEditPart
extends ConnectableModelEditPart {
    protected IFigure createFigure() {
        Step step = (Step)this.getModel();
        StepFigure figure = new StepFigure(step){

            public void add(IFigure figure, Object constraint, int index) {
                super.add(figure, constraint, index);
                if (StepFigure.isInvocationFigure(figure)) {
                    StepEditPart.this.updateModelBounds();
                }
            }

            public void remove(IFigure figure) {
                super.remove(figure);
                if (StepFigure.isInvocationFigure(figure)) {
                    StepEditPart.this.updateModelBounds();
                }
            }
        };
        return figure;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("_bounds")) {
            this.refreshBounds();
        } else if (propertyName.equals("_source_connection")) {
            this.refreshSourceConnections();
        } else if (propertyName.equals("_target_connection")) {
            this.refreshTargetConnections();
        } else if (propertyName.equals("_name")) {
            StepFigure figure = (StepFigure)this.getFigure();
            figure.setName((String)event.getNewValue());
            this.updateModelBounds();
        } else if (propertyName.equals("_target")) {
            StepFigure figure = (StepFigure)this.getFigure();
            figure.setTarget((Target)event.getNewValue());
            this.updateModelBounds();
        } else if (propertyName.equals("_attribute") || propertyName.equals("_invocation") || propertyName.equals("_static_invocation") || propertyName.equals("_result")) {
            this.refreshChildren();
            this.updateModelBounds();
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        Step step = (Step)this.getModel();
        children.addAll(step.getInvocationList());
        Result result = step.getResult();
        if (result != null) {
            children.add(result);
        }
        return children;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new StepLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new StepEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ConnectableModelEditPolicy());
    }

    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            this.handleMouseDoubleClick();
        }
        super.performRequest(req);
    }

    private void handleMouseDoubleClick() {
        ReferenceType targetType;
        Target target = ((Step)this.getModel()).getTarget();
        if (target != null && (targetType = target.getReferenceType()) == ReferenceType.Object) {
            IJavaProject javaProject = ProjectHandler.getCurrentProject();
            IType type = null;
            try {
                type = javaProject.findType(target.getExpression());
            }
            catch (JavaModelException javaModelException) {}
            try {
                JavaUI.openInEditor((IJavaElement)type);
            }
            catch (Exception exception) {}
        }
    }

    private class CreateResultCommand
    extends Command {
        private Step step;
        private Result result;

        public CreateResultCommand(Step step) {
            this.step = step;
        }

        public void execute() {
            this.result = this.step.createResult();
            this.result.setValue(ReferenceType.This, null);
            this.step.setResult(this.result);
        }

        public void undo() {
            this.step.removeResult(this.result);
        }
    }

    private class DeleteCommand
    extends Command {
        private ActivityContainer activityContainer;
        private Step step;
        private Connection sourceConnection;
        private Connection targetConnection;

        public DeleteCommand(ActivityContainer activityContainer, Step step) {
            this.activityContainer = activityContainer;
            this.step = step;
        }

        public void execute() {
            this.sourceConnection = this.step.getSourceConnections().get(0);
            ConnectableModel target = this.sourceConnection.getTarget();
            this.sourceConnection.detachSource();
            this.sourceConnection.detachTarget();
            this.targetConnection = this.step.getTargetConnections().get(0);
            this.targetConnection.detachTarget();
            this.targetConnection.setTarget(target);
            this.activityContainer.removeStep(this.step);
        }

        public void undo() {
            Activity target = (Activity)this.targetConnection.getTarget();
            this.targetConnection.detachTarget();
            this.targetConnection.setTarget(this.step);
            this.sourceConnection.setSource(this.step);
            this.sourceConnection.setTarget(target);
            this.activityContainer.addStep(this.step, target);
        }
    }

    private class EditInvocationCommand
    extends Command {
        private Step step;
        private InvocationSelectionDialog.InvocationType invocationType;
        private MethodExpression methodExpression;
        private String indexerExp;
        private Object invocation;

        public EditInvocationCommand(Step step, InvocationSelectionDialog.InvocationType invocationType, MethodExpression methodExpression, String indexerExp) {
            this.step = step;
            this.invocationType = invocationType;
            this.methodExpression = methodExpression;
            this.indexerExp = indexerExp;
        }

        public boolean canExecute() {
            return this.step.getTarget() != null;
        }

        public void execute() {
            String methodName = this.methodExpression.getName();
            String[] parameterTypes = this.methodExpression.getParameterTypes();
            if (this.invocationType == InvocationSelectionDialog.InvocationType.Property) {
                methodName = methodName.substring("set".length());
                if (this.indexerExp != null) {
                    methodName = String.valueOf(methodName) + this.indexerExp;
                }
                Attribute attribute = this.step.createAttribute();
                attribute.setName(methodName);
                attribute.setType(parameterTypes[0]);
                this.step.addAttribute(attribute);
                this.invocation = attribute;
            } else if (this.invocationType == InvocationSelectionDialog.InvocationType.Method) {
                Invocation invocation = this.step.createInvocation();
                invocation.setName(methodName);
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                String[] stringArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterTypeExp = stringArray[n2];
                    Argument argument = invocation.createArgument();
                    argument.setType(parameterTypeExp);
                    arguments.add(argument);
                    ++n2;
                }
                invocation.setArguments(arguments);
                this.step.addInvocation(invocation);
                this.invocation = invocation;
            }
        }

        public void undo() {
            if (this.invocationType == InvocationSelectionDialog.InvocationType.Property) {
                this.step.removeAttribute((Attribute)this.invocation);
            } else if (this.invocationType == InvocationSelectionDialog.InvocationType.Method) {
                this.step.removeInvocation((Invocation)this.invocation);
            }
        }
    }

    private class EditNameCommand
    extends Command {
        private Step step;
        private String name;
        private String oldName;

        public EditNameCommand(Step step, String name) {
            this.step = step;
            this.name = name;
        }

        public void execute() {
            this.oldName = this.step.getName();
            this.step.setName(this.name);
        }

        public void undo() {
            this.step.setName(this.oldName);
        }
    }

    private class EditStaticInvocationCommand
    extends Command {
        private Step step;
        private StaticMethodExpression methodExpression;
        private StaticInvocation staticInvocation;

        public EditStaticInvocationCommand(Step step, StaticMethodExpression methodExpression) {
            this.step = step;
            this.methodExpression = methodExpression;
        }

        public void execute() {
            String type = this.methodExpression.getType();
            String methodName = this.methodExpression.getName();
            String[] parameterTypes = this.methodExpression.getParameterTypes();
            StaticInvocation staticInvocation = this.step.createStaticInvocation();
            staticInvocation.setCode(type);
            staticInvocation.setName(methodName);
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            String[] stringArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterTypeExp = stringArray[n2];
                Argument argument = staticInvocation.createArgument();
                argument.setType(parameterTypeExp);
                arguments.add(argument);
                ++n2;
            }
            staticInvocation.setArguments(arguments);
            this.step.addStaticInvocation(staticInvocation);
            this.staticInvocation = staticInvocation;
        }

        public void undo() {
            this.step.removeStaticInvocation(this.staticInvocation);
        }
    }

    private class EditTargetCommand
    extends Command {
        private Step step;
        private ReferenceType type;
        private String expression;
        private Target oldTarget;

        public EditTargetCommand(Step step, ReferenceType type, String expression) {
            this.step = step;
            this.type = type;
            this.expression = expression;
        }

        public void execute() {
            this.oldTarget = this.step.getTarget();
            Target target = this.step.createTarget();
            target.setExpression(this.type, this.expression);
            this.step.setTarget(target);
        }

        public void undo() {
            this.step.setTarget(this.oldTarget);
        }
    }

    private class StepEditPolicy
    extends ComponentEditPolicy {
        private StepEditPolicy() {
        }

        public Command getCommand(Request request) {
            Command command = null;
            Object type = request.getType();
            command = type.equals("_edit_values") ? this.createEditNameCommand(request) : (type.equals("_reference_object") || type.equals("_reference_service") || type.equals("_reference_resource") || type.equals("_reference_step") ? this.createEditTargetCommand(request) : (type.equals("_add_static_method") ? this.createEditStaticInvocationCommand(request) : (type.equals("_add_property") || type.equals("_add_method") ? this.createEditInvocationCommand(request) : (type.equals("_add_result") ? this.createEditResultCommand(request) : super.getCommand(request)))));
            return command;
        }

        private Command createEditNameCommand(Request request) {
            String name = (String)request.getExtendedData().get("_data_expression");
            Step step = (Step)StepEditPart.this.getModel();
            return new EditNameCommand(step, name);
        }

        private Command createEditTargetCommand(Request request) {
            ReferenceType type = (ReferenceType)((Object)request.getExtendedData().get("_data_type"));
            String expression = (String)request.getExtendedData().get("_data_expression");
            Step step = (Step)StepEditPart.this.getModel();
            return new EditTargetCommand(step, type, expression);
        }

        private Command createEditInvocationCommand(Request request) {
            Step step = (Step)StepEditPart.this.getModel();
            Map data = request.getExtendedData();
            MethodExpression methodExpression = (MethodExpression)data.get("_data_expression");
            InvocationSelectionDialog.InvocationType invocationType = (InvocationSelectionDialog.InvocationType)((Object)data.get("_data_type"));
            String indexerExp = (String)data.get("_data_indexer");
            return new EditInvocationCommand(step, invocationType, methodExpression, indexerExp);
        }

        private Command createEditStaticInvocationCommand(Request request) {
            Step step = (Step)StepEditPart.this.getModel();
            Map data = request.getExtendedData();
            StaticMethodExpression methodExpression = (StaticMethodExpression)data.get("_data_expression");
            return new EditStaticInvocationCommand(step, methodExpression);
        }

        private Command createEditResultCommand(Request request) {
            Step step = (Step)StepEditPart.this.getModel();
            return new CreateResultCommand(step);
        }

        protected Command createDeleteCommand(GroupRequest request) {
            ActivityContainer activityContainer = (ActivityContainer)StepEditPart.this.getParent().getModel();
            Step step = (Step)StepEditPart.this.getModel();
            return new DeleteCommand(activityContainer, step);
        }
    }

    private class StepLayoutEditPolicy
    extends LayoutEditPolicy {
        private StepLayoutEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new NonResizableEditPolicy();
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command getMoveChildrenCommand(Request request) {
            return null;
        }
    }
}

