/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.figure;

import jp.nimbus.ide.beanflow.figure.InvocationFigure;
import jp.nimbus.ide.beanflow.figure.ResultFigure;
import jp.nimbus.ide.beanflow.figure.StatementFigure;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.beanflow.model.Target;
import jp.nimbus.ide.figure.RoundedRectangle;
import jp.nimbus.ide.util.WorkbenchUtil;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class StepFigure
extends RoundedRectangle {
    private Label nameLabel;
    private IFigure targetFigure;
    private IFigure invocationFigure;
    private Label targetLabel;

    public StepFigure(Step step) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayoutManager((LayoutManager)layout);
        Label label = new Label(step.getName());
        Font defaultFont = WorkbenchUtil.getShell().getFont();
        FontData defaultFontData = defaultFont.getFontData()[0];
        Font nameFont = new Font(defaultFont.getDevice(), defaultFontData.getName(), defaultFontData.getHeight(), 1);
        label.setFont(nameFont);
        this.nameLabel = label;
        this.add((IFigure)label);
        this.targetFigure = new Figure();
        layout = new GridLayout(1, false);
        layout.marginWidth = 16;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.targetFigure.setLayoutManager((LayoutManager)layout);
        this.add(this.targetFigure);
        this.invocationFigure = new Figure();
        layout = new GridLayout(1, false);
        layout.marginWidth = 32;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.invocationFigure.setLayoutManager((LayoutManager)layout);
        this.add(this.invocationFigure);
        this.createTargetLabel(step);
        Dimension dimension = this.getPreferredSize();
        step.setSize(dimension.width, dimension.height);
    }

    public void setName(String name) {
        this.nameLabel.setText(name);
    }

    protected void createTargetLabel(Step step) {
        Target target = step.getTarget();
        this.setTarget(target);
    }

    public void setTarget(Target target) {
        if (target != null) {
            if (this.targetLabel == null) {
                this.targetLabel = new Label();
                this.targetLabel.setFont(WorkbenchUtil.getShell().getFont());
                this.targetFigure.add((IFigure)this.targetLabel);
            }
            Image image = target.getReferenceType().getImage();
            String expression = target.getExpression();
            this.targetLabel.setIcon(image);
            this.targetLabel.setText(expression);
        } else if (this.targetLabel != null) {
            this.targetFigure.remove((IFigure)this.targetLabel);
        }
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (StepFigure.isInvocationFigure(figure)) {
            this.invocationFigure.add(figure);
        } else {
            super.add(figure, constraint, index);
        }
    }

    public void remove(IFigure figure) {
        if (StepFigure.isInvocationFigure(figure)) {
            this.invocationFigure.remove(figure);
        } else {
            super.remove(figure);
        }
    }

    public static boolean isInvocationFigure(IFigure figure) {
        return figure instanceof StatementFigure || figure instanceof InvocationFigure || figure instanceof ResultFigure;
    }
}

