/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.model;

import java.util.ArrayList;
import java.util.List;
import jp.nimbus.ide.beanflow.model.Activity;
import jp.nimbus.ide.beanflow.model.ActivityContainer;
import jp.nimbus.ide.beanflow.model.FlowInvocation;
import jp.nimbus.ide.beanflow.model.Junction;
import jp.nimbus.ide.beanflow.model.Loop;
import jp.nimbus.ide.beanflow.model.Step;
import jp.nimbus.ide.beanflow.model.Terminal;
import jp.nimbus.ide.model.AbstractModel;
import jp.nimbus.ide.model.Connection;
import jp.nimbus.ide.model.ElementModel;
import jp.nimbus.ide.xml.util.DocumentUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityCollection
extends AbstractModel
implements ActivityContainer {
    private static final String TAG_STEP = "step";
    private static final String TAG_IF = "if";
    private static final String TAG_FOR = "for";
    private static final String TAG_CALLFLOW = "callflow";
    public static final String STEP = "_step";
    public static final String JUNCTION = "_junction";
    public static final String LOOP = "_loop";
    public static final String FLOW_INVOCATION = "_flow_invocation";
    protected Element node;
    private List<Activity> activityList;
    private ActivityCollection parent;

    public ActivityCollection(Element node, boolean terminated, ActivityCollection parent) {
        this.node = node;
        this.parent = parent;
        this.createActivityList(terminated);
    }

    private void createActivityList(boolean terminated) {
        this.activityList = new ArrayList<Activity>();
        Activity prevActivity = null;
        if (terminated) {
            Terminal beginTerminal = new Terminal(Terminal.Type.Begin);
            this.activityList.add(beginTerminal);
            prevActivity = beginTerminal;
        }
        NodeList nodeList = this.node.getChildNodes();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                Element element = (Element)childNode;
                String tagName = element.getTagName();
                Activity activity = null;
                if (tagName.equals(TAG_STEP)) {
                    activity = new Step(element);
                } else if (tagName.equals(TAG_IF)) {
                    activity = new Junction(element, this);
                } else if (tagName.equals(TAG_FOR)) {
                    activity = new Loop(element, this);
                } else if (tagName.equals(TAG_CALLFLOW)) {
                    activity = new FlowInvocation(element);
                }
                if (activity != null) {
                    Connection connection = new Connection();
                    connection.setSource(prevActivity);
                    connection.setTarget(activity);
                    this.activityList.add(activity);
                    prevActivity = activity;
                }
            }
            ++i;
        }
        if (terminated) {
            Terminal endTerminal = new Terminal(Terminal.Type.End);
            this.activityList.add(endTerminal);
            Connection connection = new Connection();
            connection.setSource(prevActivity);
            connection.setTarget(endTerminal);
        }
    }

    @Override
    public List<Activity> getActivities() {
        return this.activityList;
    }

    public Activity searchActivity(String stepName) {
        return this.searchActivity(this.activityList, stepName);
    }

    private Activity searchActivity(List<Activity> activityList, String stepName) {
        Activity result = null;
        for (Activity activity : activityList) {
            FlowInvocation flowInvocation;
            if (activity instanceof ActivityContainer) {
                Activity childActivity = this.searchActivity(((ActivityContainer)((Object)activity)).getActivities(), stepName);
                if (childActivity == null) continue;
                result = childActivity;
                break;
            }
            if (activity instanceof Step) {
                Step step = (Step)activity;
                if (!stepName.equals(step.getName())) continue;
                result = step;
                break;
            }
            if (!(activity instanceof FlowInvocation) || !stepName.equals((flowInvocation = (FlowInvocation)activity).getStepName())) continue;
            result = flowInvocation;
            break;
        }
        return result;
    }

    @Override
    public ActivityContainer getParent() {
        return this.parent;
    }

    @Override
    public Step createStep() {
        Element element = DocumentUtil.createElement(this.node, TAG_STEP);
        Step step = new Step(element);
        step.setName(this.createNewStepName());
        return step;
    }

    @Override
    public void addStep(Step step, Activity targetActivity) {
        this.addActivity(step, targetActivity);
        this.firePropertyChange(STEP, null, step);
    }

    @Override
    public void removeStep(Step step) {
        this.removeActivity(step);
        this.firePropertyChange(STEP, step, null);
    }

    @Override
    public Junction createJunction() {
        Element element = DocumentUtil.createElement(this.node, TAG_IF);
        Junction junction = new Junction(element, this);
        return junction;
    }

    @Override
    public void addJunction(Junction junction, Activity targetActivity) {
        this.addActivity(junction, targetActivity);
        this.firePropertyChange(JUNCTION, null, junction);
    }

    @Override
    public void removeJunction(Junction junction) {
        this.removeActivity(junction);
        this.firePropertyChange(JUNCTION, junction, null);
    }

    @Override
    public Loop createLoop() {
        Element element = DocumentUtil.createElement(this.node, TAG_FOR);
        Loop loop = new Loop(element, this);
        return loop;
    }

    @Override
    public void addLoop(Loop loop, Activity targetActivity) {
        this.addActivity(loop, targetActivity);
        this.firePropertyChange(LOOP, null, loop);
    }

    @Override
    public void removeLoop(Loop loop) {
        this.removeActivity(loop);
        this.firePropertyChange(LOOP, loop, null);
    }

    @Override
    public FlowInvocation createFlowInvocation() {
        Element element = DocumentUtil.createElement(this.node, TAG_CALLFLOW);
        FlowInvocation flowInvocation = new FlowInvocation(element);
        flowInvocation.setStepName(this.createNewStepName());
        return flowInvocation;
    }

    @Override
    public void addFlowInvocation(FlowInvocation flowInvocation, Activity targetActivity) {
        this.addActivity(flowInvocation, targetActivity);
        this.firePropertyChange(FLOW_INVOCATION, null, flowInvocation);
    }

    @Override
    public void removeFlowInvocation(FlowInvocation flowInvocation) {
        this.removeActivity(flowInvocation);
        this.firePropertyChange(FLOW_INVOCATION, flowInvocation, null);
    }

    private void addActivity(Activity activity, Activity targetActivity) {
        if (targetActivity instanceof ElementModel) {
            this.node.insertBefore(((ElementModel)((Object)activity)).getNode(), ((ElementModel)((Object)targetActivity)).getNode());
        } else if (targetActivity instanceof Terminal) {
            this.node.appendChild(((ElementModel)((Object)activity)).getNode());
        }
        this.activityList.add(this.activityList.indexOf(targetActivity), activity);
    }

    private void removeActivity(Activity activity) {
        this.activityList.remove(activity);
        Element childNode = ((ElementModel)((Object)activity)).getNode();
        if (childNode != null) {
            this.node.removeChild(childNode);
        }
    }

    private String createNewStepName() {
        Sequence sequence = new Sequence();
        ActivityContainer rootActivityContainer = this.searchRootActivityContainer(this);
        this.searchStepNameSequence(rootActivityContainer.getActivities(), sequence);
        return "Step" + Integer.toString(sequence.value + 1);
    }

    private ActivityContainer searchRootActivityContainer(ActivityContainer activityContainer) {
        ActivityContainer parent = activityContainer.getParent();
        if (parent != null) {
            activityContainer = this.searchRootActivityContainer(parent);
        }
        return activityContainer;
    }

    private void searchStepNameSequence(List<Activity> activityList, Sequence sequence) {
        for (Activity existActivity : activityList) {
            if (existActivity instanceof Step) {
                int curSeq;
                String name = ((Step)existActivity).getName();
                if (!name.startsWith("Step") || name.length() <= "Step".length()) continue;
                String digitString = name.substring("Step".length(), name.length());
                boolean valid = true;
                int i = 0;
                while (i < digitString.length()) {
                    if (!Character.isDigit(digitString.charAt(i))) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
                if (!valid || (curSeq = Integer.parseInt(digitString)) <= sequence.value) continue;
                sequence.value = curSeq;
                continue;
            }
            if (!(existActivity instanceof ActivityContainer)) continue;
            this.searchStepNameSequence(((ActivityContainer)((Object)existActivity)).getActivities(), sequence);
        }
    }

    private class Sequence {
        private int value;

        private Sequence() {
        }
    }
}

