/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.beanflow.wizard;

import jp.nimbus.ide.Resources;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class BeanFlowWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "File";
    private static final String TITLE = "BeanFlow\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb";
    private static final String DESCRIPTION = "\u4f5c\u6210\u3059\u308bBeanFlow\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u306e\u5185\u5bb9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
    private static final String DEFAULT_FILE_NAME = "beanflow.xml";
    private Text containerText;
    private Text fileText;
    private Text beanflowText;
    private ISelection selection;

    public BeanFlowWizardPage(ISelection selection) {
        super(PAGE_NAME);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(Resources.getImageDescriptor("_icon_nimbus"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("\u30d5\u30a9\u30eb\u30c0");
        Composite container2 = new Composite(container, 0);
        GridData gd = new GridData(768);
        container2.setLayoutData((Object)gd);
        GridLayout layout2 = new GridLayout();
        container2.setLayout((Layout)layout2);
        layout2.numColumns = 2;
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        this.containerText = new Text(container2, 2052);
        gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanFlowWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeanFlowWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("\u30d5\u30a1\u30a4\u30eb\u540d");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanFlowWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("BeanFlow\u540d");
        this.beanflowText = new Text(container, 2052);
        gd = new GridData(768);
        this.beanflowText.setLayoutData((Object)gd);
        this.beanflowText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanFlowWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            String path = null;
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                path = container.getFullPath().toString();
            } else if (obj instanceof IJavaProject) {
                path = ((IJavaProject)obj).getPath().toString();
            }
            this.containerText.setText(path);
        }
        this.fileText.setText(DEFAULT_FILE_NAME);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        String beanflowName = this.getBeanflowName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("\u30d5\u30a9\u30eb\u30c0\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("\u30d5\u30a9\u30eb\u30c0\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("\u30d5\u30a9\u30eb\u30c0\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("\u6709\u52b9\u306a\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("xml")) {
            this.updateStatus("\u62e1\u5f35\u5b50\u306bxml\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        if (beanflowName.length() == 0) {
            this.updateStatus("BeanFlow\u540d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getBeanflowName() {
        return this.beanflowText.getText();
    }
}

