/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.dialog;

import java.util.ArrayList;
import jp.nimbus.ide.Resources;
import jp.nimbus.ide.widget.EditableTableViewer;
import jp.nimbus.ide.widget.ListViewer;
import jp.nimbus.ide.widget.MapViewer;
import jp.nimbus.ide.widget.RecordSetSchemaViewer;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class EditorDialog
extends SelectionStatusDialog {
    private static final int WIDTH = 480;
    private static final int HEIGHT = 300;
    private static final String TITLE = "\u7de8\u96c6";
    private String input;
    private EditorType editorType = EditorType.Text;
    private Composite layoutPanel;
    private StackLayout layout;
    private Viewer[] viewers = new Viewer[4];

    public EditorDialog(Shell parent, String input) {
        super(parent);
        this.input = input;
        this.setTitle(TITLE);
    }

    public void create() {
        super.create();
        this.getShell().setSize(480, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        this.createController(container);
        this.createViewer(container);
        return container;
    }

    private void createController(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        final Button button1 = new Button(composite, 0x800002);
        final Button button2 = new Button(composite, 0x800002);
        final Button button3 = new Button(composite, 0x800002);
        final Button button4 = new Button(composite, 0x800002);
        button1.setImage(Resources.getImage("_icon_text"));
        button1.setText("\u30d7\u30ec\u30fc\u30f3\u30c6\u30ad\u30b9\u30c8");
        button1.setSelection(true);
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button1.setSelection(true);
                button2.setSelection(false);
                button3.setSelection(false);
                button4.setSelection(false);
                EditorDialog.this.editorType = EditorType.Text;
                EditorDialog.this.changeView();
            }
        });
        button2.setImage(Resources.getImage("_icon_text"));
        button2.setText("\u30ea\u30b9\u30c8");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button1.setSelection(false);
                button2.setSelection(true);
                button3.setSelection(false);
                button4.setSelection(false);
                EditorDialog.this.editorType = EditorType.List;
                EditorDialog.this.changeView();
            }
        });
        button3.setImage(Resources.getImage("_icon_text"));
        button3.setText("\u30de\u30c3\u30d7");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button1.setSelection(false);
                button2.setSelection(false);
                button3.setSelection(true);
                button4.setSelection(false);
                EditorDialog.this.editorType = EditorType.Map;
                EditorDialog.this.changeView();
            }
        });
        button4.setImage(Resources.getImage("_icon_text"));
        button4.setText("\u30b9\u30ad\u30fc\u30de");
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button1.setSelection(false);
                button2.setSelection(false);
                button3.setSelection(false);
                button4.setSelection(true);
                EditorDialog.this.editorType = EditorType.RecordSetSchema;
                EditorDialog.this.changeView();
            }
        });
    }

    private void changeView() {
        int i = this.editorType.ordinal();
        this.layout.topControl = this.viewers[i].getControl();
        this.layoutPanel.layout();
    }

    private void createViewer(Composite parent) {
        this.layoutPanel = new Composite(parent, 0);
        this.layoutPanel.setLayoutData((Object)new GridData(1808));
        this.layout = new StackLayout();
        this.layoutPanel.setLayout((Layout)this.layout);
        TextViewer textViewer = new TextViewer(this.layoutPanel, 2050);
        textViewer.setDocument((IDocument)new Document(this.input));
        this.viewers[0] = textViewer;
        ListViewer listViewer = new ListViewer(this.layoutPanel, this.input);
        this.viewers[1] = listViewer;
        MapViewer mapViewer = new MapViewer(this.layoutPanel, this.input);
        this.viewers[2] = mapViewer;
        RecordSetSchemaViewer recordSetSchemaViewer = new RecordSetSchemaViewer(this.layoutPanel, this.input);
        this.viewers[3] = recordSetSchemaViewer;
        this.changeView();
    }

    protected void computeResult() {
        Object viewer;
        String output = null;
        if (this.editorType == EditorType.Text) {
            viewer = (TextViewer)this.viewers[this.editorType.ordinal()];
            IDocument document = viewer.getDocument();
            output = document.get();
        } else {
            viewer = (EditableTableViewer)this.viewers[this.editorType.ordinal()];
            output = ((EditableTableViewer)((Object)viewer)).getOutput();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(output);
        this.setResult(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EditorType {
        Text,
        List,
        Map,
        RecordSetSchema;

    }
}

