/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.editpart;

import jp.nimbus.ide.editpart.AbstractEditPart;
import jp.nimbus.ide.model.EditableModel;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public abstract class EditableModelEditPart
extends AbstractEditPart {
    protected void refreshVisuals() {
        super.registerVisuals();
        this.refreshBounds();
    }

    protected void refreshBounds() {
        Rectangle bounds = ((EditableModel)this.getModel()).getBounds();
        if (bounds != null) {
            GraphicalEditPart parentEditPart = (GraphicalEditPart)this.getParent();
            LayoutManager layoutManager = parentEditPart.getFigure().getLayoutManager();
            if (layoutManager instanceof GridLayout) {
                GridData gridData = (GridData)layoutManager.getConstraint(this.getFigure());
                if (gridData == null) {
                    gridData = new GridData();
                }
                gridData.widthHint = bounds.width;
                gridData.heightHint = bounds.height;
                parentEditPart.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)gridData);
            } else {
                parentEditPart.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds.getCopy());
            }
        }
    }

    protected void updateModelBounds() {
        EditableModel model = (EditableModel)this.getModel();
        IFigure figure = this.getFigure();
        Dimension currentSize = figure.getPreferredSize();
        model.setSize(currentSize.width, currentSize.height);
    }

    protected void updateParentBounds() {
        EditPart parentEditPart = this.getParent();
        if (parentEditPart instanceof EditableModelEditPart) {
            EditableModelEditPart editableModelEditPart = (EditableModelEditPart)parentEditPart;
            editableModelEditPart.updateModelBounds();
            editableModelEditPart.updateParentBounds();
        }
    }
}

