/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class RoundedRectangle
extends Shape {
    private Dimension corner = new Dimension(8, 8);

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.drawContents(graphics);
    }

    protected void fillShape(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        int oldAlpha = graphics.getAlpha();
        graphics.setAlpha(128);
        graphics.fillRoundRectangle(bounds, this.corner.width, this.corner.height);
        graphics.setAlpha(oldAlpha);
    }

    protected void outlineShape(Graphics graphics) {
        int oldAntialias = graphics.getAntialias();
        graphics.setAntialias(1);
        Color oldForegroundColor = graphics.getForegroundColor();
        graphics.setForegroundColor(new Color((Device)Display.getCurrent(), 128, 128, 128));
        Rectangle bounds = this.getBounds();
        Rectangle outlineBounds = Rectangle.SINGLETON;
        outlineBounds.x = bounds.x + this.lineWidth / 2;
        outlineBounds.y = bounds.y + this.lineWidth / 2;
        outlineBounds.width = bounds.width - this.lineWidth;
        outlineBounds.height = bounds.height - this.lineWidth;
        graphics.drawRoundRectangle(outlineBounds, this.corner.width, this.corner.height);
        graphics.setForegroundColor(oldForegroundColor);
        graphics.setAntialias(oldAntialias);
    }

    protected void drawContents(Graphics graphics) {
    }
}

