/*
 * Decompiled with CFR 0.152.
 */
package jp.nimbus.ide.widget;

import java.util.ArrayList;
import jp.nimbus.ide.widget.EditableTableViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RecordSetSchemaViewer
extends EditableTableViewer {
    public RecordSetSchemaViewer(Composite parent, String input) {
        super(parent, input);
        this.setupTable();
    }

    public String getOutput() {
        StringBuilder stringBuilder = new StringBuilder();
        TableItem[] tableItemArray = this.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            RecordSetSchema recordSetSchema = (RecordSetSchema)tableItem.getData();
            stringBuilder.append(recordSetSchema);
            stringBuilder.append("\n");
            ++n2;
        }
        int length = stringBuilder.length();
        stringBuilder.delete(length - "\n".length(), length);
        return stringBuilder.toString();
    }

    private void setupTable() {
        final Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("\u8ffd\u52a0"){

            public void run() {
                int newIndex = table.getItemCount();
                table.setItemCount(newIndex + 1);
                TableItem tableItem = table.getItem(newIndex);
                tableItem.setData((Object)new RecordSetSchema());
            }
        });
        menuManager.add((IAction)new Action("\u524a\u9664"){

            public void run() {
                table.remove(table.getSelectionIndex());
            }
        });
        table.setMenu(menuManager.createContextMenu((Control)table));
        TableColumn column = new TableColumn(table, 16384);
        column.setText("\u30c7\u30fc\u30bf\u540d");
        column.setWidth(160);
        column = new TableColumn(table, 0x1000000);
        column.setText("\u30c7\u30fc\u30bf\u578b");
        column.setWidth(80);
        column = new TableColumn(table, 131072);
        column.setText("\u30c7\u30fc\u30bf\u9577");
        column.setWidth(60);
        column = new TableColumn(table, 0x1000000);
        column.setText("\u5c5e\u6027");
        column.setWidth(60);
        column = new TableColumn(table, 0x1000000);
        column.setText("\u6697\u53f7\u5316");
        column.setWidth(60);
        this.setColumnProperties(RecordSetSchema.propertyNames);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, RecordSetDataType.getTextSelection()), new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, RecordSetColumnType.getTextSelection()), new CheckboxCellEditor((Composite)table)};
        this.setCellEditors(cellEditors);
        this.setCellModifier(new RecordSetCellModifier(this));
        this.setLabelProvider((IBaseLabelProvider)new RecordSetSchemaLabelProvider());
        this.setContentProvider((IContentProvider)new RecordSetSchemaContentProvider());
        this.setInput(this.input);
    }

    private class RecordSetCellModifier
    implements ICellModifier {
        private TableViewer tableViewer;

        public RecordSetCellModifier(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            RecordSetSchema recordSetSchema = (RecordSetSchema)element;
            return recordSetSchema.getValue(property);
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            RecordSetSchema recordSetSchema = (RecordSetSchema)tableItem.getData();
            recordSetSchema.setValue(property, value);
            this.tableViewer.update((Object)recordSetSchema, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RecordSetColumnType {
        Key("\u30ad\u30fc"),
        RowVersion("\u7248\u6570\u5217"),
        Update("\u66f4\u65b0\u5217"),
        Reference("\u53c2\u7167\u5217");

        private String expression;

        private RecordSetColumnType(String expression) {
            this.expression = expression;
        }

        public String toString() {
            return this.expression;
        }

        public static String[] getTextSelection() {
            return new String[]{Key.toString(), RowVersion.toString(), Update.toString(), Reference.toString()};
        }

        public static RecordSetColumnType valueOf(String string) {
            return Enum.valueOf(RecordSetColumnType.class, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RecordSetDataType {
        VARCHAR,
        CHAR,
        LONG,
        INT,
        FLOAT,
        DOUBLE,
        DATE,
        TIMESTAMP,
        BLOB,
        CLOB;


        public static String[] getTextSelection() {
            return new String[]{VARCHAR.toString(), CHAR.toString(), LONG.toString(), INT.toString(), FLOAT.toString(), DOUBLE.toString(), DATE.toString(), TIMESTAMP.toString(), BLOB.toString(), CLOB.toString()};
        }

        public static RecordSetDataType valueOf(String string) {
            return Enum.valueOf(RecordSetDataType.class, string);
        }
    }

    private static class RecordSetSchema {
        private static final String FIELD_DELIMITER = ",";
        private static final String SCHEMA_DELIMITER = "\n";
        private static final String FLAG_ON = "1";
        private static final String FLAG_OFF = "0";
        private static String[] propertyNames = new String[]{"name", "dataType", "length", "columnType", "encryption"};
        private String name = "";
        private RecordSetDataType dataType = RecordSetDataType.VARCHAR;
        private int length;
        private RecordSetColumnType columnType = RecordSetColumnType.Reference;
        private boolean encryption;

        public Object getValue(String propertyName) {
            Object result = null;
            if (propertyName.equals(propertyNames[0])) {
                result = this.name;
            } else if (propertyName.equals(propertyNames[1])) {
                result = this.dataType.ordinal();
            } else if (propertyName.equals(propertyNames[2])) {
                result = String.valueOf(this.length);
            } else if (propertyName.equals(propertyNames[3])) {
                result = this.columnType.ordinal();
            } else if (propertyName.equals(propertyNames[4])) {
                result = this.encryption;
            }
            return result;
        }

        public void setValue(String propertyName, Object value) {
            if (propertyName.equals(propertyNames[0])) {
                this.name = (String)value;
            } else if (propertyName.equals(propertyNames[1])) {
                this.dataType = RecordSetDataType.valueOf((Integer)value);
            } else if (propertyName.equals(propertyNames[2])) {
                this.length = Integer.valueOf((String)value);
            } else if (propertyName.equals(propertyNames[3])) {
                this.columnType = RecordSetColumnType.valueOf((Integer)value);
            } else if (propertyName.equals(propertyNames[4])) {
                this.encryption = (Boolean)value;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            stringBuilder.append(FIELD_DELIMITER);
            stringBuilder.append(this.dataType.toString());
            stringBuilder.append(FIELD_DELIMITER);
            stringBuilder.append(this.length);
            stringBuilder.append(FIELD_DELIMITER);
            stringBuilder.append(this.columnType.ordinal());
            stringBuilder.append(FIELD_DELIMITER);
            stringBuilder.append(this.encryption ? FLAG_ON : FLAG_OFF);
            return stringBuilder.toString();
        }
    }

    private class RecordSetSchemaContentProvider
    implements IStructuredContentProvider {
        private RecordSetSchemaContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            String[] lines;
            String text = (String)inputElement;
            ArrayList<RecordSetSchema> elementList = new ArrayList<RecordSetSchema>();
            String[] stringArray = lines = text.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] fields = line.trim().split(",");
                if (fields.length == 5) {
                    RecordSetSchema recordSetSchema = new RecordSetSchema();
                    recordSetSchema.name = fields[0].trim();
                    recordSetSchema.dataType = RecordSetDataType.valueOf(fields[1].trim());
                    recordSetSchema.length = Integer.valueOf(fields[2].trim());
                    recordSetSchema.columnType = RecordSetColumnType.valueOf(Integer.valueOf(fields[3].trim()));
                    recordSetSchema.encryption = fields[4].trim().equals("1");
                    elementList.add(recordSetSchema);
                }
                ++n2;
            }
            return elementList.toArray(new RecordSetSchema[elementList.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class RecordSetSchemaLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final String FLAG_ON = "ON";
        private static final String FLAG_OFF = "OFF";

        private RecordSetSchemaLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            RecordSetSchema recordSetSchema = (RecordSetSchema)element;
            switch (columnIndex) {
                case 0: {
                    text = recordSetSchema.name;
                    break;
                }
                case 1: {
                    text = recordSetSchema.dataType.toString();
                    break;
                }
                case 2: {
                    text = Integer.toString(recordSetSchema.length);
                    break;
                }
                case 3: {
                    text = recordSetSchema.columnType.toString();
                    break;
                }
                case 4: {
                    text = recordSetSchema.encryption ? FLAG_ON : FLAG_OFF;
                }
            }
            return text;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

