/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullIndexPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;

public class MappedProperty
extends SimpleProperty
implements Serializable {
    private static final String MSG_00001 = "Illegal MappedProperty : ";
    private static final String MSG_00002 = "Length of property literal must be not null.";
    protected static final String GET_METHOD_NAME = "get";
    protected static final Class[] GET_METHOD_ARGS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedProperty.class$("java.lang.String")) : class$java$lang$String};
    protected static final String SET_METHOD_NAME = "set";
    protected String key;
    protected transient Map mappedReadMethodCache = new HashMap();
    protected transient Map mappedWriteMethodCache = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public MappedProperty() {
    }

    public MappedProperty(String name) throws IllegalArgumentException {
        this.setPropertyName(name);
    }

    public MappedProperty(String name, String key) throws IllegalArgumentException {
        this.key = key;
        this.setPropertyName(name);
    }

    public String getPropertyName() {
        return super.getPropertyName() + '(' + this.key + ')';
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.property = prop;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int startMappedDelim = prop.indexOf(40);
        int endMappedDelim = prop.indexOf(41);
        if (startMappedDelim == -1 || endMappedDelim == -1 || endMappedDelim - startMappedDelim <= 1 || endMappedDelim != prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.key = prop.substring(startMappedDelim + 1, endMappedDelim);
        this.setPropertyName(prop.substring(0, startMappedDelim));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.getNoMappedProperty(obj, readMethod);
        }
        if (this.mappedReadMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.mappedReadMethodCache.get(clazz);
            return this.getMappedProperty(obj, readMethod);
        }
        if (this.property.length() == 0) {
            return this.getMappedObjectProperty(obj);
        }
        readMethod = this.getReadMappedMethod(clazz);
        if (readMethod == null) {
            Object prop = super.getProperty(obj);
            if (prop == null) {
                throw new NoSuchPropertyException(clazz, this.property);
            }
            return this.getMappedObjectProperty(prop);
        }
        this.mappedReadMethodCache.put(clazz, readMethod);
        return this.getMappedProperty(obj, readMethod);
    }

    protected Object getMappedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            return readMethod.invoke(obj, this.key);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    protected Object getNoMappedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object mappedObj = null;
        try {
            mappedObj = readMethod.invoke(obj, NULL_ARGS);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        if (mappedObj == null) {
            throw new NullIndexPropertyException(clazz, this.property);
        }
        return this.getMappedObjectProperty(mappedObj);
    }

    protected Object getMappedObjectProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.get(this.key);
        }
        Class<?> mappedClazz = obj.getClass();
        Method getMethod = null;
        try {
            getMethod = mappedClazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchPropertyException(mappedClazz, this.property);
        }
        if (Modifier.isPublic(getMethod.getModifiers())) {
            try {
                return getMethod.invoke(obj, this.key);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(mappedClazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(mappedClazz, this.property, e);
            }
        }
        throw new NoSuchPropertyException(mappedClazz, this.property);
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        Method writeMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            this.setNoMappedProperty(obj, readMethod, value);
        } else if (this.mappedWriteMethodCache.containsKey(clazz)) {
            writeMethod = (Method)this.mappedWriteMethodCache.get(clazz);
            this.setMappedProperty(obj, writeMethod, value);
        } else if (this.property.length() == 0) {
            this.setMappedObjectProperty(obj, value);
        } else {
            writeMethod = this.getWriteMappedMethod(clazz, value == null ? null : value.getClass());
            if (writeMethod == null) {
                Object prop = super.getProperty(obj);
                if (prop == null) {
                    throw new NoSuchPropertyException(clazz, this.property);
                }
                this.setMappedObjectProperty(prop, value);
            } else {
                this.mappedWriteMethodCache.put(clazz, writeMethod);
                this.setMappedProperty(obj, writeMethod, value);
            }
        }
    }

    protected void setMappedProperty(Object obj, Method writeMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            writeMethod.invoke(obj, this.key, value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    protected void setNoMappedProperty(Object obj, Method readMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object mappedObj = null;
        try {
            mappedObj = readMethod.invoke(obj, NULL_ARGS);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        if (mappedObj == null) {
            throw new NullIndexPropertyException(clazz, this.property);
        }
        this.setMappedObjectProperty(mappedObj, value);
    }

    protected void setMappedObjectProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> mappedClazz = obj.getClass();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(this.key, value);
        } else {
            Method setMethod = null;
            Class<?> valueClass = value == null ? null : value.getClass();
            Method[] methods = mappedClazz.getMethods();
            if (methods == null || methods.length == 0) {
                throw new NoSuchPropertyException(mappedClazz, this.property);
            }
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName())) continue;
                Class<?>[] params = method.getParameterTypes();
                if (!Modifier.isPublic(method.getModifiers()) || params == null || params.length != 2 || !params[0].equals(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String) || valueClass != null && !params[1].isAssignableFrom(valueClass) || setMethod != null && !setMethod.getParameterTypes()[1].isAssignableFrom(params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                throw new NoSuchPropertyException(mappedClazz, this.property);
            }
            if (Modifier.isPublic(setMethod.getModifiers())) {
                try {
                    setMethod.invoke(obj, this.key, value);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(mappedClazz, this.property, e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(mappedClazz, this.property, e);
                }
            } else {
                throw new NoSuchPropertyException(mappedClazz, this.property);
            }
        }
    }

    protected Method getReadMappedMethod(Class clazz) {
        if (!this.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getReadMappedMethod(interfaces[i]);
                if (method == null) continue;
                return method;
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(GET_METHOD_NAME);
        if (this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        try {
            return clazz.getMethod(methodName.toString(), GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected Method getWriteMappedMethod(Class clazz, Class param) {
        if (!this.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getWriteMappedMethod(interfaces[i], param);
                if (method == null) continue;
                return method;
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(SET_METHOD_NAME);
        if (this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        Method setMethod = null;
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!methodName.toString().equals(method.getName())) continue;
            Class<?>[] params = method.getParameterTypes();
            if (!Modifier.isPublic(method.getModifiers()) || params == null || params.length != 2 || !params[0].equals(class$java$lang$String == null ? MappedProperty.class$("java.lang.String") : class$java$lang$String) || param != null && !params[1].isAssignableFrom(param) || setMethod != null && !setMethod.getParameterTypes()[1].isAssignableFrom(params[1])) continue;
            setMethod = method;
        }
        return setMethod;
    }

    public String toString() {
        return "MappedProperty{" + this.property + '(' + this.key + ")}";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
        this.mappedReadMethodCache = new HashMap();
        this.mappedWriteMethodCache = new HashMap();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

