/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ossc.nimbus.core.DefaultLogMetaData;
import jp.ossc.nimbus.core.DefaultServiceLoaderServiceMBean;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServerMetaData;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.repository.Repository;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultServiceLoaderService
extends ServiceBase
implements ServiceLoader,
DefaultServiceLoaderServiceMBean {
    private static final String SVCL_ = "SVCL_";
    private static final String SVCL_0 = "SVCL_0";
    private static final String SVCL_00 = "SVCL_00";
    private static final String SVCL_000 = "SVCL_000";
    private static final String SVCL_0000 = "SVCL_0000";
    private static final String SVCL_00001 = "SVCL_00001";
    private static final String SVCL_00002 = "SVCL_00002";
    private static final String SVCL_00003 = "SVCL_00003";
    private static final String SVCL_00004 = "SVCL_00004";
    private static final String SVCL_00005 = "SVCL_00005";
    private static final String SVCL_00006 = "SVCL_00006";
    private static final String SVCL_00007 = "SVCL_00007";
    private static final String SVCL_00008 = "SVCL_00008";
    private static final String SVCL_00009 = "SVCL_00009";
    private static final String SVCL_00010 = "SVCL_00010";
    private static final String SVCL_00011 = "SVCL_00011";
    private static final String SVCL_00012 = "SVCL_00012";
    private static final String SVCL_00013 = "SVCL_00013";
    private static final String SVCL_00014 = "SVCL_00014";
    private static final String SVCL_00015 = "SVCL_00015";
    private static final String SVCL_00016 = "SVCL_00016";
    private static final String SVCL_00017 = "SVCL_00017";
    private static final String SVCL_00018 = "SVCL_00018";
    private static final String SVCL_00019 = "SVCL_00019";
    private static final String SVCL_00020 = "SVCL_00020";
    private static final String SVCL_00021 = "SVCL_00021";
    private static final String SVCL_00022 = "SVCL_00022";
    private static final String SVCL_00023 = "SVCL_00023";
    private static final String SVCL_00024 = "SVCL_00024";
    private static final String SVCL_00025 = "SVCL_00025";
    private static final String SVCL_00026 = "SVCL_00026";
    private static final String SVCL_00027 = "SVCL_00027";
    private static final String SVCL_00028 = "SVCL_00028";
    private static final String SVCL_00029 = "SVCL_00029";
    private static final String SVCL_00030 = "SVCL_00030";
    private static final String SVCL_00031 = "SVCL_00031";
    private static final String SVCL_00032 = "SVCL_00032";
    private static final String SVCL_00033 = "SVCL_00033";
    private static final String SVCL_00034 = "SVCL_00034";
    private static final String SVCL_00035 = "SVCL_00035";
    private static final String SVCL_00036 = "SVCL_00036";
    private static final String SVCL_00037 = "SVCL_00037";
    private static final String SVCL_00038 = "SVCL_00038";
    private static final String DEFAULT_NAME = (class$jp$ossc$nimbus$core$DefaultServiceLoaderService == null ? (class$jp$ossc$nimbus$core$DefaultServiceLoaderService = DefaultServiceLoaderService.class$("jp.ossc.nimbus.core.DefaultServiceLoaderService")) : class$jp$ossc$nimbus$core$DefaultServiceLoaderService).getName();
    private static final String DEFAULT_SERVICE_MANAGER_CLASS_NAME = (class$jp$ossc$nimbus$core$DefaultServiceManagerService == null ? (class$jp$ossc$nimbus$core$DefaultServiceManagerService = DefaultServiceLoaderService.class$("jp.ossc.nimbus.core.DefaultServiceManagerService")) : class$jp$ossc$nimbus$core$DefaultServiceManagerService).getName();
    private static final Map shutdownHooks = new HashMap();
    private URL serviceURL;
    private String serviceManagerClassName = DEFAULT_SERVICE_MANAGER_CLASS_NAME;
    private ServerMetaData serverData;
    private Map managerMap;
    private Map managersServiceMetaMap;
    private Map propertyEditors;
    private boolean isValidate;
    private boolean isCheckLoadManagerCompleted;
    static /* synthetic */ Class class$jp$ossc$nimbus$core$DefaultServiceLoaderService;
    static /* synthetic */ Class class$jp$ossc$nimbus$core$DefaultServiceManagerService;
    static /* synthetic */ Class class$jp$ossc$nimbus$core$ServiceManager;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$PropertiesEditor;
    static /* synthetic */ Class array$Ljp$ossc$nimbus$core$ServiceName;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$ServiceNameArrayEditor;
    static /* synthetic */ Class class$jp$ossc$nimbus$core$ServiceName;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$ServiceNameEditor;
    static /* synthetic */ Class array$Ljp$ossc$nimbus$core$ServiceNameRef;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$ServiceNameRefArrayEditor;
    static /* synthetic */ Class class$jp$ossc$nimbus$core$ServiceNameRef;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$ServiceNameRefEditor;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$StringArrayEditor;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$URLEditor;

    public DefaultServiceLoaderService() {
        this.setServiceName(DEFAULT_NAME);
    }

    public ServerMetaData getServerMetaData() {
        return this.serverData;
    }

    public void setServiceManagerClassName(String className) throws ClassNotFoundException, IllegalArgumentException {
        Logger logger = this.getLogger();
        if (className != null && className.length() != 0) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
            }
            catch (ClassNotFoundException e) {
                logger.write(SVCL_00001, new Object[]{class$jp$ossc$nimbus$core$ServiceManager == null ? (class$jp$ossc$nimbus$core$ServiceManager = DefaultServiceLoaderService.class$("jp.ossc.nimbus.core.ServiceManager")) : class$jp$ossc$nimbus$core$ServiceManager, className}, (Throwable)e);
                throw e;
            }
            if ((class$jp$ossc$nimbus$core$ServiceManager == null ? (class$jp$ossc$nimbus$core$ServiceManager = DefaultServiceLoaderService.class$("jp.ossc.nimbus.core.ServiceManager")) : class$jp$ossc$nimbus$core$ServiceManager).isAssignableFrom(clazz)) {
                this.serviceManagerClassName = className;
                logger.write(SVCL_00002, (Object)className);
            } else {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new IllegalArgumentException(message.findEmbedMessage(SVCL_00003, className));
            }
        }
    }

    public String getServiceManagerClassName() {
        return this.serviceManagerClassName;
    }

    public void setServiceURL(URL url) throws IllegalArgumentException {
        Logger logger = this.getLogger();
        try {
            url.openConnection();
        }
        catch (IOException e) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new IllegalArgumentException(message.findEmbedMessage(SVCL_00004, url));
        }
        this.serviceURL = url;
        logger.write(SVCL_00005, this.serviceURL);
    }

    public URL getServiceURL() {
        return this.serviceURL;
    }

    public void setServicePath(String path) throws IllegalArgumentException {
        Logger logger = this.getLogger();
        URL url = Utility.convertServicePathToURL(path);
        try {
            this.setServiceURL(url);
            logger.write(SVCL_00006, url);
        }
        catch (IllegalArgumentException e) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new IllegalArgumentException(message.findEmbedMessage(SVCL_00007, path));
        }
    }

    protected void loadServerMetaData() throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        Logger logger = this.getLogger();
        logger.write(SVCL_00008);
        if (this.serviceURL == null) {
            this.serviceURL = Utility.getDefaultServiceURL();
            logger.write(SVCL_00009, this.serviceURL);
        }
        this.serverData = this.loadServerMetaData(this.serviceURL);
    }

    protected ServerMetaData loadServerMetaData(URL url) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        if (url == null) {
            return null;
        }
        InputStream is = url.openStream();
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setValidating(this.isValidate());
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        NimbusEntityResolver resolver = new NimbusEntityResolver();
        builder.setEntityResolver(resolver);
        MyErrorHandler handler = new MyErrorHandler();
        builder.setErrorHandler(handler);
        Document doc = builder.parse(is);
        if (handler.isError()) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00033, this.serviceURL));
        }
        ServerMetaData serverData = new ServerMetaData(this, this.serviceURL);
        serverData.importXML(doc.getDocumentElement());
        return serverData;
    }

    protected void deployServerMetaData(ServerMetaData serverData) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        ServiceNameMetaData repositoryData;
        ServiceNameMetaData messageData;
        Logger logger = this.getLogger();
        logger.write(SVCL_00011, serverData);
        this.checkRefURL(serverData);
        DefaultLogMetaData defaultLogData = serverData.getDefaultLog();
        this.deployDefaultLogMetaData(defaultLogData);
        this.deployPropertyEditors();
        ServiceNameMetaData logData = serverData.getLog();
        if (logData != null) {
            String managerName = logData.getManagerName();
            String logName = logData.getServiceName();
            if (managerName != null && logName != null) {
                ServiceManagerFactory.setLogger(managerName, logName);
            }
        }
        if ((messageData = serverData.getMessage()) != null) {
            String managerName = messageData.getManagerName();
            String messageName = messageData.getServiceName();
            if (managerName != null && messageName != null) {
                ServiceManagerFactory.setMessageRecordFactory(managerName, messageName);
            }
        }
        if ((repositoryData = serverData.getRepository()) != null) {
            String managerName = repositoryData.getManagerName();
            String repositoryName = repositoryData.getServiceName();
            if (managerName != null && repositoryName != null) {
                ServiceManagerFactory.setManagerRepository(managerName, repositoryName);
            }
        }
        Iterator managers = serverData.getManagers().iterator();
        while (managers.hasNext()) {
            ManagerMetaData managerData = (ManagerMetaData)managers.next();
            this.deployManagerMetaData(managerData);
        }
    }

    protected void checkRefURL(ServerMetaData serverData) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        ManagerMetaData managerData;
        Set refURLSet = serverData.getReferenceURL();
        if (refURLSet == null || refURLSet.size() == 0) {
            return;
        }
        HashMap refServices = new HashMap();
        Iterator refURLs = refURLSet.iterator();
        while (refURLs.hasNext()) {
            URL refURL = (URL)refURLs.next();
            ServerMetaData refServerData = this.loadServerMetaData(refURL);
            Iterator managers = refServerData.getManagers().iterator();
            while (managers.hasNext()) {
                ManagerMetaData managerData2 = (ManagerMetaData)managers.next();
                String managerName = managerData2.getName();
                if (refServices.containsKey(managerName)) {
                    ((Map)refServices.get(managerName)).putAll(managerData2.getServices());
                    continue;
                }
                refServices.put(managerName, new HashMap(managerData2.getServices()));
            }
        }
        Iterator managers = serverData.getManagers().iterator();
        while (managers.hasNext()) {
            managerData = (ManagerMetaData)managers.next();
            String managerName = managerData.getName();
            if (refServices.containsKey(managerName)) {
                ((Map)refServices.get(managerName)).putAll(managerData.getServices());
                continue;
            }
            refServices.put(managerName, new HashMap(managerData.getServices()));
        }
        this.checkDepends(refServices, serverData.getRepository());
        this.checkDepends(refServices, serverData.getLog());
        this.checkDepends(refServices, serverData.getMessage());
        managers = serverData.getManagers().iterator();
        while (managers.hasNext()) {
            managerData = (ManagerMetaData)managers.next();
            this.checkDepends(refServices, managerData.getRepository());
            this.checkDepends(refServices, managerData.getLog());
            this.checkDepends(refServices, managerData.getMessage());
            Map services = managerData.getServices();
            Iterator serviceDatas = services.values().iterator();
            while (serviceDatas.hasNext()) {
                ServiceMetaData serviceData = (ServiceMetaData)serviceDatas.next();
                Iterator depends = serviceData.getDepends().iterator();
                while (depends.hasNext()) {
                    ServiceMetaData.DependsMetaData dependsData = (ServiceMetaData.DependsMetaData)depends.next();
                    this.checkDepends(refServices, serviceData, dependsData);
                }
            }
        }
    }

    private void checkDepends(Map refServices, ServiceNameMetaData dependsData) throws DeploymentException {
        Map services;
        if (dependsData == null) {
            return;
        }
        String depManagerName = dependsData.getManagerName();
        String depServiceName = dependsData.getServiceName();
        if (refServices.containsKey(depManagerName) && (services = (Map)refServices.get(depManagerName)).containsKey(depServiceName)) {
            return;
        }
        MessageRecordFactory message = this.getMessageRecordFactory();
        throw new DeploymentException(message.findEmbedMessage(SVCL_00036, new Object[]{depManagerName, depServiceName}));
    }

    private void checkDepends(Map refServices, ServiceMetaData serviceData, ServiceMetaData.DependsMetaData dependsData) throws DeploymentException {
        ManagerMetaData managerData = serviceData.getManager();
        String managerName = managerData.getName();
        String serviceName = serviceData.getName();
        String depManagerName = dependsData.getManagerName();
        String depServiceName = dependsData.getServiceName();
        Map ref = (Map)refServices.get(depManagerName);
        if (ref == null || !ref.containsKey(depServiceName)) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00036, new Object[]{depManagerName, depServiceName}));
        }
        ServiceMetaData depServiceData = (ServiceMetaData)ref.get(depServiceName);
        Iterator deps = depServiceData.getDepends().iterator();
        while (deps.hasNext()) {
            ServiceMetaData.DependsMetaData depdepServiceData = (ServiceMetaData.DependsMetaData)deps.next();
            String depdepManagerName = depdepServiceData.getManagerName();
            String depdepServiceName = depdepServiceData.getServiceName();
            if (depdepManagerName.equals(managerName) && depdepServiceName.equals(serviceName)) {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new DeploymentException(message.findEmbedMessage(SVCL_00037, new Object[]{managerName, serviceName, depdepManagerName, depdepServiceName}));
            }
            this.checkDepends(refServices, serviceData, depdepServiceData);
        }
    }

    protected void undeployServerMetaData(ServerMetaData serverData) throws DeploymentException {
        Iterator managers = this.managerMap.values().iterator();
        while (managers.hasNext()) {
            ServiceManager manager = (ServiceManager)managers.next();
            this.shutdownServiceManager(manager);
        }
        ServiceNameMetaData repositoryData = serverData.getRepository();
        if (repositoryData != null) {
            String managerName = repositoryData.getManagerName();
            String repositoryName = repositoryData.getServiceName();
            if (managerName != null && repositoryName != null && ServiceManagerFactory.isRegisteredService(managerName, repositoryName)) {
                ServiceManagerFactory.setManagerRepository((Repository)null);
            }
        }
        DefaultLogMetaData defaultLogData = serverData.getDefaultLog();
        this.undeployDefaultLogMetaData(defaultLogData);
    }

    protected void deployDefaultLogMetaData(DefaultLogMetaData defaultLogData) {
        if (defaultLogData == null) {
            return;
        }
        Logger logger = this.getLogger();
        DefaultLogMetaData.LogCategoryMetaData categoryData = defaultLogData.getDebug();
        if (categoryData != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(categoryData.isOutput());
            ServiceManagerFactory.DEFAULT_LOGGER.setDebugEnabled(categoryData.isOutput());
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemDebugEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_DEBUG");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_DEBUG");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(false);
            ServiceManagerFactory.DEFAULT_LOGGER.setDebugEnabled(false);
        }
        categoryData = defaultLogData.getInformation();
        if (categoryData != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(categoryData.isOutput());
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemInfoEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_INFO");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_INFO");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(true);
        }
        categoryData = defaultLogData.getWarning();
        if (categoryData != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(categoryData.isOutput());
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemWarnEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_WARN");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_WARN");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(true);
        }
        categoryData = defaultLogData.getError();
        if (categoryData != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(categoryData.isOutput());
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemErrorEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_ERROR");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_ERROR");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(true);
        }
        categoryData = defaultLogData.getFatal();
        if (categoryData != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(categoryData.isOutput());
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemFatalEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_FATAL");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_FATAL");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(true);
        }
    }

    protected void undeployDefaultLogMetaData(DefaultLogMetaData defaultLogData) {
        if (defaultLogData == null) {
            return;
        }
        ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(false);
        ServiceManagerFactory.DEFAULT_LOGGER.setDebugEnabled(false);
        ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(true);
        ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(true);
        ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(true);
        ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(true);
    }

    protected void deployPropertyEditors() {
        Logger logger = this.getLogger();
        logger.write(SVCL_00014);
        this.propertyEditors.put(class$java$util$Properties == null ? (class$java$util$Properties = DefaultServiceLoaderService.class$("java.util.Properties")) : class$java$util$Properties, class$jp$ossc$nimbus$beans$PropertiesEditor == null ? (class$jp$ossc$nimbus$beans$PropertiesEditor = DefaultServiceLoaderService.class$("jp.ossc.nimbus.beans.PropertiesEditor")) : class$jp$ossc$nimbus$beans$PropertiesEditor);
        this.propertyEditors.put(array$Ljp$ossc$nimbus$core$ServiceName == null ? (array$Ljp$ossc$nimbus$core$ServiceName = DefaultServiceLoaderService.class$("[Ljp.ossc.nimbus.core.ServiceName;")) : array$Ljp$ossc$nimbus$core$ServiceName, class$jp$ossc$nimbus$beans$ServiceNameArrayEditor == null ? (class$jp$ossc$nimbus$beans$ServiceNameArrayEditor = DefaultServiceLoaderService.class$("jp.ossc.nimbus.beans.ServiceNameArrayEditor")) : class$jp$ossc$nimbus$beans$ServiceNameArrayEditor);
        this.propertyEditors.put(class$jp$ossc$nimbus$core$ServiceName == null ? (class$jp$ossc$nimbus$core$ServiceName = DefaultServiceLoaderService.class$("jp.ossc.nimbus.core.ServiceName")) : class$jp$ossc$nimbus$core$ServiceName, class$jp$ossc$nimbus$beans$ServiceNameEditor == null ? (class$jp$ossc$nimbus$beans$ServiceNameEditor = DefaultServiceLoaderService.class$("jp.ossc.nimbus.beans.ServiceNameEditor")) : class$jp$ossc$nimbus$beans$ServiceNameEditor);
        this.propertyEditors.put(array$Ljp$ossc$nimbus$core$ServiceNameRef == null ? (array$Ljp$ossc$nimbus$core$ServiceNameRef = DefaultServiceLoaderService.class$("[Ljp.ossc.nimbus.core.ServiceNameRef;")) : array$Ljp$ossc$nimbus$core$ServiceNameRef, class$jp$ossc$nimbus$beans$ServiceNameRefArrayEditor == null ? (class$jp$ossc$nimbus$beans$ServiceNameRefArrayEditor = DefaultServiceLoaderService.class$("jp.ossc.nimbus.beans.ServiceNameRefArrayEditor")) : class$jp$ossc$nimbus$beans$ServiceNameRefArrayEditor);
        this.propertyEditors.put(class$jp$ossc$nimbus$core$ServiceNameRef == null ? (class$jp$ossc$nimbus$core$ServiceNameRef = DefaultServiceLoaderService.class$("jp.ossc.nimbus.core.ServiceNameRef")) : class$jp$ossc$nimbus$core$ServiceNameRef, class$jp$ossc$nimbus$beans$ServiceNameRefEditor == null ? (class$jp$ossc$nimbus$beans$ServiceNameRefEditor = DefaultServiceLoaderService.class$("jp.ossc.nimbus.beans.ServiceNameRefEditor")) : class$jp$ossc$nimbus$beans$ServiceNameRefEditor);
        this.propertyEditors.put(array$Ljava$lang$String == null ? (array$Ljava$lang$String = DefaultServiceLoaderService.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$jp$ossc$nimbus$beans$StringArrayEditor == null ? (class$jp$ossc$nimbus$beans$StringArrayEditor = DefaultServiceLoaderService.class$("jp.ossc.nimbus.beans.StringArrayEditor")) : class$jp$ossc$nimbus$beans$StringArrayEditor);
        this.propertyEditors.put(class$java$net$URL == null ? (class$java$net$URL = DefaultServiceLoaderService.class$("java.net.URL")) : class$java$net$URL, class$jp$ossc$nimbus$beans$URLEditor == null ? (class$jp$ossc$nimbus$beans$URLEditor = DefaultServiceLoaderService.class$("jp.ossc.nimbus.beans.URLEditor")) : class$jp$ossc$nimbus$beans$URLEditor);
        Map propertyEditors = this.serverData.getPropertyEditors();
        Iterator editTypes = propertyEditors.keySet().iterator();
        NimbusClassLoader loader = NimbusClassLoader.getInstance();
        while (editTypes.hasNext()) {
            String typeName = (String)editTypes.next();
            String editorClassName = (String)propertyEditors.get(typeName);
            Class<?> type = null;
            Class<?> editorClass = null;
            try {
                type = Class.forName(typeName, true, loader);
            }
            catch (ClassNotFoundException e) {
                logger.write(SVCL_00015, (Object)typeName, (Throwable)e);
                continue;
            }
            try {
                editorClass = Class.forName(editorClassName, true, loader);
            }
            catch (ClassNotFoundException e) {
                logger.write(SVCL_00016, (Object)editorClassName, (Throwable)e);
                continue;
            }
            this.propertyEditors.put(type, editorClass);
            logger.write(SVCL_00017, new Object[]{type, editorClass});
        }
    }

    protected void deployManagerMetaData(ManagerMetaData managerData) throws DeploymentException {
        ServiceNameMetaData repositoryData;
        ServiceNameMetaData messageData;
        Logger logger = this.getLogger();
        logger.write(SVCL_00018, managerData);
        String name = managerData.getName();
        ServiceManager manager = ServiceManagerFactory.findManager(name);
        if (manager == null) {
            manager = (ServiceManager)this.managerMap.get(name);
        }
        if (manager == null) {
            try {
                Class<?> clazz = Class.forName(this.serviceManagerClassName, true, NimbusClassLoader.getInstance());
                manager = (ServiceManager)clazz.newInstance();
            }
            catch (Exception e) {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new DeploymentException(message.findEmbedMessage(SVCL_00019, name), e);
            }
            manager.setServiceName(name);
            manager.setServiceManagerName(name);
            logger.write(SVCL_00020, (Object)name);
        }
        manager.addServiceLoader(this);
        this.managerMap.put(name, manager);
        ServiceNameMetaData logData = managerData.getLog();
        if (logData != null) {
            String managerName = logData.getManagerName();
            String logName = logData.getServiceName();
            if (managerName != null && logName != null) {
                manager.setSystemLoggerServiceName(new ServiceName(managerName, logName));
            }
        }
        if ((messageData = managerData.getMessage()) != null) {
            String managerName = messageData.getManagerName();
            String messageName = messageData.getServiceName();
            if (managerName != null && messageName != null) {
                manager.setSystemMessageRecordFactoryServiceName(new ServiceName(managerName, messageName));
            }
        }
        if ((repositoryData = managerData.getRepository()) != null) {
            String managerName = repositoryData.getManagerName();
            String repositoryName = repositoryData.getServiceName();
            if (managerName != null && repositoryName != null) {
                manager.setServiceRepository(managerName, repositoryName);
            }
        }
        if (!this.managersServiceMetaMap.containsKey(name)) {
            HashMap serviceMetaMap = new HashMap();
            this.managersServiceMetaMap.put(name, serviceMetaMap);
        }
        Map serviceDataMap = managerData.getServices();
        Iterator serviceNames = serviceDataMap.keySet().iterator();
        while (serviceNames.hasNext()) {
            String serviceName = (String)serviceNames.next();
            ServiceMetaData serviceData = (ServiceMetaData)serviceDataMap.get(serviceName);
            try {
                this.deployServiceMetaData(serviceData);
            }
            catch (DeploymentException e) {
                logger.write(SVCL_00038, new Object[]{this.managerName, serviceName}, (Throwable)e);
            }
        }
    }

    protected void deployServiceMetaData(ServiceMetaData serviceData) throws DeploymentException {
        Logger logger = this.getLogger();
        logger.write(SVCL_00021, serviceData);
        String managerName = serviceData.getManager().getName();
        String serviceName = serviceData.getName();
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager == null) {
            manager = (ServiceManager)this.managerMap.get(managerName);
        }
        if (manager == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00029, managerName));
        }
        if (manager.isRegisteredService(serviceName)) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00034, new Object[]{managerName, serviceName}));
        }
        Service service = null;
        try {
            service = this.instanciateService(serviceData);
        }
        catch (Exception e) {
            logger.write(SVCL_00022, new Object[]{managerName, serviceName}, (Throwable)e);
            throw new DeploymentException(e);
        }
        logger.write(SVCL_00023, new Object[]{managerName, serviceName});
        if (service != null) {
            manager.registerService(serviceName, service);
            Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(managerName);
            serviceMetaMap.put(serviceName, serviceData);
        }
    }

    public void loadService(String managerName, String serviceName) throws DeploymentException {
        ServiceMetaData serviceData = this.getServiceMetaData(managerName, serviceName);
        if (serviceData == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00035, new Object[]{managerName, serviceName}));
        }
        this.deployServiceMetaData(serviceData);
    }

    public void deployService(ServiceMetaData serviceData) throws DeploymentException {
        this.deployServiceMetaData(serviceData);
    }

    public void createService() {
        Logger logger = this.getLogger();
        String myName = this.getServiceName();
        this.setServiceName(myName == null ? DEFAULT_NAME + '{' + this.serviceURL + '}' : myName);
        if (this.serviceURL == null) {
            this.serviceURL = Utility.getDefaultServiceURL();
            logger.write(SVCL_00009, this.serviceURL);
        }
        ServiceManagerFactory.registerLoader(this);
        this.managerMap = new HashMap();
        this.managersServiceMetaMap = new HashMap();
        this.propertyEditors = new HashMap();
    }

    public void startService() throws Exception {
        Logger logger = this.getLogger();
        try {
            this.loadServerMetaData();
        }
        catch (Exception e) {
            logger.write(SVCL_00010, this.serviceURL, (Throwable)e);
            throw e;
        }
        this.managerMap.clear();
        this.managersServiceMetaMap.clear();
        this.propertyEditors.clear();
        try {
            this.deployServerMetaData(this.serverData);
        }
        catch (Exception e) {
            logger.write(SVCL_00024, this.serviceURL, (Throwable)e);
            throw e;
        }
        Iterator managers = this.managerMap.values().iterator();
        while (managers.hasNext()) {
            ServiceManager manager = (ServiceManager)managers.next();
            try {
                this.startupServiceManager(manager);
            }
            catch (Exception e) {
                logger.write(SVCL_00025, (Object)manager.getServiceName(), (Throwable)e);
                manager.destroy();
            }
        }
        if (this.isCheckLoadManagerCompleted) {
            ServiceManagerFactory.checkLoadManagerCompleted();
        }
    }

    public void stopService() throws Exception {
        this.undeployServerMetaData(this.serverData);
        this.managerMap.clear();
        this.managersServiceMetaMap.clear();
        this.propertyEditors.clear();
    }

    public void destroyService() throws Exception {
        this.managerMap = null;
        this.managersServiceMetaMap = null;
        this.propertyEditors = null;
        ServiceManagerFactory.unregisterLoader(this);
    }

    public Set getServiceManagers() {
        return new HashSet(this.managerMap.values());
    }

    public List getDepends(String managerName, String serviceName) {
        if (!this.managersServiceMetaMap.containsKey(managerName)) {
            return null;
        }
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(managerName);
        if (!serviceMetaMap.containsKey(serviceName)) {
            return null;
        }
        ArrayList result = new ArrayList();
        ServiceMetaData serviceData = (ServiceMetaData)serviceMetaMap.get(serviceName);
        result.addAll(serviceData.getDepends());
        return result;
    }

    public List getDependedServices(String managerName, String serviceName) {
        ArrayList<ServiceMetaData> result = new ArrayList<ServiceMetaData>();
        Iterator managerNames = this.managersServiceMetaMap.keySet().iterator();
        while (managerNames.hasNext()) {
            String mngName = (String)managerNames.next();
            Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(mngName);
            Iterator serviceNames = serviceMetaMap.keySet().iterator();
            block1: while (serviceNames.hasNext()) {
                String name = (String)serviceNames.next();
                if (name.equals(serviceName) && mngName.equals(managerName)) continue;
                Iterator dependsDatas = this.getDepends(mngName, name).iterator();
                while (dependsDatas.hasNext()) {
                    ServiceMetaData.DependsMetaData dependsData = (ServiceMetaData.DependsMetaData)dependsDatas.next();
                    if (!dependsData.getServiceName().equals(serviceName) || !dependsData.getManagerName().equals(managerName)) continue;
                    ServiceMetaData serviceData = (ServiceMetaData)serviceMetaMap.get(name);
                    result.add(serviceData);
                    continue block1;
                }
            }
        }
        return result;
    }

    public ServiceMetaData getServiceMetaData(String managerName, String serviceName) {
        if (!this.managersServiceMetaMap.containsKey(managerName)) {
            return null;
        }
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(managerName);
        return (ServiceMetaData)serviceMetaMap.get(serviceName);
    }

    public PropertyEditor findEditor(Class type) {
        Logger logger = this.getLogger();
        if (type == null) {
            return null;
        }
        PropertyEditor editor = null;
        Class clazz = (Class)this.propertyEditors.get(type);
        if (clazz == null) {
            editor = PropertyEditorManager.findEditor(type);
            return editor;
        }
        try {
            editor = (PropertyEditor)clazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.write(SVCL_00028, new Object[]{type, clazz}, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.write(SVCL_00028, new Object[]{type, clazz}, (Throwable)e);
            return null;
        }
        return editor;
    }

    private Service instanciateService(ServiceMetaData serviceData) throws Exception {
        ServiceManager manager = (ServiceManager)this.managerMap.get(serviceData.getManager().getName());
        Class<?> clazz = Class.forName(serviceData.getCode(), true, NimbusClassLoader.getInstance());
        Service service = manager.convertObjectToService(serviceData.getName(), clazz.newInstance());
        return service;
    }

    private void startupServiceManager(final ServiceManager manager) throws Exception {
        Logger logger = this.getLogger();
        int state = manager.getState();
        if (state != 3) {
            if (state == 7) {
                manager.create();
            }
            manager.start();
            ManagerMetaData managerData = this.serverData.getManager(manager.getServiceName());
            if (managerData.isExistShutdownHook()) {
                String managerName = manager.getServiceName();
                if (shutdownHooks.containsKey(managerName)) {
                    Runtime.getRuntime().removeShutdownHook((Thread)shutdownHooks.get(managerName));
                }
                Thread shutdownHook = new Thread(new Runnable(){

                    public void run() {
                        manager.stop();
                        manager.destroy();
                    }
                });
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                shutdownHooks.put(manager.getServiceName(), shutdownHook);
                logger.write(SVCL_00026, (Object)manager.getServiceName());
            }
        } else {
            Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(manager.getServiceName());
            HashSet serviceNames = new HashSet(serviceMetaMap.keySet());
            manager.createService(serviceNames);
            manager.startService(serviceNames);
        }
    }

    private void shutdownServiceManager(ServiceManager manager) {
        Logger logger = this.getLogger();
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(manager.getServiceName());
        HashSet serviceNames = new HashSet(serviceMetaMap.keySet());
        manager.destroyService(serviceNames);
        if (manager.getServiceLoaders().size() == 1) {
            manager.stop();
            Thread hook = (Thread)shutdownHooks.remove(manager.getServiceName());
            if (hook != null) {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
            manager.destroy();
        }
        manager.removeServiceLoader(this);
    }

    public int hashCode() {
        return this.serviceURL == null ? super.hashCode() : this.serviceURL.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultServiceLoaderService) {
            DefaultServiceLoaderService loader = (DefaultServiceLoaderService)obj;
            if (this.serviceURL == null && loader.serviceURL != null || this.serviceURL != null && loader.serviceURL == null) {
                return false;
            }
            return this.serviceURL == null || loader.serviceURL == null || this.serviceURL.equals(loader.serviceURL);
        }
        return false;
    }

    public void setValidate(boolean validate) {
        this.isValidate = validate;
    }

    public boolean isValidate() {
        return this.isValidate;
    }

    public void setCheckLoadManagerCompleted(boolean isCheck) {
        this.isCheckLoadManagerCompleted = isCheck;
    }

    public boolean isCheckLoadManagerCompleted() {
        return this.isCheckLoadManagerCompleted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private boolean isError;

        private MyErrorHandler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            DefaultServiceLoaderService.this.getLogger().write(DefaultServiceLoaderService.SVCL_00030, (Object)e.getMessage());
        }

        public void error(SAXParseException e) throws SAXException {
            this.isError = true;
            DefaultServiceLoaderService.this.getLogger().write(DefaultServiceLoaderService.SVCL_00031, (Object)e.getMessage());
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.isError = true;
            DefaultServiceLoaderService.this.getLogger().write(DefaultServiceLoaderService.SVCL_00032, (Object)e.getMessage());
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

