/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import jp.ossc.nimbus.core.DeploymentException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MetaData
implements Serializable {
    private MetaData parent;

    public MetaData() {
    }

    public MetaData(MetaData parent) {
        this.parent = parent;
    }

    public MetaData getParent() {
        return this.parent;
    }

    public void importXML(Element element) throws DeploymentException {
    }

    public static Iterator getChildrenByTagName(Element element, String tagName) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1 || !((Element)currentChild).getTagName().equals(tagName)) continue;
            result.add((Element)currentChild);
        }
        return result.iterator();
    }

    public static Element getUniqueChild(Element element, String tagName) throws DeploymentException {
        Iterator children = MetaData.getChildrenByTagName(element, tagName);
        if (children != null && children.hasNext()) {
            Element child = (Element)children.next();
            if (children.hasNext()) {
                throw new DeploymentException("Expected only one " + tagName + " tag");
            }
            return child;
        }
        throw new DeploymentException("Expected one " + tagName + " tag");
    }

    public static Element getOptionalChild(Element element, String tagName) throws DeploymentException {
        return MetaData.getOptionalChild(element, tagName, null);
    }

    public static Element getOptionalChild(Element element, String tagName, Element defaultElement) throws DeploymentException {
        Iterator children = MetaData.getChildrenByTagName(element, tagName);
        if (children != null && children.hasNext()) {
            Element child = (Element)children.next();
            if (children.hasNext()) {
                throw new DeploymentException("Expected only one " + tagName + " tag");
            }
            return child;
        }
        return defaultElement;
    }

    public static String getElementContent(Element element) {
        return MetaData.getElementContent(element, null);
    }

    public static String getElementContent(Element element, String defaultStr) {
        if (element == null) {
            return defaultStr;
        }
        NodeList children = element.getChildNodes();
        String result = "";
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            if (children.item(i).getNodeType() == 3 || children.item(i).getNodeType() == 4) {
                result = result + children.item(i).getNodeValue();
                continue;
            }
            if (children.item(i).getNodeType() == 8) continue;
            result = result + children.item(i).getFirstChild();
        }
        return result.trim();
    }

    public static String getUniqueChildContent(Element element, String tagName) throws DeploymentException {
        return MetaData.getElementContent(MetaData.getUniqueChild(element, tagName));
    }

    public static String getOptionalChildContent(Element element, String tagName) throws DeploymentException {
        return MetaData.getElementContent(MetaData.getOptionalChild(element, tagName));
    }

    public static boolean getOptionalChildBooleanContent(Element element, String name) throws DeploymentException {
        Element child = MetaData.getOptionalChild(element, name);
        if (child != null) {
            String value = MetaData.getElementContent(child).toLowerCase();
            return Boolean.valueOf(value) != false || value.equalsIgnoreCase("yes");
        }
        return false;
    }

    public static String getUniqueAttribute(Element element, String name) throws DeploymentException {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        throw new DeploymentException(name + " attribute is require.");
    }

    public static String getOptionalAttribute(Element element, String name) {
        return MetaData.getOptionalAttribute(element, name, null);
    }

    public static String getOptionalAttribute(Element element, String name, String defaultStr) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return defaultStr;
    }

    public static boolean getOptionalBooleanAttribute(Element element, String name) {
        String value = MetaData.getOptionalAttribute(element, name, null);
        if (value != null) {
            return Boolean.valueOf(value) != false || value.equalsIgnoreCase("yes");
        }
        return false;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

