/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceProxy;

public class ServiceProxyFactory {
    private ServiceProxyFactory() {
    }

    public static ServiceBase createServiceBaseProxy(ServiceBaseSupport support) {
        return new ServiceBase(support);
    }

    public static ServiceBase createServiceBaseProxy(Object obj) {
        return ServiceProxyFactory.createServiceBaseProxy(new ServiceBaseSupportAdapter(obj));
    }

    private static class ServiceBaseSupportAdapter
    implements ServiceBaseSupport,
    ServiceProxy,
    Serializable {
        private static final String CREATE = "create";
        private static final String START = "start";
        private static final String STOP = "stop";
        private static final String DESTROY = "destroy";
        private final Method create;
        private final Method start;
        private final Method stop;
        private final Method destroy;
        private final Object obj;

        public ServiceBaseSupportAdapter(Object obj) {
            this.obj = obj;
            Class<?> clazz = obj.getClass();
            this.create = this.findMethod(clazz, CREATE, null);
            this.start = this.findMethod(clazz, START, null);
            this.stop = this.findMethod(clazz, STOP, null);
            this.destroy = this.findMethod(clazz, DESTROY, null);
        }

        private Method findMethod(Class clazz, String name, Class[] params) {
            try {
                return clazz.getMethod(name, params);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void createService() throws Exception {
            if (this.create == null) {
                return;
            }
            try {
                this.create.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void startService() throws Exception {
            if (this.start == null) {
                return;
            }
            try {
                this.start.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void stopService() throws Exception {
            if (this.stop == null) {
                return;
            }
            try {
                this.stop.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void destroyService() throws Exception {
            if (this.destroy == null) {
                return;
            }
            try {
                this.destroy.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public Object getTarget() {
            return this.obj;
        }
    }
}

