/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.daemon;

import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.util.CsvArrayList;

public class Daemon
implements Runnable,
DaemonControl {
    protected volatile boolean mIsRunning;
    protected volatile boolean mIsBlocking;
    protected volatile boolean mIsSusupend;
    protected Thread mThread = null;
    protected String mName = null;
    protected boolean mDaemon;
    protected Object mWaitingObj;
    protected DaemonRunnable mRunnable;
    protected boolean isGarbaging;
    protected boolean isConsuming;

    public Daemon(DaemonRunnable run) {
        this.mRunnable = run;
        this.setRunning(false);
        this.setBlocking(false);
        this.setDaemon(true);
        this.mThread = null;
        this.mIsSusupend = false;
        this.mWaitingObj = new Object();
    }

    public final void setName(String name) {
        this.mName = name;
    }

    public final String getName() {
        return this.mName;
    }

    public final boolean isRunning() {
        return this.mIsRunning;
    }

    public void setRunning(boolean runFlg) {
        this.mIsRunning = runFlg;
    }

    public boolean isBlocking() {
        return this.mIsBlocking;
    }

    public void setBlocking(boolean blockFlg) {
        this.mIsBlocking = blockFlg;
    }

    public void setDaemon(boolean deamonFlg) {
        this.mDaemon = deamonFlg;
    }

    protected boolean getDaemon() {
        return this.mDaemon;
    }

    public CsvArrayList getDeamonInfo() {
        CsvArrayList parser = new CsvArrayList();
        parser.add(this.getName());
        parser.add("" + this.isRunning());
        parser.add("" + this.isBlocking());
        return parser;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        boolean bret = this.mRunnable.onStart();
        if (!bret) {
            return;
        }
        this.mThread = this.getName() == null || this.getName().equals("") ? new Thread(this) : new Thread((Runnable)this, this.getName());
        this.mThread.setDaemon(this.getDaemon());
        this.setRunning(true);
        this.setBlocking(true);
        this.mThread.start();
    }

    public synchronized void stop() {
        if (this.mThread == null) {
            return;
        }
        boolean bret = this.mRunnable.onStop();
        if (!bret) {
            return;
        }
        this.setRunning(false);
        if (this.isBlocking() && this.mThread != null && this.mThread.isAlive()) {
            this.mIsSusupend = false;
        }
        try {
            if (this.mThread != null) {
                this.mThread.interrupt();
                if (this.isConsuming) {
                    if (this.mThread.isInterrupted()) {
                        this.mThread.interrupt();
                    }
                    while (this.isConsuming) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                    }
                }
                if (this.isGarbaging) {
                    while (this.isGarbaging) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                    }
                }
                if (!this.mThread.isInterrupted()) {
                    this.mThread.join();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.mThread = null;
    }

    public synchronized void stopWait() {
        try {
            if (this.mThread != null) {
                this.mThread.join();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.mThread = null;
    }

    public synchronized void suspend() {
        if (this.mThread == null) {
            return;
        }
        boolean bret = this.mRunnable.onSuspend();
        if (!bret) {
            return;
        }
        this.mIsSusupend = true;
    }

    public synchronized void resume() {
        if (this.mThread == null) {
            return;
        }
        boolean bret = this.mRunnable.onResume();
        if (!bret) {
            return;
        }
        this.mIsSusupend = false;
        this.mThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            boolean breakFlg = false;
            Object waitObj = null;
            try {
                while (this.isRunning()) {
                    this.setBlocking(true);
                    while (this.mIsSusupend) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e1) {
                            Thread.interrupted();
                            breakFlg = true;
                            break;
                        }
                    }
                    if (breakFlg) {
                        breakFlg = false;
                        continue;
                    }
                    try {
                        waitObj = this.mRunnable.provide(this);
                    }
                    catch (Throwable e) {
                        Thread.interrupted();
                        e.printStackTrace();
                        waitObj = null;
                    }
                    while (this.mIsSusupend) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e2) {
                            Thread.interrupted();
                            breakFlg = true;
                            break;
                        }
                    }
                    this.setBlocking(false);
                    if (breakFlg) {
                        breakFlg = false;
                        continue;
                    }
                    this.isConsuming = true;
                    try {
                        this.mRunnable.consume(waitObj, this);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    this.isConsuming = false;
                }
                Object var5_8 = null;
                this.setRunning(false);
                this.isGarbaging = true;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.setRunning(false);
                this.isGarbaging = true;
                try {
                    this.mRunnable.garbage();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.isGarbaging = false;
                throw throwable;
            }
            try {
                this.mRunnable.garbage();
                break block18;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            {
            }
        }
        this.isGarbaging = false;
    }
}

