/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.FailToObtainSemaphoreException;
import jp.ossc.nimbus.service.aop.interceptor.FlowControlInterceptorServiceMBean;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class FlowControlInterceptorService
extends ServiceBase
implements Interceptor,
FlowControlInterceptorServiceMBean {
    private ServiceName semaphoreServiceName;
    private Semaphore semaphore;
    private long timeout = -1L;
    private boolean isFailToObtainSemaphore = true;

    public void setSemaphoreServiceName(ServiceName name) {
        this.semaphoreServiceName = name;
    }

    public ServiceName getSemaphoreServiceName() {
        return this.semaphoreServiceName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setFailToObtainSemaphore(boolean isThrow) {
        this.isFailToObtainSemaphore = isThrow;
    }

    public boolean isFailToObtainSemaphore() {
        return this.isFailToObtainSemaphore;
    }

    public void startService() throws Exception {
        if (this.semaphoreServiceName != null) {
            this.semaphore = (Semaphore)ServiceManagerFactory.getServiceObject(this.semaphoreServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && this.semaphore != null) {
            boolean isSuccess = false;
            isSuccess = this.timeout > 0L ? this.semaphore.getResource(this.timeout) : this.semaphore.getResource();
            Thread.interrupted();
            if (!isSuccess) {
                if (this.isFailToObtainSemaphore) {
                    throw new FailToObtainSemaphoreException();
                }
                return null;
            }
            try {
                Object object = chain.invokeNext(context);
                return object;
            }
            finally {
                this.semaphore.freeResource();
            }
        }
        return chain.invokeNext(context);
    }
}

