/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Method;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.MethodJournalInterceptorServiceMBean;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editor.MethodCallJournalData;
import jp.ossc.nimbus.service.journal.editor.MethodReturnJournalData;
import jp.ossc.nimbus.service.journal.editor.MethodThrowJournalData;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class MethodJournalInterceptorService
extends ServiceBase
implements Interceptor,
MethodJournalInterceptorServiceMBean {
    private static final String DEFAULT_REQUEST_JOURNAL_KEY = "Request";
    private static final String DEFAULT_METHOD_CALL_JOURNAL_KEY = "MethodCall";
    private static final String DEFAULT_METHOD_RETURN_JOURNAL_KEY = "MethodReturn";
    private ServiceName threadContextName;
    private Context threadContext;
    private ServiceName journalName;
    private Journal journal;
    private ServiceName editorFinderName;
    private EditorFinder editorFinder;
    private String requestJournalKey = "Request";
    private String methodCallJournalKey = "MethodCall";
    private String methodReturnJournalKey = "MethodReturn";
    private String requestIdKey;
    private boolean isEnabled = true;

    public void setRequestIdKey(String key) {
        this.requestIdKey = key;
    }

    public String getRequestIdKey() {
        return this.requestIdKey;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextName;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalName;
    }

    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderName = name;
    }

    public ServiceName getEditorFinderServiceName() {
        return this.editorFinderName;
    }

    public void setRequestJournalKey(String key) {
        this.requestJournalKey = key;
    }

    public String getRequestJournalKey() {
        return this.requestJournalKey;
    }

    public void setMethodCallJournalKey(String key) {
        this.methodCallJournalKey = key;
    }

    public String getMethodCallJournalKey() {
        return this.methodCallJournalKey;
    }

    public void setMethodReturnJournalKey(String key) {
        this.methodReturnJournalKey = key;
    }

    public String getMethodReturnJournalKey() {
        return this.methodReturnJournalKey;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void startService() throws Exception {
        if (this.journalName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalName);
        }
        if (this.editorFinderName != null) {
            this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderName);
        }
        if (this.threadContextName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextName);
        }
    }

    public void destroyService() {
        this.journal = null;
        this.editorFinder = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        MethodInvocationContext ctx = (MethodInvocationContext)context;
        if (this.getState() != 3) return chain.invokeNext(ctx);
        if (!this.isEnabled()) return chain.invokeNext(ctx);
        Object ret = null;
        try {
            this.preNext(ctx);
            ret = chain.invokeNext(ctx);
            this.postNext(ctx, ret);
        }
        catch (RuntimeException e) {
            try {
                throw this.throwRuntimeException(ctx, e);
                catch (Exception e2) {
                    throw this.throwException(ctx, e2);
                }
                catch (Error e3) {
                    throw this.throwError(ctx, e3);
                }
            }
            catch (Throwable throwable) {
                this.finallyNext(ctx, ret);
                throw throwable;
            }
        }
        this.finallyNext(ctx, ret);
        return ret;
    }

    protected void preNext(MethodInvocationContext context) throws Throwable {
        if (this.journal == null) {
            return;
        }
        this.journal.startJournal(this.requestJournalKey, this.editorFinder);
        if (this.threadContext != null && this.requestIdKey != null) {
            this.journal.setRequestId((String)this.threadContext.get(this.requestIdKey));
        }
        Method method = context.getTargetMethod();
        MethodCallJournalData data = new MethodCallJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), context.getParameters());
        this.journal.addInfo(this.methodCallJournalKey, (Object)data, this.editorFinder);
    }

    protected void postNext(MethodInvocationContext context, Object ret) throws Throwable {
        if (this.journal == null) {
            return;
        }
        Method method = context.getTargetMethod();
        MethodReturnJournalData data = new MethodReturnJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), ret);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.editorFinder);
    }

    public RuntimeException throwRuntimeException(MethodInvocationContext context, RuntimeException e) throws Throwable {
        if (this.journal == null) {
            return e;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), e);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.editorFinder);
        return e;
    }

    public Exception throwException(MethodInvocationContext context, Exception e) throws Throwable {
        if (this.journal == null) {
            return e;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), e);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.editorFinder);
        return e;
    }

    public Error throwError(MethodInvocationContext context, Error error) throws Throwable {
        if (this.journal == null) {
            return error;
        }
        Method method = context.getTargetMethod();
        MethodThrowJournalData data = new MethodThrowJournalData(method.getDeclaringClass(), method.getName(), (Class[])method.getParameterTypes(), error);
        this.journal.addInfo(this.methodReturnJournalKey, (Object)data, this.editorFinder);
        return error;
    }

    public void finallyNext(MethodInvocationContext context, Object ret) throws Throwable {
        if (this.journal == null) {
            return;
        }
        this.journal.endJournal();
    }
}

