/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.ejb.InvocationEJBFactoryServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class InvocationEJBFactoryService
extends ServiceBase
implements EJBFactory,
InvocationEJBFactoryServiceMBean {
    protected CacheMap remoteCache;
    protected ServiceName remoteCacheServiceName;
    protected JndiFinder jndiFinder;
    protected ServiceName jndiFinderServiceName;

    public ServiceName getRemoteCacheMapServiceName() {
        return this.remoteCacheServiceName;
    }

    public void setRemoteCacheMapServiceName(ServiceName serviceName) {
        this.remoteCacheServiceName = serviceName;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setJndiFinderServiceName(ServiceName serviceName) {
        this.jndiFinderServiceName = serviceName;
    }

    public void startService() throws Exception {
        if (this.remoteCacheServiceName != null) {
            this.remoteCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.remoteCacheServiceName);
        }
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.jndiFinder == null) {
            throw new Exception("Property \"jndiFinder\" is null.");
        }
    }

    public void destroyService() throws Exception {
        this.remoteCache = null;
        this.jndiFinder = null;
    }

    public EJBObject get(String name) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public EJBObject get(String name, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public EJBObject get(String name, Class homeType) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.get(name, homeType, null, null, null);
    }

    public EJBObject get(String name, Class homeType, Class[] paramTypes, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.get(name, homeType, null, paramTypes, params);
    }

    public EJBObject get(String name, Class homeType, Class remoteType, Class[] paramTypes, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBObject remote = null;
        RemoteKey key = null;
        if (this.remoteCache != null) {
            key = new RemoteKey(name, params);
            remote = (EJBObject)this.remoteCache.get(key);
        }
        EJBHome home = this.createHome(name, homeType);
        if (remote == null) {
            remote = this.createRemote(home, homeType, paramTypes, params);
            if (this.remoteCache != null) {
                this.remoteCache.put(key, remote);
            }
        }
        if (remoteType == null) {
            return remote;
        }
        return (EJBObject)PortableRemoteObject.narrow(remote, (Class)remoteType);
    }

    protected EJBHome createHome(String name, Class type) throws NamingException {
        EJBHome home = (EJBHome)this.jndiFinder.lookup(name);
        if (type == null) {
            return home;
        }
        return (EJBHome)PortableRemoteObject.narrow((Object)home, (Class)type);
    }

    protected EJBObject createRemote(EJBHome home, Class homeType, Class[] paramTypes, Object[] params) throws CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method create = homeType.getMethod("create", paramTypes);
        try {
            return (EJBObject)create.invoke((Object)home, params);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof CreateException) {
                throw (CreateException)th;
            }
            throw e;
        }
    }

    public void invalidate(String name) {
        if (this.jndiFinder != null) {
            this.jndiFinder.clearCache(name);
        }
        if (this.remoteCache != null) {
            this.remoteCache.remove(new RemoteKey(name));
        }
    }

    public void invalidate() {
        if (this.jndiFinder != null) {
            this.jndiFinder.clearCache();
        }
        if (this.remoteCache != null) {
            this.remoteCache.clear();
        }
    }

    protected class RemoteKey {
        private final String jndiName;
        private final Object[] params;
        private boolean isAll;

        public RemoteKey(String jndiName) {
            this(jndiName, null);
            this.isAll = true;
        }

        public RemoteKey(String jndiName, Object[] params) {
            this.jndiName = jndiName;
            this.params = params;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RemoteKey)) {
                return false;
            }
            RemoteKey key = (RemoteKey)obj;
            if (!this.jndiName.equals(key.jndiName)) {
                return false;
            }
            if (key.isAll) {
                return true;
            }
            if (this.params == null) {
                return key.params == null;
            }
            if (key.params == null) {
                return false;
            }
            if (this.params.length != key.params.length) {
                return false;
            }
            boolean result = true;
            for (int i = 0; i < this.params.length; ++i) {
                if (!(this.params[i] == null ? key.params[i] != null : !this.params[i].equals(key.params[i]))) continue;
                return false;
            }
            return result;
        }

        public int hashCode() {
            if (this.params != null) {
                return this.jndiName.hashCode() + this.params.hashCode();
            }
            return this.jndiName.hashCode();
        }
    }
}

