/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jndi;

import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.jndi.CachedJndiFinderServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class CachedJndiFinderService
extends ServiceBase
implements JndiFinder,
CachedJndiFinderServiceMBean {
    private Properties mProperties = null;
    private InitialContext mJNDIContext = null;
    private CacheMap mCache = null;
    private ServiceName mCacheServiceName = null;
    private static final String C_NONE = "";
    private String mPrefix = "";
    private int mRetryCount = 0;
    private long mInterval = 1000L;

    public void startService() {
        if (this.mCacheServiceName != null) {
            this.mCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.mCacheServiceName);
        }
        try {
            this.mJNDIContext = this.mProperties != null ? new InitialContext(this.mProperties) : new InitialContext();
        }
        catch (NamingException e) {
            String myName = this.getServiceName();
            throw new ServiceException("CACHEJNDIFINDER001", "Fail to StartService " + myName, e);
        }
    }

    public void stopService() throws NamingException {
        this.mJNDIContext.close();
    }

    public void destory() {
        this.mCache = null;
    }

    public Object lookup() throws NamingException {
        return this.lookup(C_NONE);
    }

    public Object lookup(String name) throws NamingException {
        Object cont = null;
        String key = this.mPrefix + name;
        if (this.mCache != null) {
            cont = this.mCache.get(key);
        }
        if (cont == null) {
            try {
                cont = this.mJNDIContext.lookup(key);
            }
            catch (CommunicationException e) {
            }
            catch (InterruptedNamingException e) {
            }
            catch (ServiceUnavailableException e) {
                // empty catch block
            }
            if (cont == null) {
                for (int rcont = 0; rcont < this.mRetryCount; ++rcont) {
                    try {
                        Thread.sleep(this.mInterval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        cont = this.mJNDIContext.lookup(key);
                        break;
                    }
                    catch (CommunicationException e) {
                        continue;
                    }
                    catch (InterruptedNamingException e) {
                        continue;
                    }
                    catch (ServiceUnavailableException e) {
                        // empty catch block
                    }
                }
            }
            if (cont != null && this.mCache != null) {
                this.mCache.put(key, cont);
            }
        }
        return cont;
    }

    public void setEnvironment(Properties prop) {
        this.mProperties = prop;
    }

    public Properties getEnvironment() throws NamingException {
        if (this.mProperties != null) {
            return this.mProperties;
        }
        if (this.mJNDIContext != null) {
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)this.mJNDIContext.getEnvironment());
            return prop;
        }
        return null;
    }

    public void setCacheMapServiceName(ServiceName name) {
        this.mCacheServiceName = name;
    }

    public ServiceName getCacheMapServiceName() {
        return this.mCacheServiceName;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public void setRetryCount(int num) {
        this.mRetryCount = num;
    }

    public int getRetryCount() {
        return this.mRetryCount;
    }

    public void setRetryInterval(long interval) {
        this.mInterval = interval;
    }

    public long getRetryInterval() {
        return this.mInterval;
    }

    public void clearCache() {
        if (this.mCache != null) {
            this.mCache.clear();
        }
    }

    public void clearCache(String name) {
        if (this.mCache != null) {
            this.mCache.remove(name);
        }
    }
}

