/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;
import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.JournalRecordImpl;
import jp.ossc.nimbus.service.journal.RequestJournal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class RequestJournalImpl
implements RequestJournal,
Serializable {
    protected ArrayList mRequestAry = new ArrayList();
    protected Date mStartTime;
    protected Date mEndTime;
    protected String mRequestId;
    protected JournalRecordImpl mStepRoot = null;
    protected JournalRecordImpl mCurrentRoot = null;
    protected boolean mIsStep = false;

    public RequestJournalImpl(boolean isStep) {
        this.mIsStep = isStep;
    }

    public boolean isStep() {
        return this.mIsStep;
    }

    public void setRequestId(String id) {
        this.mRequestId = id;
    }

    public void setStartTime(Date dt) {
        this.mStartTime = dt;
    }

    public void setStartTime() {
        this.mStartTime = new Date();
    }

    public void setEndTime() {
        this.mEndTime = new Date();
    }

    public void setEndTime(Date time) {
        this.mEndTime = time;
    }

    public JournalRecord setParamObj(String key, EditorFinder finder, Object obj) {
        JournalRecordImpl rec = new JournalRecordImpl();
        rec.setEditorFinder(finder);
        rec.setKey(key);
        rec.setParamObj(obj);
        this.mRequestAry.add(rec);
        return rec;
    }

    public JournalRecord setInfoObj(String key, EditorFinder finder, Object obj) {
        JournalRecordImpl rec = new JournalRecordImpl();
        rec.setEditorFinder(finder);
        rec.setKey(key);
        rec.setInfoObj(obj);
        this.mRequestAry.add(rec);
        return rec;
    }

    public String getRequestId() {
        return this.mRequestId;
    }

    public Date getStartTime() {
        return this.mStartTime;
    }

    public Date getEndTime() {
        return this.mEndTime;
    }

    public long getPerformance() {
        return this.mEndTime.getTime() - this.mStartTime.getTime();
    }

    public JournalRecord[] getParamAry() {
        JournalRecord[] ret = new JournalRecord[this.mRequestAry.size()];
        for (int cnt = 0; cnt < ret.length; ++cnt) {
            ret[cnt] = (JournalRecord)this.mRequestAry.get(cnt);
        }
        return ret;
    }

    public void setRoot(JournalRecordImpl stepRoot, JournalRecordImpl curRoot) {
        this.mStepRoot = stepRoot;
        this.mCurrentRoot = curRoot;
    }

    public JournalRecordImpl getStepRoot() {
        return this.mStepRoot;
    }

    public JournalRecordImpl getCurRoot() {
        return this.mCurrentRoot;
    }

    public boolean isRoot() {
        return this.getCurRoot() == null;
    }

    public JournalRecord[] findParamArys(String key) {
        ArrayList<JournalRecord> retAry = new ArrayList<JournalRecord>();
        ListIterator listIterator = this.mRequestAry.listIterator();
        while (listIterator.hasNext()) {
            JournalRecord tmp = (JournalRecord)listIterator.next();
            if (!tmp.getKey().equals(key)) continue;
            retAry.add(tmp);
        }
        JournalRecord[] ret = new JournalRecord[retAry.size()];
        for (int cnt = 0; cnt < ret.length; ++cnt) {
            ret[cnt] = (JournalRecord)retAry.get(cnt);
        }
        return ret;
    }
}

