/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.journal.editor.DynaBeanMapJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.MapJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class DynaBeanMapJournalEditorService
extends MapJournalEditorServiceBase
implements DynaBeanMapJournalEditorServiceMBean,
Serializable {
    private boolean isOutputDynaClass = true;
    private boolean isOutputProperties = true;
    protected String[] secretProperties;
    protected Set secretPropertySet;
    private String[] enabledProperties;
    protected Set enabledPropertySet;

    public void setOutputDynaClass(boolean isOutput) {
        this.isOutputDynaClass = isOutput;
    }

    public boolean isOutputDynaClass() {
        return this.isOutputDynaClass;
    }

    public void setOutputProperties(boolean isOutput) {
        this.isOutputProperties = isOutput;
    }

    public boolean isOutputProperties() {
        return this.isOutputProperties;
    }

    public void setSecretProperties(String[] names) {
        this.secretProperties = names;
    }

    public String[] getSecretProperties() {
        return this.secretProperties;
    }

    public void setEnabledProperties(String[] names) {
        this.enabledProperties = names;
    }

    public String[] getEnabledProperties() {
        return this.enabledProperties;
    }

    public void createService() {
        this.secretPropertySet = new HashSet();
        this.enabledPropertySet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.secretProperties != null) {
            for (i = 0; i < this.secretProperties.length; ++i) {
                this.secretPropertySet.add(this.secretProperties[i]);
            }
        }
        if (this.enabledProperties != null) {
            for (i = 0; i < this.enabledProperties.length; ++i) {
                this.enabledPropertySet.add(this.enabledProperties[i]);
            }
        }
    }

    public void stopService() {
        this.secretPropertySet.clear();
        this.enabledPropertySet.clear();
    }

    public void destroyService() {
        this.secretPropertySet = null;
        this.enabledPropertySet = null;
    }

    public Map toMap(EditorFinder finder, Object key, Object value) {
        DynaBean bean = (DynaBean)value;
        HashMap result = new HashMap();
        if (this.isOutputDynaClass()) {
            this.makeDynaClassFormat(finder, key, bean, result);
        }
        if (this.isOutputProperties()) {
            this.makePropertiesFormat(finder, key, bean, result);
        }
        return result;
    }

    protected Map makeDynaClassFormat(EditorFinder finder, Object key, DynaBean bean, Map map) {
        map.put("DynaClass", this.makeObjectFormat(finder, null, bean.getDynaClass()));
        return map;
    }

    protected Map makePropertiesFormat(EditorFinder finder, Object key, DynaBean bean, Map map) {
        DynaClass dynaClass = bean.getDynaClass();
        DynaProperty[] props = dynaClass.getDynaProperties();
        if (props == null || props.length == 0) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        int max = props.length;
        for (int i = 0; i < max; ++i) {
            String name = props[i].getName();
            if (!this.enabledPropertySet.isEmpty() && !this.enabledPropertySet.contains(name)) continue;
            if (this.secretPropertySet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            subMap.put(name, this.makeObjectFormat(finder, null, bean.get(name)));
        }
        map.put("Properties", subMap);
        return map;
    }
}

