/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.lang.AppException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.log.LogCategory;
import jp.ossc.nimbus.service.log.LogEnqueuedRecord;
import jp.ossc.nimbus.service.log.LogMessageRecord;
import jp.ossc.nimbus.service.log.LogMessageRecordImpl;
import jp.ossc.nimbus.service.log.LogServiceMBean;
import jp.ossc.nimbus.service.log.LogWritableRecordFactoryService;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.log.SimpleCategoryService;
import jp.ossc.nimbus.service.message.MessageRecord;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.message.MessageRecordFactoryService;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.writer.ConsoleWriterService;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.WritableRecordFactory;

public class LogService
extends ServiceBase
implements DaemonRunnable,
Logger,
LogServiceMBean {
    protected static final String EMPTY_STRING = "";
    protected static final String NONE_ID = "NONE";
    private static final String LINE_SEPARATOR_KEY = "line.separator";
    private Map categoryMap;
    private Map defaultCategoryMap;
    private ServiceName[] categoryNames;
    private ServiceName queueServiceName;
    private DefaultQueueService defaultQueue;
    private Queue queue;
    private ServiceName messageFactoryServiceName;
    private MessageRecordFactory messageFactory;
    private MessageRecordFactoryService defaultMessageFactory;
    private ServiceName contextServiceName;
    private Context context;
    private ServiceName defaultMessageWriterServiceName;
    private MessageWriter defaultMessageWriter;
    private ConsoleWriterService consoleWriter;
    private ServiceName defaultWritableRecordFactoryServiceName;
    private WritableRecordFactory defaultWritableRecordFactory;
    private LogWritableRecordFactoryService logWritableRecordFactory;
    private ServiceName debugMessageWriterServiceName;
    private ServiceName systemDebugMessageWriterServiceName;
    private ServiceName systemInfoMessageWriterServiceName;
    private ServiceName systemWarnMessageWriterServiceName;
    private ServiceName systemErrorMessageWriterServiceName;
    private ServiceName systemFatalMessageWriterServiceName;
    private ServiceName debugRecordFactoryServiceName;
    private ServiceName systemDebugRecordFactoryServiceName;
    private ServiceName systemInfoRecordFactoryServiceName;
    private ServiceName systemWarnRecordFactoryServiceName;
    private ServiceName systemErrorRecordFactoryServiceName;
    private ServiceName systemFatalRecordFactoryServiceName;
    private Daemon daemon;
    private Set contextKeys = new HashSet();
    private boolean isDebugEnabled = false;
    private boolean isSystemDebugEnabled = false;
    private boolean isSystemInfoEnabled = true;
    private boolean isSystemWarnEnabled = true;
    private boolean isSystemErrorEnabled = true;
    private boolean isSystemFatalEnabled = true;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$log$LogMessageRecordImpl;

    public void createService() throws Exception {
        this.daemon = new Daemon(this);
        this.categoryMap = new HashMap();
        this.defaultCategoryMap = new HashMap();
    }

    protected void addDefaultCategory(MessageWriter defaultMessageWriter, WritableRecordFactory defaultRecordFactory, ServiceName messageWriterName, ServiceName recordFactoryName, String categoryName, int priorityMin, int priorityMax, String label, boolean isEnabled) throws Exception {
        MessageWriter messageWriter = defaultMessageWriter;
        WritableRecordFactory recordFactory = defaultRecordFactory;
        if (messageWriterName != null) {
            messageWriter = (MessageWriter)ServiceManagerFactory.getServiceObject(messageWriterName);
        }
        if (recordFactoryName != null) {
            recordFactory = (WritableRecordFactory)ServiceManagerFactory.getServiceObject(recordFactoryName);
        }
        SimpleCategoryService category = new SimpleCategoryService();
        category.setCategoryName(categoryName);
        category.setPriorityRange(priorityMin, priorityMax);
        category.setLabel(priorityMin, priorityMax, label);
        category.create();
        category.start();
        category.setMessageWriterService(messageWriter);
        category.setWritableRecordFactoryService(recordFactory);
        this.addCategoryService(category);
        this.addDefaultCategoryService(category);
        this.setEnabled(categoryName, isEnabled);
    }

    public void startService() throws Exception {
        if (this.getDefaultMessageWriterServiceName() == null) {
            if (this.getConsoleWriterService() == null) {
                ConsoleWriterService consoleWriter = new ConsoleWriterService();
                consoleWriter.setOutput("STDOUT");
                consoleWriter.create();
                consoleWriter.start();
                this.setConsoleWriterService(consoleWriter);
            } else {
                this.getConsoleWriterService().start();
            }
            this.setDefaultMessageWriterService(this.getConsoleWriterService());
        } else {
            this.setDefaultMessageWriterService((MessageWriter)ServiceManagerFactory.getServiceObject(this.getDefaultMessageWriterServiceName()));
        }
        if (this.getDefaultWritableRecordFactoryServiceName() == null) {
            if (this.getLogWritableRecordFactoryService() == null) {
                LogWritableRecordFactoryService recordFactory = new LogWritableRecordFactoryService();
                recordFactory.setFormat("%DATE%,%CODE%,%PRIORITY%,%MESSAGE%");
                recordFactory.create();
                recordFactory.start();
                this.setLogWritableRecordFactoryService(recordFactory);
            } else {
                this.getLogWritableRecordFactoryService().start();
            }
            this.setDefaultWritableRecordFactoryService(this.getLogWritableRecordFactoryService());
        } else {
            this.setDefaultWritableRecordFactoryService((WritableRecordFactory)ServiceManagerFactory.getServiceObject(this.getDefaultWritableRecordFactoryServiceName()));
        }
        this.initDefaultCategory();
        ServiceName[] categoryNames = this.getCategoryServiceNames();
        if (categoryNames != null) {
            for (int i = 0; i < categoryNames.length; ++i) {
                ServiceName categoryName = categoryNames[i];
                LogCategory category = (LogCategory)ServiceManagerFactory.getServiceObject(categoryName);
                this.addCategoryService(category);
            }
        }
        if (this.getQueueServiceName() == null) {
            if (this.getDefaultQueueService() == null) {
                DefaultQueueService defaultQueue = new DefaultQueueService();
                defaultQueue.create();
                defaultQueue.start();
                this.setDefaultQueueService(defaultQueue);
            } else {
                this.getDefaultQueueService().start();
            }
            this.setQueueService(this.getDefaultQueueService());
        } else {
            this.setQueueService((Queue)ServiceManagerFactory.getServiceObject(this.getQueueServiceName()));
        }
        if (this.getMessageRecordFactoryServiceName() == null) {
            if (this.getDefaultMessageRecordFactoryService() == null) {
                MessageRecordFactoryService defaultMessageFactory = new MessageRecordFactoryService();
                defaultMessageFactory.setMessageRecordClassName((class$jp$ossc$nimbus$service$log$LogMessageRecordImpl == null ? (class$jp$ossc$nimbus$service$log$LogMessageRecordImpl = LogService.class$("jp.ossc.nimbus.service.log.LogMessageRecordImpl")) : class$jp$ossc$nimbus$service$log$LogMessageRecordImpl).getName());
                defaultMessageFactory.create();
                defaultMessageFactory.start();
                this.setDefaultMessageRecordFactoryService(defaultMessageFactory);
            } else {
                this.getDefaultMessageRecordFactoryService().start();
            }
            this.setMessageRecordFactoryService(this.defaultMessageFactory);
        } else {
            this.setMessageRecordFactoryService((MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.getMessageRecordFactoryServiceName()));
        }
        if (this.getContextServiceName() != null) {
            this.setContextService((Context)ServiceManagerFactory.getServiceObject(this.getContextServiceName()));
        }
        this.daemon.start();
    }

    protected void initDefaultCategory() throws Exception {
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getDebugMessageWriterServiceName(), this.getDebugWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.DEBUG_METHOD_CATEGORY", -1, -1, "DEBUG", this.isDebugEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getSystemDebugMessageWriterServiceName(), this.getSystemDebugWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.SYSTEM_DEBUG_CATEGORY", 0, 49, "SYSTEM_DEBUG", this.isSystemDebugEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getSystemInfoMessageWriterServiceName(), this.getSystemInfoWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.SYSTEM_INFO_CATEGORY", 50, 99, "SYSTEM_INFO", this.isSystemInfoEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getSystemWarnMessageWriterServiceName(), this.getSystemWarnWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.SYSTEM_WARN_CATEGORY", 100, 149, "SYSTEM_WARN", this.isSystemWarnEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getSystemErrorMessageWriterServiceName(), this.getSystemErrorWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.SYSTEM_ERROR_CATEGORY", 150, 199, "SYSTEM_ERROR", this.isSystemErrorEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getSystemFatalMessageWriterServiceName(), this.getSystemFatalWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.SYSTEM_FATAL_CATEGORY", 200, 249, "SYSTEM_FATAL", this.isSystemFatalEnabled());
    }

    public void stopService() {
        this.daemon.stop();
        if (this.getDefaultMessageWriterService() == this.getConsoleWriterService()) {
            this.getConsoleWriterService().stop();
        }
        if (this.getDefaultWritableRecordFactoryService() == this.getLogWritableRecordFactoryService()) {
            this.getLogWritableRecordFactoryService().stop();
        }
        if (this.getQueueService() == this.getDefaultQueueService()) {
            this.getDefaultQueueService().stop();
        }
        if (this.getMessageRecordFactoryService() == this.getDefaultMessageRecordFactoryService()) {
            this.getDefaultMessageRecordFactoryService().stop();
        }
        this.categoryMap.clear();
        this.defaultCategoryMap.clear();
    }

    public void destroyService() {
        if (this.getDefaultMessageWriterService() == this.getConsoleWriterService() && this.getConsoleWriterService() != null) {
            this.getConsoleWriterService().destroy();
            this.setConsoleWriterService(null);
        }
        if (this.getDefaultWritableRecordFactoryService() == this.getLogWritableRecordFactoryService() && this.getLogWritableRecordFactoryService() != null) {
            this.getLogWritableRecordFactoryService().destroy();
            this.setLogWritableRecordFactoryService(null);
        }
        if (this.getQueueService() == this.getDefaultQueueService() && this.getDefaultQueueService() != null) {
            this.getDefaultQueueService().destroy();
            this.setDefaultQueueService(null);
        }
        if (this.getMessageRecordFactoryService() == this.getDefaultMessageRecordFactoryService() && this.getDefaultMessageRecordFactoryService() != null) {
            this.getDefaultMessageRecordFactoryService().destroy();
            this.setDefaultMessageRecordFactoryService(null);
        }
        this.categoryMap = null;
        this.defaultCategoryMap = null;
        this.daemon = null;
    }

    protected Map getCategoryMap() {
        return this.categoryMap;
    }

    public void setDefaultMessageWriterServiceName(ServiceName name) {
        this.defaultMessageWriterServiceName = name;
    }

    public ServiceName getDefaultMessageWriterServiceName() {
        return this.defaultMessageWriterServiceName;
    }

    public void setDefaultMessageWriterService(MessageWriter writer) {
        this.defaultMessageWriter = writer;
    }

    public MessageWriter getDefaultMessageWriterService() {
        return this.defaultMessageWriter;
    }

    protected ConsoleWriterService getConsoleWriterService() {
        return this.consoleWriter;
    }

    protected void setConsoleWriterService(ConsoleWriterService consoleWriter) {
        this.consoleWriter = consoleWriter;
    }

    public void setDefaultWritableRecordFactoryServiceName(ServiceName name) {
        this.defaultWritableRecordFactoryServiceName = name;
    }

    public ServiceName getDefaultWritableRecordFactoryServiceName() {
        return this.defaultWritableRecordFactoryServiceName;
    }

    public void setDefaultWritableRecordFactoryService(WritableRecordFactory recordFactory) {
        this.defaultWritableRecordFactory = recordFactory;
    }

    public WritableRecordFactory getDefaultWritableRecordFactoryService() {
        return this.defaultWritableRecordFactory;
    }

    protected LogWritableRecordFactoryService getLogWritableRecordFactoryService() {
        return this.logWritableRecordFactory;
    }

    protected void setLogWritableRecordFactoryService(LogWritableRecordFactoryService logRecordFactory) {
        this.logWritableRecordFactory = logRecordFactory;
    }

    public void setCategoryServiceNames(ServiceName[] names) {
        this.categoryNames = names;
    }

    public ServiceName[] getCategoryServiceNames() {
        return this.categoryNames;
    }

    public void setCategoryServices(LogCategory[] categories) {
        if (this.categoryMap != null) {
            Set defaultCategoryNames = this.defaultCategoryMap.keySet();
            Set categoryNames = this.categoryMap.keySet();
            categoryNames.retainAll(defaultCategoryNames);
            if (categories != null) {
                for (int i = 0; i < categories.length; ++i) {
                    LogCategory category = categories[i];
                    if (category == null) continue;
                    this.addCategoryService(category);
                }
            }
        }
    }

    public LogCategory[] getCategoryServices() {
        if (this.categoryMap != null) {
            return this.categoryMap.values().toArray(new LogCategory[this.categoryMap.size()]);
        }
        return new LogCategory[0];
    }

    public void addCategoryService(LogCategory category) {
        if (this.categoryMap != null && category != null) {
            this.categoryMap.put(category.getCategoryName(), category);
        }
    }

    private void addDefaultCategoryService(LogCategory category) {
        if (this.defaultCategoryMap != null && category != null) {
            this.defaultCategoryMap.put(category.getCategoryName(), category);
        }
    }

    public LogCategory getCategoryService(String name) {
        if (this.categoryMap != null && name != null) {
            return (LogCategory)this.categoryMap.get(name);
        }
        return null;
    }

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public void setQueueService(Queue queue) {
        this.queue = queue;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public Queue getQueueService() {
        return this.queue;
    }

    protected DefaultQueueService getDefaultQueueService() {
        return this.defaultQueue;
    }

    protected void setDefaultQueueService(DefaultQueueService queue) {
        this.defaultQueue = queue;
    }

    public void setMessageRecordFactoryServiceName(ServiceName name) {
        this.messageFactoryServiceName = name;
    }

    public void setMessageRecordFactoryService(MessageRecordFactory message) {
        this.messageFactory = message;
    }

    public ServiceName getMessageRecordFactoryServiceName() {
        return this.messageFactoryServiceName;
    }

    public MessageRecordFactory getMessageRecordFactoryService() {
        return this.messageFactory;
    }

    protected MessageRecordFactoryService getDefaultMessageRecordFactoryService() {
        return this.defaultMessageFactory;
    }

    protected void setDefaultMessageRecordFactoryService(MessageRecordFactoryService message) {
        this.defaultMessageFactory = message;
    }

    public void setContextServiceName(ServiceName name) {
        this.contextServiceName = name;
    }

    public void setContextService(Context context) {
        this.context = context;
    }

    public ServiceName getContextServiceName() {
        return this.contextServiceName;
    }

    public Context getContextService() {
        return this.context;
    }

    public void setContextFormatKeys(String[] keys) {
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] == null) continue;
                this.contextKeys.add(keys[i]);
            }
        }
    }

    public void addContextFormatKey(String key) {
        if (key != null) {
            this.contextKeys.add(key);
        }
    }

    public void removeContextFormatKey(String key) {
        if (key != null) {
            this.contextKeys.remove(key);
        }
    }

    public void clearContextFormatKeys() {
        this.contextKeys.clear();
    }

    public String[] getContextFormatKeys() {
        return this.contextKeys.toArray(new String[this.contextKeys.size()]);
    }

    protected Object getContextFormatValue(String key) {
        Context context = this.getContextService();
        if (context != null) {
            return context.get(key);
        }
        return null;
    }

    protected boolean isWrite(LogMessageRecord messageRecord) {
        int priority = messageRecord.getPriority();
        Iterator categoryNames = messageRecord.getCategories().iterator();
        while (categoryNames.hasNext()) {
            String categoryName = (String)categoryNames.next();
            LogCategory category = this.getCategoryService(categoryName);
            if (category == null || !category.isEnabled() || !category.isValidPriorityRange(priority)) continue;
            return true;
        }
        return false;
    }

    protected LogEnqueuedRecord createLogEnqueuedRecord(LogMessageRecord messageRecord, Locale locale, String embed, Throwable throwable) {
        return new LogEnqueuedRecord(messageRecord, locale, embed, throwable);
    }

    protected LogEnqueuedRecord createLogEnqueuedRecord(LogMessageRecord messageRecord, Locale locale, String[] embeds, Throwable throwable) {
        return new LogEnqueuedRecord(messageRecord, locale, embeds, throwable);
    }

    protected LogMessageRecord createDebugLogMessageRecord(String category, int priority, Object message) {
        LogMessageRecordImpl record = new LogMessageRecordImpl();
        record.addCategory(category);
        record.setPriority(priority);
        record.setMessageCode(EMPTY_STRING);
        record.addMessage(message != null ? message.toString() : null);
        record.setFactory(this.getMessageRecordFactoryService());
        return record;
    }

    protected void write(LogMessageRecord messageRecord, Locale locale, String embed, Throwable throwable) {
        if (this.getState() != 3) {
            return;
        }
        LogEnqueuedRecord enqueuedRecord = this.createLogEnqueuedRecord(messageRecord, locale, embed, throwable);
        this.enqueue(enqueuedRecord);
    }

    protected void write(LogMessageRecord messageRecord, Locale locale, String[] embeds, Throwable throwable) {
        LogEnqueuedRecord enqueuedRecord = this.createLogEnqueuedRecord(messageRecord, locale, embeds, throwable);
        this.enqueue(enqueuedRecord);
    }

    protected void preEnqueue(LogEnqueuedRecord enqueuedRecord) {
        LogMessageRecord messageRecord = enqueuedRecord.getLogMessageRecord();
        enqueuedRecord.addWritableElement("DATE", new Date());
        String[] keys = this.getContextFormatKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                Object val;
                if (keys[i] == null || (val = this.getContextFormatValue(keys[i])) == null) continue;
                enqueuedRecord.addWritableElement(keys[i], val);
            }
        }
    }

    protected void enqueue(LogEnqueuedRecord enqueuedRecord) {
        this.preEnqueue(enqueuedRecord);
        this.queue.push(enqueuedRecord);
    }

    protected void postDequeue(LogEnqueuedRecord dequeuedRecord) {
        LogMessageRecord messageRecord = dequeuedRecord.getLogMessageRecord();
        Locale locale = dequeuedRecord.getLocale();
        Object[] embeds = dequeuedRecord.getEmbedStringArray();
        Throwable throwable = dequeuedRecord.getThrowable();
        String message = messageRecord.makeMessage(locale, embeds);
        if (throwable != null) {
            StringBuffer buf = new StringBuffer(message);
            buf.append(System.getProperty(LINE_SEPARATOR_KEY));
            buf.append(LogService.getStackTraceString(throwable));
            message = buf.toString();
        }
        dequeuedRecord.addWritableElement("CODE", messageRecord.getMessageCode());
        dequeuedRecord.addWritableElement("MESSAGE", message);
    }

    protected LogCategory[] getWriteCategories(LogMessageRecord messageRecord) {
        ArrayList<LogCategory> result = new ArrayList<LogCategory>();
        int priority = messageRecord.getPriority();
        Iterator categoryNames = messageRecord.getCategories().iterator();
        while (categoryNames.hasNext()) {
            String categoryName = (String)categoryNames.next();
            LogCategory category = this.getCategoryService(categoryName);
            if (category == null || !category.isEnabled() || !category.isValidPriorityRange(priority)) continue;
            result.add(category);
        }
        return result.toArray(new LogCategory[result.size()]);
    }

    protected Map createWritableElementMap(LogEnqueuedRecord dequeuedRecord, LogCategory category) {
        LogMessageRecord messageRecord = dequeuedRecord.getLogMessageRecord();
        dequeuedRecord.addWritableElement("PRIORITY", category.getLabel(messageRecord.getPriority()));
        dequeuedRecord.addWritableElement("CATEGORY", category.getCategoryName());
        return dequeuedRecord.getWritableElements();
    }

    protected void dequeue(LogEnqueuedRecord dequeuedRecord) {
        this.postDequeue(dequeuedRecord);
        LogMessageRecord messageRecord = dequeuedRecord.getLogMessageRecord();
        LogCategory[] categories = this.getWriteCategories(messageRecord);
        for (int i = 0; i < categories.length; ++i) {
            LogCategory category = categories[i];
            try {
                category.write(messageRecord.getPriority(), this.createWritableElementMap(dequeuedRecord, category));
                continue;
            }
            catch (MessageWriteException e) {
                // empty catch block
            }
        }
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) {
        return this.queue.get();
    }

    public void consume(Object dequeued, DaemonControl ctrl) {
        if (dequeued == null) {
            return;
        }
        try {
            this.dequeue((LogEnqueuedRecord)dequeued);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void garbage() {
        if (this.queue != null) {
            while (this.queue.size() > 0) {
                this.consume(this.queue.get(0), this.daemon);
            }
        }
    }

    public void debug(Object msg) {
        LogMessageRecord messageRecord = this.createDebugLogMessageRecord("jp.ossc.nimbus.service.log.DEBUG_METHOD_CATEGORY", -1, msg);
        if (!this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, null, (String)null, null);
    }

    public void debug(Object msg, Throwable oException) {
        LogMessageRecord messageRecord = this.createDebugLogMessageRecord("jp.ossc.nimbus.service.log.DEBUG_METHOD_CATEGORY", -1, msg);
        if (!this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, null, (String)null, oException);
    }

    public void write(String logCode, Object embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(String logCode, byte embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(String logCode, short embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(String logCode, char embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(String logCode, int embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(String logCode, long embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(String logCode, float embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(String logCode, double embed) {
        this.write(Locale.getDefault(), logCode, embed);
    }

    public void write(Locale lo, String logCode, Object embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, embed != null ? embed.toString() : (String)null, null);
    }

    public void write(Locale lo, String logCode, byte embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Byte.toString(embed), null);
    }

    public void write(Locale lo, String logCode, short embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Short.toString(embed), null);
    }

    public void write(Locale lo, String logCode, char embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, new Character(embed).toString(), null);
    }

    public void write(Locale lo, String logCode, int embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Integer.toString(embed), null);
    }

    public void write(Locale lo, String logCode, long embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Long.toString(embed), null);
    }

    public void write(Locale lo, String logCode, float embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Float.toString(embed), null);
    }

    public void write(Locale lo, String logCode, double embed) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Double.toString(embed), null);
    }

    public void write(String logCode, Object[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    public void write(String logCode, byte[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    public void write(String logCode, short[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    public void write(String logCode, char[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    public void write(String logCode, int[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    public void write(String logCode, long[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    public void write(String logCode, float[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    public void write(String logCode, double[] embeds) {
        this.write(Locale.getDefault(), logCode, embeds);
    }

    protected static String[] convertStringArray(Object[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                if (vals[i] == null) continue;
                strings[i] = vals[i].toString();
            }
        }
        return strings;
    }

    protected static String[] convertStringArray(byte[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strings[i] = Byte.toString(vals[i]);
            }
        }
        return strings;
    }

    protected static String[] convertStringArray(short[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strings[i] = Short.toString(vals[i]);
            }
        }
        return strings;
    }

    protected static String[] convertStringArray(char[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strings[i] = new Character(vals[i]).toString();
            }
        }
        return strings;
    }

    protected static String[] convertStringArray(int[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strings[i] = Integer.toString(vals[i]);
            }
        }
        return strings;
    }

    protected static String[] convertStringArray(long[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strings[i] = Long.toString(vals[i]);
            }
        }
        return strings;
    }

    protected static String[] convertStringArray(float[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strings[i] = Float.toString(vals[i]);
            }
        }
        return strings;
    }

    protected static String[] convertStringArray(double[] vals) {
        String[] strings = null;
        if (vals != null) {
            strings = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                strings[i] = Double.toString(vals[i]);
            }
        }
        return strings;
    }

    public void write(Locale lo, String logCode, Object[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(Locale lo, String logCode, byte[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(Locale lo, String logCode, short[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(Locale lo, String logCode, char[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(Locale lo, String logCode, int[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(Locale lo, String logCode, long[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(Locale lo, String logCode, float[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(Locale lo, String logCode, double[] embeds) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), null);
    }

    public void write(String logCode) {
        this.write(Locale.getDefault(), logCode);
    }

    public void write(Locale lo, String logCode) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, (String)null, null);
    }

    public void write(String logCode, Throwable oException) {
        this.write(Locale.getDefault(), logCode, oException);
    }

    public void write(Locale lo, String logCode, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, (String)null, oException);
    }

    public void write(String logCode, Object embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(String logCode, byte embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(String logCode, short embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(String logCode, char embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(String logCode, int embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(String logCode, long embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(String logCode, float embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(String logCode, double embed, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embed, oException);
    }

    public void write(Locale lo, String logCode, Object embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, embed != null ? embed.toString() : (String)null, oException);
    }

    public void write(Locale lo, String logCode, byte embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Byte.toString(embed), oException);
    }

    public void write(Locale lo, String logCode, short embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Short.toString(embed), oException);
    }

    public void write(Locale lo, String logCode, char embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, new Character(embed).toString(), oException);
    }

    public void write(Locale lo, String logCode, int embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Integer.toString(embed), oException);
    }

    public void write(Locale lo, String logCode, long embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Long.toString(embed), oException);
    }

    public void write(Locale lo, String logCode, float embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Float.toString(embed), oException);
    }

    public void write(Locale lo, String logCode, double embed, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, Double.toString(embed), oException);
    }

    public void write(String logCode, Object[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(String logCode, byte[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(String logCode, short[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(String logCode, char[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(String logCode, int[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(String logCode, long[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(String logCode, float[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(String logCode, double[] embeds, Throwable oException) {
        this.write(Locale.getDefault(), logCode, embeds, oException);
    }

    public void write(Locale lo, String logCode, Object[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(Locale lo, String logCode, byte[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(Locale lo, String logCode, short[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(Locale lo, String logCode, char[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(Locale lo, String logCode, int[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(Locale lo, String logCode, long[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(Locale lo, String logCode, float[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(Locale lo, String logCode, double[] embeds, Throwable oException) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, LogService.convertStringArray(embeds), oException);
    }

    public void write(AppException e) {
        this.write(Locale.getDefault(), e);
    }

    public void write(Locale lo, AppException e) {
        MessageRecord tmp = e.getMessageRecord();
        LogMessageRecord messageRecord = null;
        if (tmp instanceof LogMessageRecord) {
            messageRecord = (LogMessageRecord)tmp;
        }
        if (messageRecord == null || !this.isWrite(messageRecord)) {
            return;
        }
        this.write(messageRecord, lo, (String)null, (Throwable)e);
    }

    public boolean isWrite(String logCode) {
        LogMessageRecord messageRecord = (LogMessageRecord)this.messageFactory.findMessageRecord(logCode);
        return messageRecord != null && this.isWrite(messageRecord);
    }

    public boolean isDebugWrite() {
        return this.isDebugEnabled;
    }

    protected static String getStackTraceString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        String stack = sw.toString();
        if (stack.endsWith(System.getProperty(LINE_SEPARATOR_KEY))) {
            stack = stack.substring(0, stack.length() - 2);
        }
        return stack;
    }

    protected void setEnabled(String categoryName, boolean isEnabled) {
        LogCategory category = this.getCategoryService(categoryName);
        if (category == null) {
            return;
        }
        category.setEnabled(isEnabled);
    }

    protected boolean isEnabled(String categoryName, boolean defaultEnabled) {
        LogCategory category = this.getCategoryService(categoryName);
        if (category == null) {
            return defaultEnabled;
        }
        return category.isEnabled();
    }

    public void setDebugEnabled(boolean isEnabled) {
        this.isDebugEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.DEBUG_METHOD_CATEGORY", isEnabled);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.DEBUG_METHOD_CATEGORY", this.isDebugEnabled);
    }

    public void setSystemDebugEnabled(boolean isEnabled) {
        this.isSystemDebugEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.SYSTEM_DEBUG_CATEGORY", isEnabled);
    }

    public boolean isSystemDebugEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.SYSTEM_DEBUG_CATEGORY", this.isSystemDebugEnabled);
    }

    public void setSystemInfoEnabled(boolean isEnabled) {
        this.isSystemInfoEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.SYSTEM_INFO_CATEGORY", isEnabled);
    }

    public boolean isSystemInfoEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.SYSTEM_INFO_CATEGORY", this.isSystemInfoEnabled);
    }

    public void setSystemWarnEnabled(boolean isEnabled) {
        this.isSystemWarnEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.SYSTEM_WARN_CATEGORY", isEnabled);
    }

    public boolean isSystemWarnEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.SYSTEM_WARN_CATEGORY", this.isSystemWarnEnabled);
    }

    public void setSystemErrorEnabled(boolean isEnabled) {
        this.isSystemErrorEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.SYSTEM_ERROR_CATEGORY", isEnabled);
    }

    public boolean isSystemErrorEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.SYSTEM_ERROR_CATEGORY", this.isSystemErrorEnabled);
    }

    public void setSystemFatalEnabled(boolean isEnabled) {
        this.isSystemFatalEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.SYSTEM_FATAL_CATEGORY", isEnabled);
    }

    public boolean isSystemFatalEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.SYSTEM_FATAL_CATEGORY", this.isSystemFatalEnabled);
    }

    public void setDebugMessageWriterServiceName(ServiceName name) {
        this.debugMessageWriterServiceName = name;
    }

    public ServiceName getDebugMessageWriterServiceName() {
        return this.debugMessageWriterServiceName;
    }

    public void setSystemDebugMessageWriterServiceName(ServiceName name) {
        this.systemDebugMessageWriterServiceName = name;
    }

    public ServiceName getSystemDebugMessageWriterServiceName() {
        return this.systemDebugMessageWriterServiceName;
    }

    public void setSystemInfoMessageWriterServiceName(ServiceName name) {
        this.systemInfoMessageWriterServiceName = name;
    }

    public ServiceName getSystemInfoMessageWriterServiceName() {
        return this.systemInfoMessageWriterServiceName;
    }

    public void setSystemWarnMessageWriterServiceName(ServiceName name) {
        this.systemWarnMessageWriterServiceName = name;
    }

    public ServiceName getSystemWarnMessageWriterServiceName() {
        return this.systemWarnMessageWriterServiceName;
    }

    public void setSystemErrorMessageWriterServiceName(ServiceName name) {
        this.systemErrorMessageWriterServiceName = name;
    }

    public ServiceName getSystemErrorMessageWriterServiceName() {
        return this.systemErrorMessageWriterServiceName;
    }

    public void setSystemFatalMessageWriterServiceName(ServiceName name) {
        this.systemFatalMessageWriterServiceName = name;
    }

    public ServiceName getSystemFatalMessageWriterServiceName() {
        return this.systemFatalMessageWriterServiceName;
    }

    public void setDebugWritableRecordFactoryServiceName(ServiceName name) {
        this.debugRecordFactoryServiceName = name;
    }

    public ServiceName getDebugWritableRecordFactoryServiceName() {
        return this.debugRecordFactoryServiceName;
    }

    public void setSystemDebugWritableRecordFactoryServiceName(ServiceName name) {
        this.systemDebugRecordFactoryServiceName = name;
    }

    public ServiceName getSystemDebugWritableRecordFactoryServiceName() {
        return this.systemDebugRecordFactoryServiceName;
    }

    public void setSystemInfoWritableRecordFactoryServiceName(ServiceName name) {
        this.systemInfoRecordFactoryServiceName = name;
    }

    public ServiceName getSystemInfoWritableRecordFactoryServiceName() {
        return this.systemInfoRecordFactoryServiceName;
    }

    public void setSystemWarnWritableRecordFactoryServiceName(ServiceName name) {
        this.systemWarnRecordFactoryServiceName = name;
    }

    public ServiceName getSystemWarnWritableRecordFactoryServiceName() {
        return this.systemWarnRecordFactoryServiceName;
    }

    public void setSystemErrorWritableRecordFactoryServiceName(ServiceName name) {
        this.systemErrorRecordFactoryServiceName = name;
    }

    public ServiceName getSystemErrorWritableRecordFactoryServiceName() {
        return this.systemErrorRecordFactoryServiceName;
    }

    public void setSystemFatalWritableRecordFactoryServiceName(ServiceName name) {
        this.systemFatalRecordFactoryServiceName = name;
    }

    public ServiceName getSystemFatalWritableRecordFactoryServiceName() {
        return this.systemFatalRecordFactoryServiceName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

