/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.message;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.UnicodeHexBufferedReader;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.message.MessageRecord;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.message.MessageRecordFactoryServiceMBean;
import jp.ossc.nimbus.service.message.MessageRecordOperator;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class MessageRecordFactoryService
extends ServiceBase
implements MessageRecordFactory,
MessageRecordFactoryServiceMBean {
    protected CsvArrayList mDir = new CsvArrayList();
    protected HashMap mMessageMap = new HashMap();
    protected String mExtention = "def";
    protected Class mMessageRecordClass = class$jp$ossc$nimbus$service$message$MessageRecordImpl == null ? (class$jp$ossc$nimbus$service$message$MessageRecordImpl = MessageRecordFactoryService.class$("jp.ossc.nimbus.service.message.MessageRecordImpl")) : class$jp$ossc$nimbus$service$message$MessageRecordImpl;
    protected String mMessageRecordClassName = this.mMessageRecordClass.getName();
    protected boolean mIsSecret = false;
    protected String[] mLocales = null;
    protected HashMap mSerchedLocale = null;
    protected HashMap mSerchedPath = null;
    protected CsvArrayList mDefFileNames = new CsvArrayList();
    private static final String C_DFAULT_DEF = "jp/ossc/nimbus/resource/Nimbus";
    private static final String C_UNDER_SCORE = "_";
    private static final String C_SLUSH = "/";
    private static final String C_BKSLA = "\\";
    static /* synthetic */ Class class$jp$ossc$nimbus$service$message$MessageRecordImpl;

    public MessageRecordFactoryService() {
        this.mDefFileNames.add(C_DFAULT_DEF);
        this.mLocales = new String[0];
        this.mSerchedLocale = new HashMap();
        this.mSerchedPath = new HashMap();
    }

    public void setMessageDirPaths(String path) throws ServiceException {
        this.mDir.clear();
        this.mDir.split(path, ";");
        if (this.mDir.size() <= 0) {
            throw new ServiceException("MSG000000", "path info none");
        }
    }

    public void addMessageDirPaths(String path) throws ServiceException {
        CsvArrayList tmpAry = new CsvArrayList();
        tmpAry.split(path, ";");
        if (tmpAry.size() <= 0) {
            return;
        }
        ListIterator listIterator = tmpAry.listIterator();
        while (listIterator.hasNext()) {
            String defFilePath = (String)listIterator.next();
            boolean bFlg = false;
            for (int cnt = 0; cnt < this.mDir.size(); ++cnt) {
                if (!this.mDir.getStr(cnt).equals(defFilePath)) continue;
                bFlg = true;
                break;
            }
            if (bFlg) continue;
            this.mDir.add(defFilePath);
            File errDefDir = new File(defFilePath);
            this.setMessageDef(errDefDir);
            this.searchMessageDef(errDefDir);
        }
    }

    public String getMessageDirPaths() {
        return this.mDir.join(";");
    }

    public void setExtentionOfMessageFile(String extention) {
        this.mExtention = extention;
    }

    public String getExtentionOfMessageFile() {
        return this.mExtention;
    }

    public void setMessageRecordClassName(String className) throws ServiceException {
        this.mMessageRecordClassName = className;
        try {
            this.mMessageRecordClass = Class.forName(className, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException ce) {
            throw new ServiceException("MSG000030", "MessageRecordClassName is invalid class name is " + this.mMessageRecordClassName, ce);
        }
    }

    public String getMessageRecordClassName() {
        return this.mMessageRecordClass.getName();
    }

    public void startService() throws ServiceException {
        String defFilePath = null;
        this.mSerchedLocale = new HashMap();
        this.mSerchedPath = new HashMap();
        if (this.mMessageMap.isEmpty()) {
            ListIterator listIterator = this.mDir.listIterator();
            while (listIterator.hasNext()) {
                defFilePath = (String)listIterator.next();
                File errDefDir = new File(defFilePath);
                this.setMessageDef(errDefDir);
                this.searchMessageDef(errDefDir);
            }
            listIterator = this.mDefFileNames.listIterator();
            while (listIterator.hasNext()) {
                String fileName = (String)listIterator.next();
                URL url = Thread.currentThread().getContextClassLoader().getResource(fileName + "." + this.mExtention);
                try {
                    if (url == null || url.openStream() == null) continue;
                    try {
                        this.readStream(url.openStream(), null);
                    }
                    catch (IOException ie) {
                        throw new ServiceException("MSGRECORDSERVICE520", "I/O Error Ocurred When Reading define message File. File  is " + fileName, ie);
                    }
                    for (int j = 0; j < this.mLocales.length; ++j) {
                        this.readDefFile(this.mLocales[j], fileName);
                    }
                }
                catch (IOException e) {
                }
            }
        }
    }

    private void getDirByLocale(Locale lo, String dirPath) {
        StringBuffer propKey = null;
        String key = null;
        String result = null;
        boolean bret = false;
        File dirFile = null;
        propKey = new StringBuffer(dirPath);
        propKey.append(C_SLUSH).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
        key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
        result = (String)this.mSerchedPath.get(key);
        if (result != null || !(bret = this.addMessageDef(dirFile = new File(key)))) {
            propKey = new StringBuffer(dirPath);
            propKey.append(C_SLUSH).append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
            key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
            result = (String)this.mSerchedPath.get(key);
            if (result != null || !(bret = this.addMessageDef(dirFile = new File(key)))) {
                propKey = new StringBuffer(dirPath);
                propKey.append(C_SLUSH).append(lo.getLanguage());
                key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
                result = (String)this.mSerchedPath.get(key);
                if (!(result == null && (bret = this.addMessageDef(dirFile = new File(key))) || lo.equals(Locale.getDefault()))) {
                    Locale loDafault = Locale.getDefault();
                    propKey = new StringBuffer(dirPath);
                    propKey.append(C_SLUSH).append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry()).append(C_UNDER_SCORE).append(loDafault.getVariant());
                    key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
                    result = (String)this.mSerchedPath.get(key);
                    if (result != null || !(bret = this.addMessageDef(dirFile = new File(key)))) {
                        propKey = new StringBuffer(dirPath);
                        propKey.append(C_SLUSH).append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry());
                        key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
                        result = (String)this.mSerchedPath.get(key);
                        if (result != null || !(bret = this.addMessageDef(dirFile = new File(key)))) {
                            propKey = new StringBuffer(dirPath);
                            propKey.append(C_SLUSH).append(loDafault.getLanguage());
                            key = StringOperator.replaceString(propKey.toString(), C_BKSLA, C_SLUSH);
                            result = (String)this.mSerchedPath.get(key);
                            if (result != null || (bret = this.addMessageDef(dirFile = new File(key)))) {
                                // empty if block
                            }
                        }
                    }
                }
            }
        }
    }

    private void getClassPathByLocale(Locale lo, String defFileName) {
        StringBuffer propKey = new StringBuffer();
        String result = null;
        boolean bret = false;
        String fileName = null;
        propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
        fileName = defFileName + C_UNDER_SCORE + propKey.toString() + "." + this.mExtention;
        result = (String)this.mSerchedPath.get(fileName);
        if (result != null || !(bret = this.readDefFile(propKey.toString(), defFileName))) {
            propKey = new StringBuffer();
            propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
            fileName = defFileName + C_UNDER_SCORE + propKey.toString() + "." + this.mExtention;
            result = (String)this.mSerchedPath.get(fileName);
            if (result != null || !(bret = this.readDefFile(propKey.toString(), defFileName))) {
                propKey = new StringBuffer();
                propKey.append(lo.getLanguage());
                fileName = defFileName + C_UNDER_SCORE + propKey.toString() + "." + this.mExtention;
                result = (String)this.mSerchedPath.get(fileName);
                if (!(result == null && (bret = this.readDefFile(propKey.toString(), defFileName)) || lo.equals(Locale.getDefault()))) {
                    Locale loDafault = Locale.getDefault();
                    propKey = new StringBuffer();
                    propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry()).append(C_UNDER_SCORE).append(loDafault.getVariant());
                    fileName = defFileName + C_UNDER_SCORE + propKey.toString() + "." + this.mExtention;
                    result = (String)this.mSerchedPath.get(fileName);
                    if (result != null || !(bret = this.readDefFile(propKey.toString(), defFileName))) {
                        propKey = new StringBuffer();
                        propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry());
                        fileName = defFileName + C_UNDER_SCORE + propKey.toString() + "." + this.mExtention;
                        result = (String)this.mSerchedPath.get(fileName);
                        if (result != null || !(bret = this.readDefFile(propKey.toString(), defFileName))) {
                            propKey = new StringBuffer();
                            propKey.append(loDafault.getLanguage());
                            fileName = defFileName + C_UNDER_SCORE + propKey.toString() + "." + this.mExtention;
                            result = (String)this.mSerchedPath.get(fileName);
                            if (result != null || (bret = this.readDefFile(propKey.toString(), defFileName))) {
                                // empty if block
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean readDefFile(String loString, String defName) {
        String fileName = defName + C_UNDER_SCORE + loString + "." + this.mExtention;
        URL url = null;
        boolean bret = false;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        url = classLoader.getResource(fileName);
        try {
            if (url != null && url.openStream() != null) {
                this.readStream(url.openStream(), loString);
                this.mSerchedPath.put(fileName, "1");
                bret = true;
            } else {
                this.mSerchedPath.put(fileName, "0");
            }
        }
        catch (IOException e) {
            this.mSerchedPath.put(fileName, "0");
            return false;
        }
        return bret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findLocale(Locale lo) {
        HashMap hashMap = this.mSerchedLocale;
        synchronized (hashMap) {
            Locale locale = null;
            Locale tmpLo = null;
            tmpLo = lo == null ? Locale.getDefault() : lo;
            locale = (Locale)this.mSerchedLocale.get(tmpLo);
            if (locale == null) {
                ListIterator listIterator = this.mDir.listIterator();
                while (listIterator.hasNext()) {
                    String defDirPath = (String)listIterator.next();
                    this.getDirByLocale(tmpLo, defDirPath);
                }
                listIterator = this.mDefFileNames.listIterator();
                while (listIterator.hasNext()) {
                    String fileName = (String)listIterator.next();
                    this.getClassPathByLocale(tmpLo, fileName);
                }
                this.mSerchedLocale.put(tmpLo, tmpLo);
            }
        }
    }

    protected void searchMessageDef(File dirRoot) {
        if (this.mLocales == null || this.mLocales.length == 0) {
            return;
        }
        File[] dirs = dirRoot.listFiles();
        if (dirs != null) {
            block0: for (int cnt = 0; cnt < dirs.length; ++cnt) {
                if (!dirs[cnt].isDirectory()) continue;
                this.name = dirs[cnt].getName();
                for (int j = 0; j < this.mLocales.length; ++j) {
                    if (!this.name.equals(this.mLocales[j])) continue;
                    this.addMessageDef(dirs[cnt]);
                    continue block0;
                }
            }
        }
    }

    protected boolean addMessageDef(File dir) {
        ExtentionFileFilter filter = new ExtentionFileFilter(this.mExtention);
        File[] defFileList = dir.listFiles(filter);
        boolean bret = false;
        if (defFileList != null) {
            for (int rCnt = 0; rCnt < defFileList.length; ++rCnt) {
                String filePath = null;
                if (defFileList[rCnt].isDirectory()) continue;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(defFileList[rCnt]);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                try {
                    this.readStream(stream, dir.getName());
                    continue;
                }
                catch (IOException ie) {
                    throw new ServiceException("MSGRECORDSERVICE020", "I/O Error Ocurred When Reading define message File. File  is " + filePath, ie);
                }
            }
            this.mSerchedPath.put(dir.getAbsolutePath(), "1");
            bret = true;
        } else {
            this.mSerchedPath.put(dir.getAbsolutePath(), "0");
        }
        return bret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStream(InputStream stream, String locale) throws IOException {
        UnicodeHexBufferedReader in = null;
        in = new UnicodeHexBufferedReader(new InputStreamReader(stream));
        String record = null;
        try {
            while ((record = in.readLine()) != null) {
                if (record.length() == 0 || record.startsWith("#")) continue;
                if (locale == null) {
                    this.putDefRec(record);
                    continue;
                }
                this.addDefRec(record, locale);
            }
        }
        finally {
            in.close();
            stream.close();
        }
    }

    protected void setMessageDef(File dirRoot) {
        ExtentionFileFilter filter = new ExtentionFileFilter(this.mExtention);
        File[] defFileList = dirRoot.listFiles(filter);
        if (defFileList != null) {
            for (int rCnt = 0; rCnt < defFileList.length; ++rCnt) {
                String filePath = null;
                if (!defFileList[rCnt].isFile()) continue;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(defFileList[rCnt]);
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                try {
                    this.readStream(stream, null);
                    continue;
                }
                catch (IOException ie) {
                    throw new ServiceException("MSGRECORDSERVICE020", "I/O Error Ocurred When Reading define message File. File  is " + filePath, ie);
                }
            }
        }
    }

    public void stopService() {
        this.mMessageMap.clear();
    }

    protected void addDefRec(String record, String locale) {
        CsvArrayList ps = new CsvArrayList();
        ps.split(record, ",");
        if (ps.size() < 2) {
            throw new ServiceException("MESSAGERECORDSERVICEA00", "record format error record is " + record);
        }
        MessageRecordOperator messageRec = (MessageRecordOperator)this.mMessageMap.get(ps.getStr(0));
        if (messageRec == null) {
            throw new ServiceException("MESSAGERECORDSERVICEA01", "record id invalid. record is " + record);
        }
        messageRec.addMessage(ps.getStr(1), locale);
    }

    protected void putDefRec(String record) {
        MessageRecordOperator messageRec = null;
        try {
            messageRec = (MessageRecordOperator)this.mMessageRecordClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServiceException("MESSAGERECORDSERVICE030", "newInstance() failed.Class name is " + this.mMessageRecordClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("MESSAGERECORDSERVICE040", "newInstance() failed.Class name is " + this.mMessageRecordClass.getName(), e);
        }
        messageRec.rec2Obj(record);
        messageRec.setFactory(this);
        MessageRecord rec = (MessageRecord)((Object)messageRec);
        MessageRecordOperator tmpRec = (MessageRecordOperator)this.mMessageMap.get(rec.getMessageCode());
        if (tmpRec != null) {
            throw new ServiceException("MESSAGERECORDSERVICE041", "message code duplicate.recode is " + record);
        }
        this.mMessageMap.put(rec.getMessageCode(), messageRec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getMessgaeList() {
        MessageRecordOperator rec = null;
        ArrayList<String> retAry = new ArrayList<String>();
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            Collection c = this.mMessageMap.values();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                rec = (MessageRecordOperator)i.next();
                retAry.add(((Object)rec).toString());
            }
        }
        return retAry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUsedMessgaeList() {
        ArrayList<String> retAry = new ArrayList<String>();
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            Collection c = this.mMessageMap.values();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                MessageRecordOperator container = (MessageRecordOperator)i.next();
                if (container.getUsedCount() <= 0L) continue;
                retAry.add(((Object)container).toString());
            }
        }
        return retAry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initUsedCount() {
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            Collection c = this.mMessageMap.values();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                MessageRecordOperator container = (MessageRecordOperator)i.next();
                container.clearUsedCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageRecord findMessageRecord(String key) {
        MessageRecord eif;
        HashMap hashMap = this.mMessageMap;
        synchronized (hashMap) {
            eif = (MessageRecord)this.mMessageMap.get(key);
            if (eif != null) {
                MessageRecordOperator op = (MessageRecordOperator)((Object)eif);
                op.setSecret(this.mIsSecret);
            }
        }
        return eif;
    }

    public void setSecretMode(boolean flg) {
        this.mIsSecret = flg;
    }

    public boolean getSecretMode() {
        return this.mIsSecret;
    }

    public void setLocaleStrings(String[] locales) {
        this.mLocales = locales;
    }

    public String findMessageTemplete(Locale lo, String key) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.getMessageTemplate(lo);
    }

    public String findMessageTemplete(String key) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.getMessageTemplate();
    }

    public String findMessage(Locale lo, String key) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo);
    }

    public String findMessage(String key) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage();
    }

    public String findEmbedMessage(Locale lo, String key, Object[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(Locale lo, String key, byte[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(Locale lo, String key, short[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(Locale lo, String key, char[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(Locale lo, String key, int[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(Locale lo, String key, long[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(Locale lo, String key, float[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(Locale lo, String key, double[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embeds);
    }

    public String findEmbedMessage(String key, Object[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(String key, byte[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(String key, short[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(String key, char[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(String key, int[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(String key, long[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(String key, float[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(String key, double[] embeds) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embeds);
    }

    public String findEmbedMessage(Locale lo, String key, Object embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(Locale lo, String key, byte embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(Locale lo, String key, short embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(Locale lo, String key, char embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(Locale lo, String key, int embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(Locale lo, String key, long embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(Locale lo, String key, float embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(Locale lo, String key, double embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(lo, embed);
    }

    public String findEmbedMessage(String key, Object embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public String findEmbedMessage(String key, byte embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public String findEmbedMessage(String key, short embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public String findEmbedMessage(String key, char embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public String findEmbedMessage(String key, int embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public String findEmbedMessage(String key, long embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public String findEmbedMessage(String key, float embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public String findEmbedMessage(String key, double embed) {
        MessageRecord rec = this.findMessageRecord(key);
        if (rec == null) {
            return null;
        }
        return rec.makeMessage(embed);
    }

    public void setMessageFiles(String files) throws Exception {
        this.mDefFileNames.clear();
        this.mDefFileNames.split(files, ";");
        this.mDefFileNames.add(C_DFAULT_DEF);
    }

    public void addMessageFiles(String files) throws Exception {
        CsvArrayList tmp = new CsvArrayList();
        tmp.split(files, ";");
        if (tmp.size() <= 0) {
            return;
        }
        ListIterator listIterator = tmp.listIterator();
        while (listIterator.hasNext()) {
            String fileName = (String)listIterator.next();
            boolean bFlg = false;
            for (int cnt = 0; cnt < this.mDir.size(); ++cnt) {
                if (!this.mDefFileNames.getStr(cnt).equals(fileName)) continue;
                bFlg = true;
                break;
            }
            if (bFlg) continue;
            URL url = Thread.currentThread().getContextClassLoader().getResource(fileName + "." + this.mExtention);
            try {
                if (url == null || url.openStream() == null) continue;
                try {
                    this.readStream(url.openStream(), null);
                }
                catch (IOException ie) {
                    throw new ServiceException("MSGRECORDSERVICE520", "I/O Error Ocurred When Reading define message File. File  is " + fileName, ie);
                }
                for (int j = 0; j < this.mLocales.length; ++j) {
                    this.readDefFile(this.mLocales[j], fileName);
                }
            }
            catch (IOException e) {
            }
        }
    }

    public String getMessageFiles() throws Exception {
        return this.mDefFileNames.join(";");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

