/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.publish.DefaultPublisherServiceMBean;
import jp.ossc.nimbus.service.publish.IfProtocol;
import jp.ossc.nimbus.service.publish.IfServant;
import jp.ossc.nimbus.service.publish.ProtocolFactory;
import jp.ossc.nimbus.service.publish.PublishContainer;
import jp.ossc.nimbus.service.publish.PublishContainerFactoryService;
import jp.ossc.nimbus.service.publish.Publisher;
import jp.ossc.nimbus.service.publish.ServantGarbager;

public class DefaultPublisherService
extends ServiceBase
implements DefaultPublisherServiceMBean,
DaemonRunnable,
Publisher {
    private boolean mSslMode = false;
    private int mPortNo = 0;
    private ServiceName mLogServiceName = null;
    private Logger mLogger = null;
    private ProtocolFactory mProtocolFactory = null;
    private int mContainerNum = 0;
    private Selector mSelector;
    protected Daemon mDaemon = null;
    protected Map mSocketChannelBagMap = new HashMap();
    protected List mContainerList;
    protected List mContainerDaemonList;
    private ServiceName mPublishContainerFactoryServiceName = null;
    private PublishContainerFactoryService mContainerFactory = null;
    private int mGavageIntervalMinutes = 0;
    private Daemon mGarbageDaemon = null;
    private ServiceName mProtocolFactoryServiceName = null;
    private IfProtocol mProtocol = null;
    private ServiceName mCodeMasterFinderServiceName = null;
    private CodeMasterFinder mCodeMasterFinder = null;
    private String mAuthMapKey = null;
    private ServerSocketChannel mServerSocketChannel = null;

    public void setLogServiceName(ServiceName name) {
        this.mLogServiceName = name;
    }

    public ServiceName getLogServiceName() {
        return this.mLogServiceName;
    }

    public void setProtocolFactoryServiceName(ServiceName name) {
        this.mProtocolFactoryServiceName = name;
    }

    public ServiceName getProtocolFactoryServiceName() {
        return this.mProtocolFactoryServiceName;
    }

    public ServiceName getPublishContainerFactoryServiceName() {
        return this.mPublishContainerFactoryServiceName;
    }

    public void setSslListenerMode(boolean isSslFlg) {
        this.mSslMode = isSslFlg;
    }

    public boolean isSslListenerMode() {
        return this.mSslMode;
    }

    public void setPortNo(int port) {
        this.mPortNo = port;
    }

    public int getPortNo() {
        return this.mPortNo;
    }

    public void setContainerNum(int num) {
        this.mContainerNum = num;
    }

    public int getContainerNum() {
        return this.mContainerNum;
    }

    public void startService() throws Exception {
        this.mLogger = (Logger)((Object)ServiceManagerFactory.getService(this.mLogServiceName));
        this.mProtocolFactory = (ProtocolFactory)((Object)ServiceManagerFactory.getService(this.mProtocolFactoryServiceName));
        this.mContainerFactory = (PublishContainerFactoryService)ServiceManagerFactory.getServiceObject(this.mPublishContainerFactoryServiceName);
        this.mCodeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.mCodeMasterFinderServiceName);
        this.mContainerList = new ArrayList(this.mContainerNum);
        this.mContainerDaemonList = new ArrayList(this.mContainerNum);
        for (int icnt = 0; icnt < this.mContainerNum; ++icnt) {
            PublishContainer publishContainer = this.createPublishContainer();
            Daemon pcDaemon = new Daemon(publishContainer);
            this.mContainerList.add(publishContainer);
            this.mContainerDaemonList.add(pcDaemon);
            pcDaemon.start();
        }
        ServantGarbager gb = new ServantGarbager(this.mSocketChannelBagMap, this.mGavageIntervalMinutes);
        this.mGarbageDaemon = new Daemon(gb);
        this.mProtocol = this.mProtocolFactory.createProtocol();
        this.mSelector = SelectorProvider.provider().openSelector();
        this.mServerSocketChannel = ServerSocketChannel.open();
        this.mServerSocketChannel.configureBlocking(false);
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLocalHost(), this.mPortNo);
        this.mServerSocketChannel.socket().bind(address);
        this.mServerSocketChannel.register(this.mSelector, 16);
        this.mDaemon = new Daemon(this);
        this.mDaemon.start();
    }

    public void stopService() {
        try {
            this.mServerSocketChannel.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.mDaemon.stop();
        for (int icnt = 0; icnt < this.mContainerNum; ++icnt) {
            Daemon pcDaemon = (Daemon)this.mContainerDaemonList.get(icnt);
            pcDaemon.stop();
        }
        try {
            this.mSelector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void destroyService() {
        this.mLogger = null;
        this.mProtocol = null;
        this.mSelector = null;
    }

    public boolean onStop() {
        this.mGarbageDaemon.stop();
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Throwable {
        int count = this.mSelector.select();
        if (count > 0) {
            return this.mSelector.selectedKeys();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        if (paramObj == null) {
            return;
        }
        Set selected = (Set)paramObj;
        Iterator keyIterator = selected.iterator();
        while (keyIterator.hasNext()) {
            try {
                SelectionKey key = (SelectionKey)keyIterator.next();
                if (key.isAcceptable()) {
                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
                    this.accept(serverSocketChannel);
                    continue;
                }
                if (!key.isReadable()) continue;
                SocketChannel socketChannel = (SocketChannel)key.channel();
                this.read(key, socketChannel);
            }
            finally {
                keyIterator.remove();
            }
        }
    }

    protected void read(SelectionKey key, SocketChannel socketChanel) {
        try {
            if (!this.mProtocol.analyze(socketChanel, this)) {
                System.out.println("Client disconnect!");
                socketChanel.finishConnect();
                key.cancel();
            }
        }
        catch (Throwable e) {
            System.out.println("Client disconnect from network !");
            try {
                socketChanel.finishConnect();
            }
            catch (IOException e1) {
                // empty catch block
            }
            key.cancel();
        }
    }

    protected void accept(ServerSocketChannel serverSocketChannel) throws IOException {
        SocketChannel socketChannel = serverSocketChannel.accept();
        socketChannel.configureBlocking(false);
        socketChannel.register(this.mSelector, 1);
    }

    public void garbage() {
    }

    public boolean onStart() {
        this.mGarbageDaemon.start();
        return true;
    }

    public PublishContainer createPublishContainer() {
        return (PublishContainer)this.mContainerFactory.createInstance();
    }

    public void setPublishContainerFactoryServiceName(ServiceName name) {
        this.mPublishContainerFactoryServiceName = name;
    }

    public void setGarbageIntervalMinutes(int garbageInterval) {
        this.mGavageIntervalMinutes = garbageInterval;
    }

    public int getGarbageIntervalMinutes() {
        return this.mGavageIntervalMinutes;
    }

    public int entryServant(IfServant svt) {
        String key = svt.getSelectionKey();
        if (this.mSocketChannelBagMap.containsKey(key)) {
            return 1;
        }
        int contNum = -1;
        int clientNum = this.mContainerFactory.getMaxClientSize();
        for (int cnt = 0; cnt < this.mContainerNum; ++cnt) {
            PublishContainer cont = (PublishContainer)this.mContainerList.get(cnt);
            int cnum = cont.size();
            if (clientNum <= cnum) continue;
            clientNum = cnum;
            contNum = cnt;
        }
        if (contNum > -1) {
            PublishContainer cont = (PublishContainer)this.mContainerList.get(contNum);
            cont.addClient(svt);
            this.mSocketChannelBagMap.put(key, svt);
            return 0;
        }
        return 2;
    }

    public IfServant findServant(String key) {
        IfServant ret = (IfServant)this.mSocketChannelBagMap.get(key);
        return ret;
    }

    public Object getAuthObject() {
        Map codeMap = this.mCodeMasterFinder.getCodeMasters();
        Object apm = codeMap.get(this.mAuthMapKey);
        return apm;
    }

    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.mCodeMasterFinderServiceName = name;
    }

    public ServiceName getCodeMasterFinderServiceName() {
        return this.mCodeMasterFinderServiceName;
    }

    public void setAuthObjectMapKey(String key) {
        this.mAuthMapKey = key;
    }
}

