/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.remote.invoker;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.remote.RemoteServerInvoker;
import jp.ossc.nimbus.service.remote.RemoteServiceCallException;
import jp.ossc.nimbus.service.remote.invoker.RemoteClientMethodCallInvokerServiceMBean;

public class RemoteClientMethodCallInvokerService
extends ServiceBase
implements Invoker,
Serializable,
RemoteClientMethodCallInvokerServiceMBean {
    private ServiceName jndiFinderServiceName;
    private JndiFinder finder;
    private String jndiName;

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setRemoteServerJndiName(String name) {
        this.jndiName = name;
    }

    public String getRemoteServerJndiName() {
        return this.jndiName;
    }

    public void startService() throws Exception {
        if (this.jndiFinderServiceName == null) {
            throw new IllegalArgumentException("jndiFinderServiceName must be specified.");
        }
        this.finder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        if (this.jndiName == null) {
            throw new IllegalArgumentException("jndiName must be specified.");
        }
    }

    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        try {
            RemoteServerInvoker serverInvoker = (RemoteServerInvoker)this.finder.lookup(this.jndiName);
            return serverInvoker.invoke(context);
        }
        catch (NamingException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (RemoteException e) {
            throw new RemoteServiceCallException(e);
        }
    }
}

