/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.writer.SimpleElement;
import jp.ossc.nimbus.service.writer.WritableElement;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.WritableRecordFactory;
import jp.ossc.nimbus.service.writer.WritableRecordFactoryServiceMBean;

public class WritableRecordFactoryService
extends ServiceBase
implements WritableRecordFactory,
WritableRecordFactoryServiceMBean,
Serializable {
    private static final String SIMPLE_ELEMENT_NAME = (class$jp$ossc$nimbus$service$writer$SimpleElement == null ? (class$jp$ossc$nimbus$service$writer$SimpleElement = WritableRecordFactoryService.class$("jp.ossc.nimbus.service.writer.SimpleElement")) : class$jp$ossc$nimbus$service$writer$SimpleElement).getName();
    private String mFormat = null;
    private List mParsedElements;
    private Properties mImplClasses;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$writer$SimpleElement;

    public void setImplementClasses(Properties prop) {
        this.mImplClasses = prop;
    }

    protected void setImplementClass(String key, String className) {
        this.mImplClasses.put(key, className);
    }

    protected String getImplementClass(String key) {
        return (String)this.mImplClasses.get(key);
    }

    public void setFormat(String fmt) {
        this.mFormat = fmt;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void createService() throws Exception {
        if (this.mImplClasses == null) {
            this.mImplClasses = new Properties();
        }
    }

    public void startService() throws Exception {
        try {
            this.mParsedElements = this.parseFormat();
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().write("SSWRF00001", (Object)this.mFormat, (Throwable)ex);
            throw ex;
        }
        Collection<Object> implClasses = this.mImplClasses.values();
        Iterator<Object> it = implClasses.iterator();
        while (it.hasNext()) {
            String implClassName = (String)it.next();
            try {
                WritableElement tmp = this.getInstance(implClassName);
            }
            catch (ServiceException e) {
                this.getLogger().write("SSWRF00002", (Object)implClassName, (Throwable)e);
                throw e;
            }
        }
    }

    public void stopService() throws Exception {
        this.mParsedElements = null;
    }

    public void destroyService() throws Exception {
        this.mImplClasses = null;
    }

    protected WritableElement createElement(String key, Object val) {
        WritableElement writableElem = null;
        if (this.getImplementClass(key) == null) {
            writableElem = this.getInstance(SIMPLE_ELEMENT_NAME);
        } else {
            String implClassName = this.getImplementClass(key);
            writableElem = this.getInstance(implClassName);
        }
        writableElem.setKey(key);
        writableElem.setValue(val);
        this.postCreateElement(writableElem);
        return writableElem;
    }

    protected Object getElementValue(String key, Map elements) {
        return elements.get(key);
    }

    protected void postCreateElement(WritableElement elem) {
    }

    public WritableRecord createRecord(Map elements) {
        if (this.getState() != 3) {
            throw new IllegalServiceStateException(this);
        }
        WritableRecord writableRec = new WritableRecord();
        if (this.mFormat == null || this.mFormat.length() == 0) {
            Iterator keys = elements.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                WritableElement elem = this.createElement(key, this.getElementValue(key, elements));
                writableRec.addElement(elem);
            }
        } else {
            int max = this.mParsedElements.size();
            for (int rCnt = 0; rCnt < max; ++rCnt) {
                ParsedElement parsedElem = (ParsedElement)this.mParsedElements.get(rCnt);
                if (parsedElem.isKeyElement()) {
                    String key = parsedElem.getValue();
                    WritableElement elem = this.createElement(key, this.getElementValue(key, elements));
                    if (elem == null) continue;
                    writableRec.addElement(elem);
                    continue;
                }
                SimpleElement simpleElem = new SimpleElement();
                simpleElem.setKey(simpleElem);
                simpleElem.setValue(parsedElem.getValue());
                writableRec.addElement(simpleElem);
            }
        }
        return writableRec;
    }

    protected WritableElement getInstance(String className) {
        WritableElement writableElem = null;
        try {
            Class<?> clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
            writableElem = (WritableElement)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("WRITABLERECORDFACTORY002", "IllegalAccess When creatCuiOperator() ", e);
        }
        catch (InstantiationException e) {
            throw new ServiceException("WRITABLERECORDFACTORY003", "Instanting failed", e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("WRITABLERECORDFACTORY004", "Class not found. name is " + className);
        }
        return writableElem;
    }

    protected List parseFormat() {
        if (this.mFormat == null || this.mFormat.length() == 0) {
            return null;
        }
        ArrayList<ParsedElement> result = new ArrayList<ParsedElement>();
        StringBuffer word = new StringBuffer("");
        boolean isStartKey = false;
        boolean isEscape = false;
        int max = this.mFormat.length();
        block4: for (int i = 0; i < max; ++i) {
            char c = this.mFormat.charAt(i);
            switch (c) {
                case '%': {
                    ParsedElement elem;
                    if (isEscape) {
                        word.append(c);
                        isEscape = false;
                        continue block4;
                    }
                    if (isStartKey) {
                        if (word.length() != 0) {
                            elem = new ParsedElement(word.toString(), true);
                            result.add(elem);
                            word.setLength(0);
                            isStartKey = false;
                            continue block4;
                        }
                        throw new IllegalArgumentException("Keyword must not be null. : " + this.mFormat);
                    }
                    if (word.length() > 0) {
                        elem = new ParsedElement(word.toString(), false);
                        result.add(elem);
                        word.setLength(0);
                    }
                    isStartKey = true;
                    continue block4;
                }
                case '\\': {
                    if (isEscape) {
                        word.append(c);
                        isEscape = false;
                        continue block4;
                    }
                    isEscape = true;
                    continue block4;
                }
                default: {
                    if (isEscape) {
                        throw new IllegalArgumentException("'' is escape character. : " + this.mFormat);
                    }
                    word.append(c);
                }
            }
        }
        if (isEscape) {
            throw new IllegalArgumentException("'' is escape character. : " + this.mFormat);
        }
        if (isStartKey) {
            throw new IllegalArgumentException("'%' is key separator character. : " + this.mFormat);
        }
        if (word.length() > 0) {
            ParsedElement elem = new ParsedElement(word.toString(), false);
            result.add(elem);
            word.setLength(0);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ParsedElement
    implements Serializable {
        private String mVal;
        private boolean mIsKeyWord;

        public ParsedElement(String val, boolean isKey) {
            this.mVal = val;
            this.mIsKeyWord = isKey;
        }

        public String getValue() {
            return this.mVal;
        }

        public boolean isKeyElement() {
            return this.mIsKeyWord;
        }
    }
}

