/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc.ejb.facade;

import java.lang.reflect.Method;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.IOCException;
import jp.ossc.nimbus.ioc.ejb.UtilTool;
import jp.ossc.nimbus.ioc.ejb.facade.SLSBFacadeHomeLocal;
import jp.ossc.nimbus.ioc.ejb.facade.SLSBFacadeLocal;
import jp.ossc.nimbus.service.aop.DefaultMethodInvocationContext;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InterceptorChainFactory;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvoker;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;

public class MDBFacadeBean
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 3583637962924535281L;
    private static final String C_FACADE_HOME_JNDI_KEY = "java:comp/env/facadeJNDIKey";
    private static final String C_INTERCEPTOR_SERVICE_NAME_JNDI_KEY = "java:comp/env/interceptorChainFactoryServiceNameJNDIKey";
    private static final String C_INTERCEPTOR_CREATE_JNDI_KEY = "java:comp/env/lookupKey";
    private SLSBFacadeLocal mFacadeLocal;
    private InterceptorChainInvokerFactory mFactory = null;
    private InterceptorChainFactory chainFactory = null;
    private String mInterceptorKey = null;
    private MessageDrivenContext mContext = null;
    private static Method CALLBACK_METHOD;

    public void ejbCreate() {
        try {
            InitialContext ctx = new InitialContext();
            String value = (String)ctx.lookup(C_FACADE_HOME_JNDI_KEY);
            SLSBFacadeHomeLocal facadeHomeLocal = (SLSBFacadeHomeLocal)ctx.lookup(value);
            this.mFacadeLocal = facadeHomeLocal.create();
            value = (String)ctx.lookup(C_INTERCEPTOR_SERVICE_NAME_JNDI_KEY);
            if (value == null || value.length() == 0) {
                this.mFactory = null;
            } else {
                ServiceName serviceName = UtilTool.convertServiceName(value);
                Object factory = ServiceManagerFactory.getServiceObject(serviceName);
                if (factory instanceof InterceptorChainInvokerFactory) {
                    this.mFactory = (InterceptorChainInvokerFactory)factory;
                } else {
                    this.chainFactory = (InterceptorChainFactory)factory;
                }
                this.mInterceptorKey = value = (String)ctx.lookup(C_INTERCEPTOR_CREATE_JNDI_KEY);
            }
        }
        catch (NamingException ne) {
            IOCException ee = new IOCException("MDBFacadeBean create Error NamingException");
            ee.initCause(ne);
            ee.printStackTrace();
            throw ee;
        }
        catch (CreateException e) {
            IOCException ee = new IOCException("MDBFacadeBean create Error NamingException");
            ee.initCause(e);
            ee.printStackTrace();
            throw ee;
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext arg0) throws EJBException {
        this.mContext = arg0;
    }

    protected MessageDrivenContext getMessageDrivenContext() {
        return this.mContext;
    }

    public void ejbRemove() throws EJBException {
    }

    public void onMessage(Message message) {
        try {
            this.invokeInterceptor(message);
            return;
        }
        catch (InterceptorException e) {
            throw new EJBException("MDBFacadeBean onMessage Interceptor Error", (Exception)e);
        }
        catch (TargetCheckedException e) {
            throw new EJBException("MDBFacadeBean onMessage CheckedError", (Exception)e);
        }
        catch (TargetUncheckedException e) {
            throw new EJBException("MDBFacadeBean onMessage UnCheckedError", (Exception)e);
        }
        catch (Throwable e) {
            IOCException ee = new IOCException("MDBFacadeBeane onMessage UnRecognize Error", e);
            throw new EJBException("MDBFacadeBean onMessage UnRecognize Error", (Exception)ee);
        }
    }

    public Object invokeInterceptor(Object input) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        Object ret;
        block13: {
            ret = null;
            if (this.mFactory == null && this.chainFactory == null) {
                try {
                    ret = this.invokeUnitOfWorkBase(input);
                }
                catch (IOCException e) {
                    throw new TargetUncheckedException(e.getCause());
                }
                catch (Throwable e) {
                    throw new TargetUncheckedException(e);
                }
            }
            if (this.mFactory != null) {
                InterceptorChainInvoker ici = this.mFactory.createInterceptorInvoker(this.mInterceptorKey);
                ret = ici.invokeChain(this, input);
            } else {
                try {
                    InterceptorChain chain = this.chainFactory.getInterceptorChain(this.mInterceptorKey);
                    ret = chain.invokeNext(new DefaultMethodInvocationContext(this, CALLBACK_METHOD, new Object[]{input}));
                }
                catch (TargetUncheckedException e) {
                    throw e;
                }
                catch (TargetCheckedException e) {
                    throw e;
                }
                catch (InterceptorException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOCException(e);
                }
                catch (Throwable th) {
                    if (!(th instanceof Error)) break block13;
                    throw (Error)th;
                }
            }
        }
        return ret;
    }

    public Object invokeUnitOfWorkBase(Object uow) throws Exception {
        Object ret = null;
        try {
            ret = this.mFacadeLocal.invoke(uow);
        }
        catch (EJBException e) {
            Exception ex = e.getCausedByException();
            throw ex;
        }
        catch (Throwable e) {
            IOCException ex = new IOCException("MDBFacadeBean#invokeUnitOfWorkBase Unrecognized Error ", e);
            throw ex;
        }
        return ret;
    }

    static {
        try {
            CALLBACK_METHOD = MDBFacadeBean.class.getMethod("invokeUnitOfWorkBase", Object.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

