/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.AsynchronousResponse;
import jp.ossc.nimbus.service.aop.interceptor.AsynchronousTimeoutException;
import jp.ossc.nimbus.service.aop.interceptor.MethodAsynchronousInterceptorServiceMBean;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;

public class MethodAsynchronousInterceptorService
extends ServiceBase
implements Interceptor,
MethodAsynchronousInterceptorServiceMBean {
    private static final long serialVersionUID = 556687756097723606L;
    private ServiceName requestQueueServiceName;
    private DefaultQueueService defaultRequestQueue;
    private Queue requestQueue;
    private ServiceName responseQueueServiceName;
    private Queue responseQueue;
    private Daemon[] daemons;
    private Invoker[] invokers;
    private long responseTimeout = -1L;
    private boolean isFailToWaitResponseTimeout = true;
    private int invokerThreadSize = 1;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    public void setRequestQueueServiceName(ServiceName name) {
        this.requestQueueServiceName = name;
    }

    public ServiceName getRequestQueueServiceName() {
        return this.requestQueueServiceName;
    }

    public void setResponseQueueServiceName(ServiceName name) {
        this.responseQueueServiceName = name;
    }

    public ServiceName getResponseQueueServiceName() {
        return this.responseQueueServiceName;
    }

    public void setResponseTimeout(long timeout) {
        this.responseTimeout = timeout;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setFailToWaitResponseTimeout(boolean isThrow) {
        this.isFailToWaitResponseTimeout = isThrow;
    }

    public boolean isFailToWaitResponseTimeout() {
        return this.isFailToWaitResponseTimeout;
    }

    public void setInvokerThreadSize(int size) {
        this.invokerThreadSize = size;
    }

    public int getInvokerThreadSize() {
        return this.invokerThreadSize;
    }

    public int getActiveInvokerThreadSize() {
        if (this.invokers == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.invokers.length; ++i) {
            if (!this.invokers[i].isActive) continue;
            ++count;
        }
        return count;
    }

    public void startService() throws Exception {
        if (this.getRequestQueueServiceName() == null) {
            if (this.getRequestQueueService() == null) {
                if (this.getDefaultRequestQueueService() == null) {
                    DefaultQueueService defaultQueue = new DefaultQueueService();
                    defaultQueue.create();
                    defaultQueue.start();
                    this.setDefaultRequestQueueService(defaultQueue);
                } else {
                    this.getDefaultRequestQueueService().start();
                }
                this.setRequestQueueService(this.getDefaultRequestQueueService());
            }
        } else {
            this.setRequestQueueService((Queue)ServiceManagerFactory.getServiceObject(this.requestQueueServiceName));
        }
        this.getRequestQueueService().accept();
        if (this.invokerThreadSize < 0) {
            throw new IllegalArgumentException("invokerThreadSize < 0.");
        }
        this.invokers = new Invoker[this.invokerThreadSize];
        this.daemons = new Daemon[this.invokerThreadSize];
        for (int i = 0; i < this.invokerThreadSize; ++i) {
            this.invokers[i] = new Invoker();
            this.daemons[i] = new Daemon(this.invokers[i]);
            this.daemons[i].setName("Nimbus AsynchInvokerDaemon " + this.getServiceNameObject());
            this.daemons[i].start();
        }
    }

    public void stopService() throws Exception {
        this.getRequestQueueService().release();
        for (int i = 0; i < this.daemons.length; ++i) {
            this.daemons[i].stop();
            this.daemons[i] = null;
            this.invokers[i] = null;
        }
        this.daemons = null;
        this.invokers = null;
        if (this.getRequestQueueService() == this.getDefaultRequestQueueService()) {
            this.getDefaultRequestQueueService().stop();
        }
    }

    public void destroyService() {
        if (this.getRequestQueueService() == this.getDefaultRequestQueueService() && this.getDefaultRequestQueueService() != null) {
            this.getDefaultRequestQueueService().destroy();
            this.setDefaultRequestQueueService(null);
        }
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            InterceptorChain ch = chain;
            if (chain instanceof DefaultThreadLocalInterceptorChain) {
                DefaultInterceptorChain tmp = new DefaultInterceptorChain(chain.getInterceptorChainList(), chain.getInvoker());
                tmp.setCurrentInterceptorIndex(chain.getCurrentInterceptorIndex());
                ch = tmp;
            }
            Queue resQueue = this.getResponseQueue();
            InvocationInfo invokeInfo = new InvocationInfo((MethodInvocationContext)context, ch, resQueue);
            this.getRequestQueueService().push(invokeInfo);
            if (resQueue != null) {
                AsynchronousResponse response = null;
                response = this.responseTimeout > 0L ? (AsynchronousResponse)resQueue.get(this.responseTimeout) : (AsynchronousResponse)resQueue.get();
                if (response == null) {
                    invokeInfo.isTimeout = true;
                    if (this.isFailToWaitResponseTimeout) {
                        throw new AsynchronousTimeoutException();
                    }
                } else {
                    if (response.isThrownException()) {
                        throw response.getThrownException();
                    }
                    return response.getReturnObject();
                }
            }
            return null;
        }
        return chain.invokeNext(context);
    }

    public void setRequestQueueService(Queue queue) {
        this.requestQueue = queue;
    }

    protected Queue getRequestQueueService() {
        return this.requestQueue;
    }

    protected DefaultQueueService getDefaultRequestQueueService() {
        return this.defaultRequestQueue;
    }

    protected void setDefaultRequestQueueService(DefaultQueueService queue) {
        this.defaultRequestQueue = queue;
    }

    public void setResponseQueue(Queue queue) {
        this.responseQueue = queue;
    }

    protected Queue getResponseQueue() {
        if (this.responseQueue != null) {
            return this.responseQueue;
        }
        if (this.getResponseQueueServiceName() != null) {
            return (Queue)ServiceManagerFactory.getServiceObject(this.getResponseQueueServiceName());
        }
        if (this.responseTimeout > 0L) {
            DefaultQueueService tmpQueue = new DefaultQueueService();
            try {
                tmpQueue.create();
                tmpQueue.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tmpQueue;
        }
        return null;
    }

    protected static class InvocationInfo
    implements Serializable {
        private static final long serialVersionUID = 7784186054966609415L;
        public MethodInvocationContext context;
        public InterceptorChain chain;
        public volatile boolean isTimeout;
        public Queue responseQueue;

        public InvocationInfo(MethodInvocationContext context, InterceptorChain chain, Queue resQueue) {
            this.context = context;
            this.chain = chain;
            this.responseQueue = resQueue;
        }
    }

    protected class Invoker
    implements DaemonRunnable {
        public boolean isActive;

        protected Invoker() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) {
            return MethodAsynchronousInterceptorService.this.getRequestQueueService().get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(Object dequeued, DaemonControl ctrl) {
            if (dequeued == null) {
                return;
            }
            try {
                this.isActive = true;
                InvocationInfo info = (InvocationInfo)dequeued;
                boolean throwException = false;
                Object ret = null;
                try {
                    ret = info.chain.invokeNext(info.context);
                }
                catch (Throwable e) {
                    ret = e;
                    throwException = true;
                }
                Queue resQueue = info.responseQueue;
                if (resQueue != null) {
                    AsynchronousResponse response = null;
                    if (throwException) {
                        Class<?>[] exceptionTypes = info.context.getTargetMethod().getExceptionTypes();
                        boolean isThrowable = false;
                        if ((class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = MethodAsynchronousInterceptorService.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).isInstance(ret) || (class$java$lang$Error == null ? (class$java$lang$Error = MethodAsynchronousInterceptorService.class$("java.lang.Error")) : class$java$lang$Error).isInstance(ret)) {
                            isThrowable = true;
                        } else {
                            for (int i = 0; i < exceptionTypes.length; ++i) {
                                if (!exceptionTypes[i].isInstance(ret)) continue;
                                isThrowable = true;
                                break;
                            }
                        }
                        if (isThrowable) {
                            response = new AsynchronousResponse(ret, true);
                        }
                    } else {
                        response = new AsynchronousResponse(ret);
                    }
                    if (!info.isTimeout && response != null) {
                        resQueue.push(response);
                    }
                }
            }
            finally {
                this.isActive = false;
            }
        }

        public void garbage() {
            if (MethodAsynchronousInterceptorService.this.getRequestQueueService() != null) {
                while (MethodAsynchronousInterceptorService.this.getRequestQueueService().size() > 0) {
                    this.consume(MethodAsynchronousInterceptorService.this.getRequestQueueService().get(0L), null);
                }
            }
        }
    }
}

