/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.ioc.FacadeValueAccess;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.codemaster.CodeMasterServiceMBean;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.codemaster.PartUpdateRecords;
import jp.ossc.nimbus.service.ioccall.FacadeCaller;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.sequence.Sequence;

public class CodeMasterService
extends ServiceBase
implements CodeMasterServiceMBean,
CodeMasterFinder,
MessageListener {
    private static final long serialVersionUID = -4013884085932487905L;
    public static final String UPDATE_TIME_KEY = "$updateTime";
    private static final String C_REQUEST_ID = "REQUEST_ID";
    private static final String C_USER_ID = "USER_ID";
    private static final String FIND_DATE_KEY = "date";
    private static final String MASTER_DATA_KEY = "data";
    private ServiceName facadeCallerServiceName;
    private FacadeCaller facadeCaller;
    private ServiceName beanFlowInvokerFactoryServiceName;
    private BeanFlowInvokerFactory beanFlowInvokerFactory;
    private String[] masterNames;
    private String[] startMasterNames;
    private String[] notStartMasterNames;
    private Map startMasterInputMap;
    private ServiceName jmsTopicSubscriberFactoryServiceName;
    private JMSMessageConsumerFactory jmsTopicSubscriberFactory;
    private ServiceName[] jmsTopicSubscriberFactoryServiceNames;
    private JMSMessageConsumerFactory[] jmsTopicSubscriberFactories;
    private Set stateListeners;
    protected HashMap master;
    private ServiceName sequenceServiceName;
    private Sequence sequence;
    private String userId;
    private Set masterNameSet;

    public void setMasterNames(String[] names) {
        this.masterNames = names;
    }

    public String[] getMasterNames() {
        return this.masterNames;
    }

    public ServiceName getFacadeCallerServiceName() {
        return this.facadeCallerServiceName;
    }

    public void setFacadeCallerServiceName(ServiceName name) {
        this.facadeCallerServiceName = name;
    }

    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setJMSTopicSubscriberFactoryServiceName(ServiceName name) {
        this.jmsTopicSubscriberFactoryServiceName = name;
    }

    public ServiceName getJMSTopicSubscriberFactoryServiceName() {
        return this.jmsTopicSubscriberFactoryServiceName;
    }

    public void setJMSTopicSubscriberFactoryServiceNames(ServiceName[] names) {
        this.jmsTopicSubscriberFactoryServiceNames = names;
    }

    public ServiceName[] getJMSTopicSubscriberFactoryServiceNames() {
        return this.jmsTopicSubscriberFactoryServiceNames;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String id) {
        this.userId = id;
    }

    public void setStartMasterNames(String[] names) {
        this.startMasterNames = names;
    }

    public String[] getStartMasterNames() {
        return this.startMasterNames;
    }

    public void setNotStartMasterNames(String[] names) {
        this.notStartMasterNames = names;
    }

    public String[] getNotStartMasterNames() {
        return this.notStartMasterNames;
    }

    public void setStartMasterInputMap(Map map) {
        this.startMasterInputMap = map;
    }

    public Map getStartMasterInputMap() {
        if (this.startMasterInputMap == null) {
            this.startMasterInputMap = new LinkedHashMap();
        }
        return this.startMasterInputMap;
    }

    public void setFacadeCaller(FacadeCaller caller) {
        this.facadeCaller = caller;
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setJMSMessageConsumerFactory(JMSMessageConsumerFactory factory) {
        this.jmsTopicSubscriberFactory = factory;
    }

    public void setJMSMessageConsumerFactories(JMSMessageConsumerFactory[] factories) {
        this.jmsTopicSubscriberFactories = factories;
    }

    public void createService() throws Exception {
        this.master = new HashMap();
        this.masterNameSet = new HashSet();
        this.stateListeners = new HashSet();
    }

    public void startService() throws Exception {
        int i;
        if (this.facadeCallerServiceName != null) {
            this.facadeCaller = (FacadeCaller)ServiceManagerFactory.getServiceObject(this.facadeCallerServiceName);
        } else if (this.facadeCaller == null) {
            if (this.beanFlowInvokerFactoryServiceName != null) {
                this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
            } else if (this.beanFlowInvokerFactory == null) {
                throw new IllegalArgumentException("It is necessary to set FacadeCallerServiceName or FacadeCaller and to set BeanFlowInvokerFactoryServiceName or BeanFlowInvokerFactory.");
            }
        }
        if (this.jmsTopicSubscriberFactoryServiceName != null) {
            this.jmsTopicSubscriberFactory = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsTopicSubscriberFactoryServiceName);
        }
        if (this.jmsTopicSubscriberFactoryServiceNames != null && this.jmsTopicSubscriberFactoryServiceNames.length != 0) {
            this.jmsTopicSubscriberFactories = new JMSMessageConsumerFactory[this.jmsTopicSubscriberFactoryServiceNames.length];
            for (i = 0; i < this.jmsTopicSubscriberFactoryServiceNames.length; ++i) {
                this.jmsTopicSubscriberFactories[i] = (JMSMessageConsumerFactory)ServiceManagerFactory.getServiceObject(this.jmsTopicSubscriberFactoryServiceNames[i]);
            }
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)((Object)ServiceManagerFactory.getService(this.sequenceServiceName));
        }
        this.initMasterHash();
        this.entryTopicListener(this.jmsTopicSubscriberFactory, this.jmsTopicSubscriberFactoryServiceName, null);
        if (this.jmsTopicSubscriberFactories != null && this.jmsTopicSubscriberFactories.length != 0) {
            for (i = 0; i < this.jmsTopicSubscriberFactories.length; ++i) {
                this.entryTopicListener(this.jmsTopicSubscriberFactories[i], this.jmsTopicSubscriberFactoryServiceNames == null || this.jmsTopicSubscriberFactoryServiceNames.length == 0 ? null : this.jmsTopicSubscriberFactoryServiceNames[i], null);
            }
        }
    }

    public void stopService() throws Exception {
        if (this.master != null) {
            this.master.clear();
        }
        if (this.masterNameSet != null) {
            this.masterNameSet.clear();
        }
        if (this.stateListeners != null) {
            Iterator listeners = this.stateListeners.iterator();
            while (listeners.hasNext()) {
                JMSMessageConsumerFactoryStateListener listener = (JMSMessageConsumerFactoryStateListener)listeners.next();
                try {
                    listener.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                listeners.remove();
            }
        }
    }

    public void destroyService() {
        this.master = null;
        this.masterNameSet = null;
        this.stateListeners = null;
    }

    private void entryTopicListener(JMSMessageConsumerFactory subscriberFactory, ServiceName factoryName, JMSMessageConsumerFactoryStateListener listener) throws Exception {
        Service service;
        if (subscriberFactory == null) {
            return;
        }
        ServiceName name = factoryName;
        if (name == null && this.jmsTopicSubscriberFactory instanceof Service) {
            name = new ServiceName(((Service)((Object)subscriberFactory)).getServiceManagerName(), ((Service)((Object)subscriberFactory)).getServiceName());
        }
        if (name != null && (service = ServiceManagerFactory.getService(name)).getState() != 3) {
            return;
        }
        TopicSubscriber subscriber = (TopicSubscriber)subscriberFactory.createConsumer();
        subscriber.setMessageListener((MessageListener)this);
        Connection con = subscriberFactory.getSessionFactory().getConnection();
        if (con == null) {
            con = subscriberFactory.getSessionFactory().getConnectionFactory().getConnection();
        }
        con.start();
        JMSMessageConsumerFactoryStateListener stateListener = listener;
        if (stateListener == null) {
            stateListener = new JMSMessageConsumerFactoryStateListener(subscriberFactory, factoryName, subscriber);
        }
        this.stateListeners.add(stateListener);
        ServiceManagerFactory.addServiceStateListener(name, (ServiceStateListener)stateListener);
    }

    private void initMasterHash() throws Exception {
        this.master.clear();
        this.masterNameSet.clear();
        if (this.masterNames == null) {
            return;
        }
        LinkedHashMap<String, Object> keyInputMap = new LinkedHashMap<String, Object>();
        List<String> startMasterNameSet = Arrays.asList(this.startMasterNames == null ? this.masterNames : this.startMasterNames);
        List<String> notStartMasterNameSet = Arrays.asList(this.notStartMasterNames == null ? new String[]{} : this.notStartMasterNames);
        for (int i = 0; i < this.masterNames.length; ++i) {
            this.masterNameSet.add(this.masterNames[i]);
            if (!startMasterNameSet.contains(this.masterNames[i]) || notStartMasterNameSet.contains(this.masterNames[i])) continue;
            Object input = null;
            if (this.startMasterInputMap != null) {
                input = this.startMasterInputMap.get(this.masterNames[i]);
            }
            keyInputMap.put(this.masterNames[i], input);
        }
        Map keyMasterMap = this.createNewMasters(keyInputMap);
        Iterator keyMasterEntries = keyMasterMap.entrySet().iterator();
        Date updateTime = new Date();
        while (keyMasterEntries.hasNext()) {
            Map.Entry entry = keyMasterEntries.next();
            String key = (String)entry.getKey();
            Object newMaster = entry.getValue();
            TimeManageMaster tm = (TimeManageMaster)this.master.get(key);
            if (tm == null) {
                tm = new TimeManageMaster();
                tm.setMasterName(key);
                this.master.put(key, tm);
            }
            this.updateNewMaster(key, newMaster, updateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCodeMasters() throws ServiceException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date nowDate = new Date();
        Set keys = this.master.keySet();
        Iterator ite = keys.iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            TimeManageMaster tmp = null;
            HashMap hashMap = this.master;
            synchronized (hashMap) {
                tmp = (TimeManageMaster)this.master.get(key);
            }
            Object mst = tmp.getMaster(nowDate);
            map.put(key, mst);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onMessage(Message msg) {
        if (!(msg instanceof MapMessage)) {
            this.getLogger().write("CMS__00003", msg.getClass());
            return;
        }
        mapMsg = (MapMessage)msg;
        try {
            keyInputMap = new LinkedHashMap<String, Object>();
            en = mapMsg.getMapNames();
            while (en.hasMoreElements()) {
                block20: {
                    key = (String)en.nextElement();
                    if (!this.masterNameSet.contains(key)) continue;
                    input = mapMsg.getObject(key);
                    if (input != null && input instanceof byte[]) {
                        bais = new ByteArrayInputStream((byte[])input);
                        ois = new ObjectInputStream(bais);
                        try {
                            input = ois.readObject();
                            var11_12 = null;
                            ** if (ois == null) goto lbl-1000
                        }
                        catch (Throwable var10_17) {
                            var11_12 = null;
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                            throw var10_17;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                ois.close();
                            }
                            catch (IOException e) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block20;
                            catch (Exception e) {
                                var11_12 = null;
                                if (ois != null) {
                                    try {
                                        ois.close();
                                    }
                                    catch (IOException e) {}
                                }
                            }
                        }
                    }
                }
                keyInputMap.put(key, input);
            }
            if (keyInputMap.size() == 0) {
                return;
            }
            keyMasterMap = this.createNewMasters(keyInputMap);
            keyMasterEntries = keyMasterMap.entrySet().iterator();
            while (keyMasterEntries.hasNext()) {
                entry = keyMasterEntries.next();
                key = (String)entry.getKey();
                newMaster = entry.getValue();
                updateTime = null;
                try {
                    utc = mapMsg.getLong(key + "$updateTime");
                    updateTime = new Date(utc);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.updateNewMaster(key, newMaster, updateTime);
            }
        }
        catch (Exception e) {
            this.getLogger().write("CMS__00004", e);
            return;
        }
    }

    public void updateCodeMaster(String key) throws Exception {
        this.updateCodeMaster(key, null);
    }

    public void updateCodeMaster(String key, Date updateTime) throws Exception {
        this.updateCodeMaster(key, null, updateTime);
    }

    public void updateCodeMaster(String key, Object input, Date updateTime) throws Exception {
        if (!this.masterNameSet.contains(key)) {
            return;
        }
        this.updateNewMaster(key, this.createNewMaster(key, input), updateTime);
    }

    protected Map createNewMasters(Map keyInputMap) throws Exception {
        if (this.facadeCaller != null) {
            return this.callIOC(keyInputMap);
        }
        if (this.beanFlowInvokerFactory != null) {
            return this.callBeanFlow(keyInputMap);
        }
        throw new IllegalStateException("FacadeCaller and BeanFlowInvokerFactory is null.");
    }

    protected Map callBeanFlow(Map keyInputMap) throws Exception {
        LinkedHashMap result = new LinkedHashMap();
        Iterator entries = keyInputMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            result.put(entry.getKey(), this.callBeanFlow((String)entry.getKey(), entry.getValue()));
        }
        return result;
    }

    protected Map callIOC(Map keyInputMap) throws Exception {
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        Iterator entries = keyInputMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Command cmd = FacadeValueAccess.createCommand((String)entry.getKey(), entry.getValue());
            value.addCommand(cmd);
        }
        if (this.userId != null) {
            value.putHeader(C_USER_ID, this.userId);
        }
        if (this.sequence != null) {
            value.putHeader(C_REQUEST_ID, this.sequence.increment());
        }
        FacadeValue ret = this.facadeCaller.syncFacadeCall(value);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int status = ret.getStatus();
        switch (status) {
            case 0: {
                int imax = ret.commandSize();
                for (int i = 0; i < imax; ++i) {
                    Command cmd = (Command)ret.getCommand(i);
                    result.put(cmd.getFlowKey(), cmd.getOutputObject());
                }
                break;
            }
            default: {
                if (ret.getExceptionCount() <= 0) break;
                Throwable[] th = ret.getExceptions();
                if (th[0] instanceof Exception) {
                    throw (Exception)th[0];
                }
                throw (Error)th[0];
            }
        }
        return result;
    }

    protected Object createNewMaster(String key, Object input) throws Exception {
        if (this.facadeCaller != null) {
            return this.callIOC(key, input);
        }
        if (this.beanFlowInvokerFactory != null) {
            return this.callBeanFlow(key, input);
        }
        throw new IllegalStateException("FacadeCaller and BeanFlowInvokerFactory is null.");
    }

    protected Object callBeanFlow(String key, Object input) throws Exception {
        BeanFlowInvoker invoker = this.beanFlowInvokerFactory.createFlow(key);
        return invoker.invokeFlow(input);
    }

    protected Object callIOC(String key, Object input) throws Exception {
        FacadeValue value = FacadeValueAccess.createCommandsValue();
        value.addCommand(FacadeValueAccess.createCommand(key, input));
        if (this.userId != null) {
            value.putHeader(C_USER_ID, this.userId);
        }
        if (this.sequence != null) {
            value.putHeader(C_REQUEST_ID, this.sequence.increment());
        }
        FacadeValue ret = this.facadeCaller.syncFacadeCall(value);
        Command cmd = (Command)ret.getCommand(0);
        int status = cmd.getStatus();
        switch (status) {
            case 0: {
                return cmd.getOutputObject();
            }
        }
        if (cmd.getExceptionCount() > 0) {
            Throwable[] th = cmd.getExceptions();
            if (th[0] instanceof Exception) {
                throw (Exception)th[0];
            }
            throw (Error)th[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNewMaster(String key, Object mst, Date updateTime) throws Exception {
        if (mst == null) {
            this.getLogger().write("CMS__00001", new Object[]{key, null});
            return;
        }
        TimeManageMaster tm = (TimeManageMaster)this.master.get(key);
        Date effectDt = updateTime;
        if (effectDt == null) {
            effectDt = new Date();
        }
        Object newMst = mst;
        if (tm != null && mst instanceof PartUpdateRecords) {
            PartUpdate pu = (PartUpdate)tm.getMaster(effectDt);
            if (pu == null) {
                this.getLogger().write("CMS__00005", (Object)key);
                return;
            }
            PartUpdate newPu = pu.cloneAndUpdate((PartUpdateRecords)mst);
            newMst = newPu;
        }
        TimeManageMaster newTm = null;
        if (tm == null) {
            newTm = new TimeManageMaster();
            newTm.setMasterName(key);
        } else {
            newTm = tm.cloneOwn();
        }
        newTm.addMaster(effectDt, newMst);
        newTm.clear();
        HashMap hashMap = this.master;
        synchronized (hashMap) {
            this.master.put(key, newTm);
        }
        this.getLogger().write("CMS__00001", new Object[]{key, effectDt});
    }

    private class JMSMessageConsumerFactoryStateListener
    implements ServiceStateListener {
        private JMSMessageConsumerFactory subscriberFactory;
        private TopicSubscriber subscriber;
        private ServiceName factoryName;

        public JMSMessageConsumerFactoryStateListener(JMSMessageConsumerFactory subscriberFactory, ServiceName factoryName, TopicSubscriber subscriber) {
            this.subscriberFactory = subscriberFactory;
            this.factoryName = factoryName;
            this.subscriber = subscriber;
        }

        public void stateChanged(ServiceStateChangeEvent e) throws Exception {
            Service service = e.getService();
            int state = service.getState();
            ServiceName name = new ServiceName(service.getServiceManagerName(), service.getServiceName());
            if (!name.equals(this.factoryName)) {
                return;
            }
            switch (state) {
                case 3: {
                    CodeMasterService.this.entryTopicListener(this.subscriberFactory, this.factoryName, this);
                    break;
                }
            }
        }

        public boolean isEnabledState(int state) {
            return state == 3;
        }

        public void close() throws Exception {
            if (this.factoryName != null) {
                ServiceManagerFactory.removeServiceStateListener(this.factoryName, (ServiceStateListener)this);
            }
            this.subscriber.close();
        }
    }

    private class TimeManageMaster {
        private String mFlowKey = null;
        private ArrayList mTimeList = new ArrayList();

        public void setMasterName(String name) {
            this.mFlowKey = name;
        }

        public String getMasterName() {
            return this.mFlowKey;
        }

        public void addMaster(Date time, Object master) {
            HashMap<String, Object> rec = new HashMap<String, Object>();
            rec.put(CodeMasterService.MASTER_DATA_KEY, master);
            rec.put(CodeMasterService.FIND_DATE_KEY, time);
            boolean instFlg = false;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                if (cnt == this.mTimeList.size() - 1) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(cnt + 1, rec);
                }
                instFlg = true;
                break;
            }
            if (!instFlg) {
                if (this.mTimeList.size() == 0) {
                    this.mTimeList.add(rec);
                } else {
                    this.mTimeList.add(0, rec);
                }
            }
        }

        public Object getMaster(Date time) {
            Object ret = null;
            for (int cnt = this.mTimeList.size() - 1; cnt > -1; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(time)) continue;
                ret = map.get(CodeMasterService.MASTER_DATA_KEY);
                break;
            }
            return ret;
        }

        public void clear() {
            Date now = new Date();
            for (int cnt = this.mTimeList.size() - 1; cnt >= 0; --cnt) {
                Map map = (Map)this.mTimeList.get(cnt);
                Date tmpTime = (Date)map.get(CodeMasterService.FIND_DATE_KEY);
                if (!tmpTime.before(now) || cnt <= 0) continue;
                for (int rcnt = cnt - 1; rcnt >= 0; --rcnt) {
                    this.mTimeList.remove(rcnt);
                }
                break;
            }
        }

        public TimeManageMaster cloneOwn() {
            TimeManageMaster ret = new TimeManageMaster();
            ret.setMasterName(this.getMasterName());
            for (int cnt = 0; cnt < this.mTimeList.size(); ++cnt) {
                ret.mTimeList.add(this.mTimeList.get(cnt));
            }
            return ret;
        }
    }
}

