/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.StringArrayEditor;
import jp.ossc.nimbus.core.GenericsServiceProxy;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;

public class ServiceManagerFactoryServlet
extends HttpServlet {
    protected static final String SERVICE_PATHS = "ServicePaths";
    protected static final String CHECK_LOAD_MNG_CMP = "CheckLoadManagerCompleted";
    protected static final String CHECK_LOAD_MNG_CMP_BY = "CheckLoadManagerCompletedBy";
    protected static final String VALIDATE = "Validate";
    protected static final String CONSOLE_ENABLED = "ConsoleEnabled";
    protected static final String ATTR_SET_ENABLED = "AttributeSetEnabled";
    protected static final String METHOD_CALL_ENABLED = "MethodCallEnabled";
    private static final String ATTRIBUTE_READ_ONLY = "r";
    private static final String ATTRIBUTE_WRITE_ONLY = "w";
    private static final String ATTRIBUTE_READ_AND_WRITE = "rw";
    static /* synthetic */ Class class$java$lang$Object;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        String[] servicePaths = this.getServicePaths();
        boolean isValidate = this.isValidate();
        if (servicePaths != null && servicePaths.length != 0) {
            for (int i = 0; i < servicePaths.length; ++i) {
                ServiceManagerFactory.loadManager(servicePaths[i], true, isValidate);
            }
        }
        if (this.isCheckLoadManagerCompleted()) {
            String[] managerNames = this.getCheckLoadManagerCompletedBy();
            if (managerNames == null || managerNames.length == 0) {
                ServiceManagerFactory.checkLoadManagerCompleted();
            } else {
                for (int i = 0; i < managerNames.length; ++i) {
                    ServiceManagerFactory.checkLoadManagerCompletedBy(managerNames[i]);
                }
            }
        }
    }

    private boolean isConsoleEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(CONSOLE_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isAttributeSetEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(ATTR_SET_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private boolean isMethodCallEnabled() {
        ServletConfig config = this.getServletConfig();
        String isEnabled = config.getInitParameter(METHOD_CALL_ENABLED);
        return isEnabled == null ? false : Boolean.valueOf(isEnabled);
    }

    private String getServicePath(String path) {
        ServletContext context = this.getServletConfig().getServletContext();
        String result = context.getRealPath(path);
        if (result == null) {
            result = path;
        }
        return result;
    }

    private String[] getServicePaths() {
        ServletConfig config = this.getServletConfig();
        String servicePathString = config.getInitParameter(SERVICE_PATHS);
        if (servicePathString == null) {
            return null;
        }
        StringArrayEditor editor = new StringArrayEditor();
        editor.setAsText(servicePathString);
        String[] servicePaths = (String[])editor.getValue();
        for (int i = 0; i < servicePaths.length; ++i) {
            servicePaths[i] = this.getServicePath(servicePaths[i]);
        }
        return servicePaths;
    }

    private boolean isCheckLoadManagerCompleted() {
        ServletConfig config = this.getServletConfig();
        String isCheck = config.getInitParameter(CHECK_LOAD_MNG_CMP);
        return isCheck == null ? false : Boolean.valueOf(isCheck);
    }

    private boolean isValidate() {
        ServletConfig config = this.getServletConfig();
        String isValidate = config.getInitParameter(VALIDATE);
        return isValidate == null ? false : Boolean.valueOf(isValidate);
    }

    private String[] getCheckLoadManagerCompletedBy() {
        ServletConfig config = this.getServletConfig();
        String managerNames = config.getInitParameter(CHECK_LOAD_MNG_CMP_BY);
        StringArrayEditor editor = new StringArrayEditor();
        editor.setAsText(managerNames);
        return (String[])editor.getValue();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isConsoleEnabled()) {
            resp.sendError(406);
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            this.processIndexResponse(req, resp);
        } else if (action.equals("manager")) {
            this.processManagerResponse(req, resp);
        } else if (action.equals("service")) {
            this.processServiceResponse(req, resp);
        } else if (action.equals("set")) {
            if (!this.isAttributeSetEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processSetAttributeResponse(req, resp);
        } else if (action.equals("call")) {
            if (!this.isMethodCallEnabled()) {
                resp.sendError(406);
                return;
            }
            this.processCallAttributeResponse(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    protected void processIndexResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int i;
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><title>Nimbus ServiceManagerFactory</title></head>");
        buf.append("<body>");
        buf.append("<b>Service definition paths</b><br>");
        buf.append("<ul>");
        Collection loaderSet = ServiceManagerFactory.getLoaders();
        Object[] serviceURLs = new String[loaderSet.size()];
        Iterator loaders = loaderSet.iterator();
        int count = 0;
        while (loaders.hasNext()) {
            ServiceLoader loader = (ServiceLoader)loaders.next();
            serviceURLs[count++] = loader.getServiceURL().toString();
        }
        Arrays.sort(serviceURLs);
        for (int i2 = 0; i2 < serviceURLs.length; ++i2) {
            Object fileName = serviceURLs[i2];
            int index = ((String)fileName).lastIndexOf(47);
            if (index != -1) {
                fileName = ((String)fileName).substring(index + 1);
            }
            buf.append("<li>").append("<a href=\"").append((String)serviceURLs[i2]).append("\">").append((String)fileName).append("</a>").append("</li>");
        }
        buf.append("</ul>");
        buf.append("<p>");
        buf.append("<b>Service managers</b><br>");
        buf.append("<ul>");
        ServiceManager[] managers = ServiceManagerFactory.findManagers();
        Object[] managerNames = new String[managers.length];
        for (i = 0; i < managers.length; ++i) {
            managerNames[i] = managers[i].getServiceName();
        }
        Arrays.sort(managerNames);
        for (i = 0; i < managerNames.length; ++i) {
            buf.append("<li>");
            buf.append("<a href=\"").append(req.getRequestURI()).append("?action=manager&name=").append((String)managerNames[i]).append("\">");
            buf.append((String)managerNames[i]).append("</a>");
            buf.append("</li>");
        }
        buf.append("</ul>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processManagerResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String managerName = req.getParameter("name");
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><title>Nimbus ServiceManager ").append(managerName).append("</title></head>");
        buf.append("<body>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("<hr>");
        buf.append("<b>ServiceManager name : </b>").append(managerName);
        buf.append("<p>");
        buf.append("<b>Service definition paths : </b>");
        buf.append("<ul>");
        Set loaderSet = manager.getServiceLoaders();
        Object[] serviceURLs = new String[loaderSet.size()];
        Iterator loaders = loaderSet.iterator();
        int count = 0;
        while (loaders.hasNext()) {
            ServiceLoader loader = (ServiceLoader)loaders.next();
            serviceURLs[count++] = loader.getServiceURL().toString();
        }
        Arrays.sort(serviceURLs);
        for (int i = 0; i < serviceURLs.length; ++i) {
            Object fileName = serviceURLs[i];
            int index = ((String)fileName).lastIndexOf(47);
            if (index != -1) {
                fileName = ((String)fileName).substring(index + 1);
            }
            buf.append("<li>").append("<a href=\"").append((String)serviceURLs[i]).append("\">").append((String)fileName).append("</a>").append("</li>");
        }
        buf.append("</ul>");
        buf.append("<p>");
        buf.append("<b>Services</b><br>");
        buf.append("<ul>");
        Set serviceNameSet = manager.serviceNameSet();
        Object[] serviceNames = new ServiceName[serviceNameSet.size()];
        Iterator nameItr = manager.serviceNameSet().iterator();
        count = 0;
        while (nameItr.hasNext()) {
            String serviceNameStr = (String)nameItr.next();
            serviceNames[count++] = new ServiceName(managerName, serviceNameStr);
        }
        Arrays.sort(serviceNames);
        for (int i = 0; i < serviceNames.length; ++i) {
            Object serviceName = serviceNames[i];
            buf.append("<li>");
            buf.append("<a href=\"").append(req.getRequestURI()).append("?action=service&name=").append(URLEncoder.encode(((ServiceName)serviceName).toString(), "UTF-8")).append("\">");
            buf.append(serviceName).append('(').append(this.getTargetObject(ServiceManagerFactory.getService((ServiceName)serviceName)).getClass().getName()).append(')').append("</a>");
            buf.append("</li>");
        }
        buf.append("</ul>");
        buf.append("<hr>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    private Object getTargetObject(Service service) {
        Object targetObj = service;
        if (service instanceof GenericsServiceProxy) {
            targetObj = ServiceManagerFactory.getServiceObject(service.getServiceManagerName(), service.getServiceName());
        }
        return targetObj;
    }

    protected void processServiceResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        Service service = ServiceManagerFactory.getService(serviceName);
        Class<?> targetClass = this.getTargetObject(service).getClass();
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><title>Nimbus Service ").append(serviceNameStr).append("</title></head>");
        buf.append("<body>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=manager&name=").append(serviceName.getServiceManagerName()).append("\">ServiceManager</a>");
        buf.append("<hr>");
        buf.append("<b>Service name : </b>").append(serviceNameStr);
        buf.append("<p>");
        buf.append("<b>Service class : </b>").append(targetClass);
        buf.append("<p>");
        Method[] methods = targetClass.getMethods();
        Map attributeMap = this.getAttributes(methods);
        Object[] attributeNames = attributeMap.keySet().toArray(new String[attributeMap.size()]);
        Arrays.sort(attributeNames);
        buf.append("<b>Attributes</b><br>");
        buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
        buf.append("<tr bgcolor=\"#cccccc\"><th>name</th><th>r/w</th><th>type</th><th>value</th><th>apply</th></tr>");
        for (int i = 0; i < attributeNames.length; ++i) {
            String attrValue;
            Object attributeName = attributeNames[i];
            AttributeMethod attrMethod = (AttributeMethod)attributeMap.get(attributeName);
            String attrType = this.getAttributeType(attrMethod);
            buf.append("<form name=\"").append((String)attributeName).append("\" action=\"").append(req.getRequestURI()).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"set\">");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\">");
            if (attrType.equals(ATTRIBUTE_READ_AND_WRITE) || attrType.equals(ATTRIBUTE_WRITE_ONLY)) {
                MethodSignature signature = new MethodSignature(attrMethod.getSetter());
                buf.append("<input type=\"hidden\" name=\"method\" value=\"").append(signature).append("\">");
            }
            buf.append("<tr>");
            buf.append("<td>").append((String)attributeName).append("</td>");
            buf.append("<td>").append(attrType).append("</td>");
            buf.append("<td>").append(attrMethod.getType().getName()).append("</td>");
            buf.append("<td>");
            if (attrType.equals(ATTRIBUTE_READ_AND_WRITE)) {
                attrValue = this.getAttributeValue(service, attrMethod);
                buf.append("<textarea name=\"attributeValue\" cols=\"40\" rows=\"2\">").append(attrValue).append("</textarea>");
            } else if (attrType.equals(ATTRIBUTE_WRITE_ONLY)) {
                buf.append("<textarea name=\"attributeValue\" cols=\"40\" rows=\"2\">").append("</textarea>");
            } else {
                attrValue = this.getAttributeValue(service, attrMethod);
                buf.append("<textarea name=\"attributeValue\" readonly cols=\"40\" rows=\"2\">").append(attrValue).append("</textarea>");
            }
            buf.append("</td>");
            buf.append("<td>");
            if (attrType.equals(ATTRIBUTE_READ_AND_WRITE) || attrType.equals(ATTRIBUTE_WRITE_ONLY)) {
                buf.append("<input type=\"submit\" value=\"apply\">");
            } else {
                buf.append("\u3000");
            }
            buf.append("</td>");
            buf.append("</tr>");
            buf.append("</form>");
        }
        buf.append("</table>");
        buf.append("<p>");
        buf.append("<b>Methods</b><br>");
        buf.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\" width=\"90%\">");
        buf.append("<tr bgcolor=\"#cccccc\"><th rowspan=\"2\">method</th><th colspan=\"2\">arguments</th><th rowspan=\"2\">call</th></tr>");
        buf.append("<tr bgcolor=\"#cccccc\"><th>value</th><th>type</th></tr>");
        HashMap<MethodSignature, Method> methodMap = new HashMap<MethodSignature, Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (this.isAttributeMethod(methods[i])) continue;
            methodMap.put(new MethodSignature(methods[i]), methods[i]);
        }
        Object[] sigs = methodMap.keySet().toArray(new MethodSignature[methodMap.size()]);
        Arrays.sort(sigs);
        for (int i = 0; i < sigs.length; ++i) {
            int j;
            int max;
            buf.append("<form name=\"").append(sigs[i]).append("\" action=\"").append(req.getRequestURI()).append("\">");
            buf.append("<input type=\"hidden\" name=\"action\" value=\"call\">");
            buf.append("<input type=\"hidden\" name=\"name\" value=\"").append(serviceNameStr).append("\">");
            buf.append("<input type=\"hidden\" name=\"method\" value=\"").append(sigs[i]).append("\">");
            buf.append("<tr>");
            buf.append("<td>").append(sigs[i]).append("</td>");
            buf.append("<td>");
            Class<?>[] paramTypes = ((Method)methodMap.get(sigs[i])).getParameterTypes();
            if (paramTypes.length == 0) {
                buf.append("\u3000");
            } else {
                max = paramTypes.length;
                for (j = 0; j < max; ++j) {
                    buf.append("<textarea name=\"args\" cols=\"40\" rows=\"2\"></textarea>");
                    if (j == max - 1) continue;
                    buf.append("<br>");
                }
            }
            buf.append("</td>");
            buf.append("<td>");
            if (paramTypes.length == 0) {
                buf.append("\u3000");
            } else {
                max = paramTypes.length;
                for (j = 0; j < max; ++j) {
                    buf.append("<input type=\"text\" name=\"argTypes\">");
                    if (j == max - 1) continue;
                    buf.append("<br>");
                }
            }
            buf.append("</td>");
            buf.append("<td>").append("<input type=\"submit\" value=\"call\">").append("</td>");
            buf.append("</tr>");
            buf.append("</form>");
        }
        buf.append("</table>");
        buf.append("<hr>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=manager&name=").append(serviceName.getServiceManagerName()).append("\">ServiceManager</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processSetAttributeResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        Service service = ServiceManagerFactory.getService(serviceName);
        String method = req.getParameter("method");
        String attributeValueStr = req.getParameter("attributeValue");
        String result = this.setAttributeValue(service, method, attributeValueStr);
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><title>Nimbus Set Attribute</title></head>");
        buf.append("<body>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=manager&name=").append(serviceName.getServiceManagerName()).append("\">ServiceManager</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Service</a>");
        buf.append("<hr>");
        buf.append("<pre>").append(result).append("</pre>");
        buf.append("<hr>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=manager&name=").append(serviceName.getServiceManagerName()).append("\">ServiceManager</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Service</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    protected void processCallAttributeResponse(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serviceNameStr = req.getParameter("name");
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        ServiceName serviceName = (ServiceName)editor.getValue();
        Service service = ServiceManagerFactory.getService(serviceName);
        String method = req.getParameter("method");
        String[] args = req.getParameterValues("args");
        String[] argTypes = req.getParameterValues("argTypes");
        String result = this.callMethod(service, method, args, argTypes);
        resp.setContentType("text/html;charset=UTF-8");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><title>Nimbus Call Method</title></head>");
        buf.append("<body>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=manager&name=").append(serviceName.getServiceManagerName()).append("\">ServiceManager</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Service</a>");
        buf.append("<hr>");
        buf.append("<pre>").append(result).append("</pre>");
        buf.append("<hr>");
        buf.append("<a href=\"").append(req.getRequestURI()).append("\">ServiceManagerFactory</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=manager&name=").append(serviceName.getServiceManagerName()).append("\">ServiceManager</a>");
        buf.append("/");
        buf.append("<a href=\"").append(req.getRequestURI()).append("?action=service&name=").append(URLEncoder.encode(serviceNameStr, "UTF-8")).append("\">Service</a>");
        buf.append("</body>");
        buf.append("</html>");
        resp.getWriter().println(buf.toString());
    }

    private String callMethod(Service service, String methodStr, String[] argsStr, String[] argTypesStr) {
        Object targetObj = this.getTargetObject(service);
        Class<?> targetClass = targetObj.getClass();
        StringWriter result = new StringWriter();
        PrintWriter writer = new PrintWriter(result);
        try {
            PropertyEditor editor;
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            MethodSignature signature = new MethodSignature(methodStr);
            Method method = signature.getMethod(targetObj);
            Class<?>[] paramTypes = method.getParameterTypes();
            Object[] params = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> editType = paramTypes[i];
                if (argTypesStr[i] != null && argTypesStr[i].length() != 0) {
                    try {
                        editType = Class.forName(argTypesStr[i], true, loader);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (argsStr[i] == null || argsStr[i].equals("null")) {
                    params[i] = null;
                    continue;
                }
                editor = this.findEditor(service, editType);
                if (editor == null) {
                    if (paramTypes[i].equals(class$java$lang$Object == null ? ServiceManagerFactoryServlet.class$("java.lang.Object") : class$java$lang$Object)) {
                        params[i] = argsStr[i];
                        continue;
                    }
                    writer.println("Failed!!");
                    writer.print("PropertyEditor ");
                    writer.print(paramTypes[i]);
                    writer.println(" not found.");
                    return result.toString();
                }
                if (argsStr.length > i) {
                    editor.setAsText(argsStr[i]);
                    params[i] = editor.getValue();
                    continue;
                }
                params[i] = null;
            }
            Object ret = method.invoke(targetObj, params);
            writer.println("Success!!");
            Class<?> retType = method.getReturnType();
            if (!retType.equals(Void.TYPE)) {
                editor = this.findEditor(service, retType);
                if (editor == null) {
                    writer.println(ret);
                } else {
                    editor.setValue(ret);
                    writer.println(editor.getValue());
                }
            }
        }
        catch (Exception e) {
            writer.println("Failed!!");
            e.printStackTrace(writer);
            return result.toString();
        }
        return result.toString();
    }

    private String setAttributeValue(Service service, String methodStr, String value) {
        Object targetObj = this.getTargetObject(service);
        Class<?> targetClass = service.getClass();
        try {
            MethodSignature signature = new MethodSignature(methodStr);
            Method method = signature.getMethod(targetObj);
            Class<?>[] paramTypes = method.getParameterTypes();
            PropertyEditor editor = this.findEditor(service, paramTypes[0]);
            Object[] params = null;
            if (editor == null) {
                return "Failed!! PropertyEditor " + paramTypes[0] + " not found.";
            }
            if (value == null || value.equals("null")) {
                params = new Object[]{null};
            } else {
                editor.setAsText(value);
                params = new Object[]{editor.getValue()};
            }
            method.invoke(targetObj, params);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            return sw.toString();
        }
        return "Success!!";
    }

    private PropertyEditor findEditor(Service service, Class type) {
        PropertyEditor editor = null;
        if (service instanceof ServiceManager) {
            ServiceLoader loader;
            Iterator loaders = ((ServiceManager)service).getServiceLoaders().iterator();
            while (loaders.hasNext() && (editor = (loader = (ServiceLoader)loaders.next()).findEditor(type)) == null) {
            }
        } else {
            ServiceMetaData metaData = ServiceManagerFactory.getServiceMetaData(service.getServiceManagerName(), service.getServiceName());
            ServiceLoader loader = metaData.getServiceLoader();
            editor = loader.findEditor(type);
        }
        return editor;
    }

    private String getAttributeValue(Service service, AttributeMethod method) {
        Object targetObj = this.getTargetObject(service);
        Class<?> targetClass = service.getClass();
        String result = null;
        try {
            Object val = method.getGetter().invoke(targetObj, null);
            if (val == null) {
                return "null";
            }
            PropertyEditor editor = this.findEditor(service, method.getGetter().getReturnType());
            if (editor == null) {
                return val.toString();
            }
            editor.setValue(val);
            result = editor.getAsText();
            if (result == null) {
                return "null";
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        catch (ServiceNotFoundException e) {
            e.printStackTrace();
            return "Can not get!!";
        }
        return result;
    }

    private Map getAttributes(Method[] methods) {
        HashMap<String, AttributeMethod> result = new HashMap<String, AttributeMethod>();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            Class<?> retType = methods[i].getReturnType();
            Class[] paramTypes = methods[i].getParameterTypes();
            if (!this.isAttributeMethod(methods[i])) continue;
            boolean isAttributeSet = false;
            boolean isAttributeGet = false;
            isAttributeSet = this.isAttributeSetMethod(methodName, retType, paramTypes);
            if (!isAttributeSet && !(isAttributeGet = this.isAttributeGetMethod(methodName, retType, paramTypes))) {
                isAttributeGet = this.isAttributeIsMethod(methodName, retType, paramTypes);
            }
            if (!isAttributeSet && !isAttributeGet) continue;
            String attrName = this.getAttributeName(methodName);
            AttributeMethod attrMethod = null;
            if (result.containsKey(attrName)) {
                attrMethod = (AttributeMethod)result.get(attrName);
            } else {
                attrMethod = new AttributeMethod();
                result.put(attrName, attrMethod);
            }
            if (isAttributeSet) {
                attrMethod.setSetter(methods[i]);
                continue;
            }
            attrMethod.setGetter(methods[i]);
        }
        return result;
    }

    private boolean isAttributeMethod(Method method) {
        Class[] paramTypes;
        Class<?> retType;
        String methodName = method.getName();
        return this.isAttributeGetMethod(methodName, retType = method.getReturnType(), paramTypes = method.getParameterTypes()) || this.isAttributeIsMethod(methodName, retType, paramTypes) || this.isAttributeSetMethod(methodName, retType, paramTypes);
    }

    private boolean isAttributeGetMethod(String methodName, Class retType, Class[] paramTypes) {
        return methodName.startsWith("get") && methodName.length() > 3 && !retType.equals(Void.TYPE) && paramTypes.length == 0;
    }

    private boolean isAttributeIsMethod(String methodName, Class retType, Class[] paramTypes) {
        return methodName.startsWith("is") && methodName.length() > 2 && retType.equals(Boolean.TYPE) && paramTypes.length == 0;
    }

    private boolean isAttributeSetMethod(String methodName, Class retType, Class[] paramTypes) {
        return methodName.startsWith("set") && methodName.length() > 3 && retType.equals(Void.TYPE) && paramTypes.length == 1;
    }

    private String getAttributeName(String methodName) {
        int length = methodName.length();
        if (methodName.startsWith("get") && length > 3) {
            return methodName.substring(3);
        }
        if (methodName.startsWith("is") && length > 2) {
            return methodName.substring(2);
        }
        if (methodName.startsWith("set") && length > 3) {
            return methodName.substring(3);
        }
        return null;
    }

    private String getAttributeType(AttributeMethod method) {
        boolean hasGetter;
        boolean hasSetter = method.getSetter() != null;
        boolean bl = hasGetter = method.getGetter() != null;
        if (hasSetter && hasGetter) {
            return ATTRIBUTE_READ_AND_WRITE;
        }
        if (hasSetter) {
            return ATTRIBUTE_WRITE_ONLY;
        }
        return ATTRIBUTE_READ_ONLY;
    }

    public void destroy() {
        String[] servicePaths = this.getServicePaths();
        if (servicePaths != null && servicePaths.length != 0) {
            int i = servicePaths.length;
            while (--i >= 0) {
                ServiceManagerFactory.unloadManager(servicePaths[i]);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MethodSignature
    implements Comparable {
        private String methodName;
        private Class[] paramTypes;

        public MethodSignature(Method method) {
            this.methodName = method.getName();
            this.paramTypes = method.getParameterTypes();
        }

        public MethodSignature(String method) throws IllegalArgumentException, ClassNotFoundException {
            String tmp = method;
            int index = tmp.indexOf(40);
            if (index == -1 || index == 0 || index == tmp.length() - 1) {
                throw new IllegalArgumentException("Invalid method : " + method);
            }
            this.methodName = tmp.substring(0, index);
            if ((index = (tmp = tmp.substring(index + 1)).indexOf(41)) == -1 || index != tmp.length() - 1) {
                throw new IllegalArgumentException("Invalid method : " + method);
            }
            if (index == 0) {
                this.paramTypes = null;
            } else {
                tmp = tmp.substring(0, index);
                StringTokenizer tokens = new StringTokenizer(tmp, ",");
                ArrayList<Class<Boolean>> paramTypeList = new ArrayList<Class<Boolean>>();
                NimbusClassLoader loader = NimbusClassLoader.getInstance();
                while (tokens.hasMoreTokens()) {
                    String paramTypeStr = tokens.nextToken().trim();
                    if (paramTypeStr.length() == 0) {
                        throw new IllegalArgumentException("Invalid method : " + method);
                    }
                    Class<Serializable> paramType = null;
                    paramType = paramTypeStr.equals("boolean") ? Boolean.TYPE : (paramTypeStr.equals("byte") ? Byte.TYPE : (paramTypeStr.equals("char") ? Character.TYPE : (paramTypeStr.equals("short") ? Short.TYPE : (paramTypeStr.equals("int") ? Integer.TYPE : (paramTypeStr.equals("long") ? Long.TYPE : (paramTypeStr.equals("float") ? Float.TYPE : (paramTypeStr.equals("double") ? Double.TYPE : Class.forName(paramTypeStr, true, loader))))))));
                    paramTypeList.add(paramType);
                }
                this.paramTypes = paramTypeList.toArray(new Class[paramTypeList.size()]);
            }
        }

        public Method getMethod(Object obj) throws NoSuchMethodException {
            return obj.getClass().getMethod(this.methodName, this.paramTypes);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o instanceof MethodSignature) {
                MethodSignature comp = (MethodSignature)o;
                if (!this.methodName.equals(comp.methodName)) {
                    return false;
                }
                if (this.paramTypes == comp.paramTypes) {
                    return true;
                }
                if (this.paramTypes == null && comp.paramTypes != null || this.paramTypes != null && comp.paramTypes == null || this.paramTypes.length != comp.paramTypes.length) {
                    return false;
                }
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    if (this.paramTypes[i].equals(comp.paramTypes[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.methodName.hashCode();
            if (this.paramTypes != null) {
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    hashCode += this.paramTypes[i].hashCode();
                }
            }
            return hashCode;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.methodName);
            buf.append('(');
            if (this.paramTypes != null) {
                int max = this.paramTypes.length;
                for (int i = 0; i < max; ++i) {
                    buf.append(this.paramTypes[i].getName());
                    if (i == max - 1) continue;
                    buf.append(',');
                }
            }
            buf.append(')');
            return buf.toString();
        }

        public int compareTo(Object obj) {
            if (obj instanceof MethodSignature) {
                MethodSignature sig = (MethodSignature)obj;
                if (this.methodName.equals(sig.methodName)) {
                    if (this.paramTypes == null) {
                        if (sig.paramTypes == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (sig.paramTypes == null) {
                        return 1;
                    }
                    if (this.paramTypes.length == sig.paramTypes.length) {
                        for (int i = 0; i < this.paramTypes.length; ++i) {
                            int ret = this.paramTypes[i].getName().compareTo(sig.paramTypes[i].getName());
                            if (ret == 0) continue;
                            return ret;
                        }
                        return 0;
                    }
                    return this.paramTypes.length > sig.paramTypes.length ? 1 : -1;
                }
                return this.methodName.compareTo(sig.methodName);
            }
            return -1;
        }
    }

    private class AttributeMethod {
        private Method getterMethod;
        private Method setterMethod;
        private Class attributeType;

        private AttributeMethod() {
        }

        public void setGetter(Method getter) {
            this.getterMethod = getter;
            if (getter != null && this.attributeType == null) {
                this.attributeType = getter.getReturnType();
            }
        }

        public Method getGetter() {
            return this.getterMethod;
        }

        public void setSetter(Method setter) {
            this.setterMethod = setter;
            if (setter != null && this.attributeType == null) {
                this.attributeType = setter.getParameterTypes()[0];
            }
        }

        public Method getSetter() {
            return this.setterMethod;
        }

        public Class getType() {
            return this.attributeType;
        }
    }
}

