/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import jp.ossc.nimbus.core.GenericsServiceProxy;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceProxy;

public class ServiceProxyFactory {
    static /* synthetic */ Class class$jp$ossc$nimbus$core$ServiceBaseSupport;
    static /* synthetic */ Class class$jp$ossc$nimbus$core$ServiceProxy;

    private ServiceProxyFactory() {
    }

    public static ServiceBase createServiceBaseProxy(ServiceBaseSupport support) throws Exception {
        return new GenericsServiceProxy(support);
    }

    public static ServiceBase createServiceBaseProxy(Object obj) throws Exception {
        ServiceBaseSupport support = null;
        Class<?>[] interfaces = obj.getClass().getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            support = new ServiceBaseSupportAdapter(obj);
        } else {
            Class[] newInterfaces = new Class[interfaces.length + 2];
            newInterfaces[0] = class$jp$ossc$nimbus$core$ServiceBaseSupport == null ? (class$jp$ossc$nimbus$core$ServiceBaseSupport = ServiceProxyFactory.class$("jp.ossc.nimbus.core.ServiceBaseSupport")) : class$jp$ossc$nimbus$core$ServiceBaseSupport;
            newInterfaces[1] = class$jp$ossc$nimbus$core$ServiceProxy == null ? (class$jp$ossc$nimbus$core$ServiceProxy = ServiceProxyFactory.class$("jp.ossc.nimbus.core.ServiceProxy")) : class$jp$ossc$nimbus$core$ServiceProxy;
            System.arraycopy(interfaces, 0, newInterfaces, 2, interfaces.length);
            support = (ServiceBaseSupport)Proxy.newProxyInstance(NimbusClassLoader.getInstance(), newInterfaces, (InvocationHandler)new ServiceBaseSupportProxyHandler(obj));
        }
        return ServiceProxyFactory.createServiceBaseProxy(support);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ServiceBaseSupportAdapter
    implements ServiceBaseSupport,
    ServiceProxy,
    Serializable {
        private static final String CREATE = "create";
        private static final String START = "start";
        private static final String STOP = "stop";
        private static final String DESTROY = "destroy";
        private final Method create;
        private final Method start;
        private final Method stop;
        private final Method destroy;
        private final Object obj;

        public ServiceBaseSupportAdapter(Object obj) {
            this.obj = obj;
            Class<?> clazz = obj.getClass();
            this.create = this.findMethod(clazz, CREATE, null);
            this.start = this.findMethod(clazz, START, null);
            this.stop = this.findMethod(clazz, STOP, null);
            this.destroy = this.findMethod(clazz, DESTROY, null);
        }

        private Method findMethod(Class clazz, String name, Class[] params) {
            try {
                return clazz.getMethod(name, params);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void createService() throws Exception {
            if (this.create == null) {
                return;
            }
            try {
                this.create.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void startService() throws Exception {
            if (this.start == null) {
                return;
            }
            try {
                this.start.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void stopService() throws Exception {
            if (this.stop == null) {
                return;
            }
            try {
                this.stop.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public void destroyService() throws Exception {
            if (this.destroy == null) {
                return;
            }
            try {
                this.destroy.invoke(this.obj, null);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
        }

        public Object getTarget() {
            return this.obj;
        }
    }

    private static class ServiceBaseSupportProxyHandler
    implements InvocationHandler,
    Serializable {
        private static final String GET_TARGET = "getTarget";
        private final Object targetObj;

        public ServiceBaseSupportProxyHandler(Object target) {
            this.targetObj = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (GET_TARGET.equals(method.getName()) && method.getParameterTypes().length == 0) {
                return this.targetObj;
            }
            Method targetMethod = null;
            try {
                targetMethod = this.targetObj.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            try {
                return targetMethod.invoke(this.targetObj, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        public Object getTarget() {
            return this.targetObj;
        }
    }
}

