/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerAccessImpl;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerFactoryCallBack;
import jp.ossc.nimbus.service.beancontrol.DefaultBeanFlowInvokerFactoryServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanControlUncheckedException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManagerFactory;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.util.CsvArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultBeanFlowInvokerFactoryService
extends ServiceBase
implements DefaultBeanFlowInvokerFactoryServiceMBean,
BeanFlowInvokerFactory,
BeanFlowInvokerFactoryCallBack {
    private static final String FLOW_TAG_NAME = "flow";
    private Map mSuspendKeyMap = null;
    private Map mIgnoreKeyMap = null;
    private Map mFlowConfigMap = null;
    private List mExecFlowList = null;
    private Map mMessageMap = null;
    private String[] mDirPath = null;
    private ServiceName mThreadContextServiceName = null;
    private Context mThreadContext = null;
    private ServiceName mJournalServiceName = null;
    private Journal mJournal = null;
    private ServiceName mResourceManagerFactoryServiceName = null;
    private ResourceManagerFactory mRmFactory = null;
    private ServiceName mLogServiceName = null;
    private Logger mLogger = null;
    protected Date mRefreshPlanTime = null;
    protected Date mRefreshedTime = null;
    private ServiceName editorFinderServiceName;
    private EditorFinder editorFinder;
    private boolean reloading = false;
    private boolean isManageExecBeanFlow = true;

    public void createService() {
        this.mFlowConfigMap = new HashMap(2048);
        this.mExecFlowList = new ArrayList();
        this.mMessageMap = new HashMap();
        this.mSuspendKeyMap = new HashMap();
        this.mIgnoreKeyMap = new HashMap();
    }

    public void startService() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        try {
            this.mRefreshPlanTime = ft.parse(ft.format(new Date()));
        }
        catch (ParseException e) {
            throw new BeanControlUncheckedException("DateFormat ParseException", e);
        }
        if (this.mThreadContextServiceName != null) {
            this.mThreadContext = (Context)ServiceManagerFactory.getServiceObject(this.mThreadContextServiceName);
        }
        if (this.mJournalServiceName != null) {
            this.mJournal = (Journal)ServiceManagerFactory.getServiceObject(this.mJournalServiceName);
        }
        if (this.editorFinderServiceName != null) {
            this.editorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.editorFinderServiceName);
        }
        if (this.mLogServiceName != null) {
            this.mLogger = (Logger)ServiceManagerFactory.getServiceObject(this.mLogServiceName);
        } else if (this.mLogger == null) {
            this.mLogger = this.getLogger();
        }
        if (this.mResourceManagerFactoryServiceName != null) {
            this.mRmFactory = (ResourceManagerFactory)ServiceManagerFactory.getServiceObject(this.mResourceManagerFactoryServiceName);
        }
        this.reload();
    }

    public void stopService() {
        this.mDirPath = null;
        this.mFlowConfigMap.clear();
        this.mExecFlowList.clear();
        this.mMessageMap.clear();
        Iterator iterator = this.mSuspendKeyMap.values().iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            obj.notifyAll();
        }
        this.mSuspendKeyMap.clear();
        this.mIgnoreKeyMap.clear();
    }

    public void destroyService() {
        this.mDirPath = null;
        this.mFlowConfigMap = null;
        this.mExecFlowList = null;
        this.mMessageMap = null;
        this.mSuspendKeyMap = null;
        this.mIgnoreKeyMap = null;
        this.mThreadContext = null;
        this.mJournal = null;
        this.mLogger = null;
        this.editorFinder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (this.reloading) {
            return;
        }
        Map map = this.mFlowConfigMap;
        synchronized (map) {
            try {
                this.reloading = true;
                SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
                this.clear();
                for (int rcnt = 0; rcnt < this.mDirPath.length; ++rcnt) {
                    String tmpName = this.mDirPath[rcnt];
                    RecurciveSearchFile file = new RecurciveSearchFile(tmpName);
                    File[] files = file.listFiles(new ExtentionFileFilter(".xml"));
                    if (files == null) continue;
                    for (int filecount = 0; filecount < files.length; ++filecount) {
                        this.loadXMLDefinition(files[filecount]);
                    }
                }
                try {
                    this.mRefreshedTime = ft.parse(ft.format(new Date()));
                }
                catch (ParseException e) {
                    throw new BeanControlUncheckedException("Date ParseException", e);
                }
            }
            finally {
                this.reloading = false;
            }
        }
    }

    public void setManageExecBeanFlow(boolean isManage) {
        this.isManageExecBeanFlow = isManage;
    }

    public boolean isManageExecBeanFlow() {
        return this.isManageExecBeanFlow;
    }

    public void setResourceManagerFactoryServiceName(ServiceName name) {
        this.mResourceManagerFactoryServiceName = name;
    }

    public void setLogServiceName(ServiceName name) {
        this.mLogServiceName = name;
    }

    public void setEditorFinderServiceName(ServiceName name) {
        this.editorFinderServiceName = name;
    }

    public ServiceName setEditorFinderServiceName() {
        return this.editorFinderServiceName;
    }

    public void setDirPaths(String[] dirPaths) {
        this.mDirPath = dirPaths;
    }

    public void setJournalServiceName(ServiceName name) {
        this.mJournalServiceName = name;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.mThreadContextServiceName = name;
    }

    public Context getThreadContext() {
        return this.mThreadContext;
    }

    public Journal getJournal() {
        return this.mJournal;
    }

    public EditorFinder getEditorFinder() {
        return this.editorFinder;
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecList(String key) {
        List list = this.mExecFlowList;
        synchronized (list) {
            this.mExecFlowList.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshTime(String time) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        DefaultBeanFlowInvokerFactoryService defaultBeanFlowInvokerFactoryService = this;
        synchronized (defaultBeanFlowInvokerFactoryService) {
            try {
                this.mRefreshPlanTime = ft.parse(time);
            }
            catch (ParseException e) {
                throw new BeanControlUncheckedException("ParseException", e);
            }
        }
    }

    public String getLastRrefreshTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        return ft.format(this.mRefreshedTime);
    }

    public String getNextRefreshTime() {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        return ft.format(this.mRefreshPlanTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(String key) {
        Map map = this.mSuspendKeyMap;
        synchronized (map) {
            Object ret = this.mSuspendKeyMap.get(key);
            if (ret == null) {
                ret = new Object();
                this.mSuspendKeyMap.put(key, ret);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String key) {
        Map map = this.mSuspendKeyMap;
        synchronized (map) {
            Object ret = this.mSuspendKeyMap.get(key);
            if (ret != null) {
                ret.notifyAll();
                this.mSuspendKeyMap.remove(ret);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignore(String msgKey) {
        Map map = this.mIgnoreKeyMap;
        synchronized (map) {
            Object ret = this.mIgnoreKeyMap.get(msgKey);
            if (ret == null) {
                ret = new Object();
                this.mIgnoreKeyMap.put(msgKey, ret);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unIgnore(String key) {
        Map map = this.mIgnoreKeyMap;
        synchronized (map) {
            Object ret = this.mIgnoreKeyMap.get(key);
            if (ret != null) {
                this.mIgnoreKeyMap.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSuspendList() {
        CsvArrayList ret = new CsvArrayList();
        Map map = this.mSuspendKeyMap;
        synchronized (map) {
            Iterator iterator = this.mSuspendKeyMap.keySet().iterator();
            while (iterator.hasNext()) {
                String msg = (String)iterator.next();
                ret.add(msg);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getIgnoreList() {
        CsvArrayList ret = new CsvArrayList();
        Map map = this.mIgnoreKeyMap;
        synchronized (map) {
            Iterator iterator = this.mIgnoreKeyMap.keySet().iterator();
            while (iterator.hasNext()) {
                String msg = (String)iterator.next();
                ret.add(msg);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcecFlowName(String flowName) {
        List list = this.mExecFlowList;
        synchronized (list) {
            this.mExecFlowList.add(flowName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getExecFlowList() {
        CsvArrayList ret = new CsvArrayList();
        List list = this.mExecFlowList;
        synchronized (list) {
            ListIterator iterator = this.mExecFlowList.listIterator();
            while (iterator.hasNext()) {
                ret.add(iterator.next());
            }
        }
        return ret;
    }

    public BeanFlowInvoker createFlow(String key) {
        BeanFlowInvoker blFlowConfig;
        Object ignore;
        if (this.mRefreshPlanTime.after(this.mRefreshedTime) && this.mRefreshPlanTime.before(new Date())) {
            this.reload();
        }
        if ((ignore = this.mIgnoreKeyMap.get(key)) != null) {
            return null;
        }
        Object suspend = this.mSuspendKeyMap.get(key);
        if (suspend != null) {
            try {
                suspend.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if ((blFlowConfig = (BeanFlowInvoker)this.mMessageMap.get(key)) == null) {
            throw new InvalidConfigurationException(key + " no mapped FLOW");
        }
        return blFlowConfig;
    }

    protected void clear() {
        this.mFlowConfigMap.clear();
        this.mMessageMap.clear();
    }

    public String[] getDirPaths() {
        return this.mDirPath;
    }

    protected void loadXMLDefinition(File xmlfile) {
        Element root = null;
        try {
            root = this.getRoot(xmlfile);
        }
        catch (ParserConfigurationException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (SAXException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(e);
        }
        NodeList flowList = root.getElementsByTagName(FLOW_TAG_NAME);
        for (int rCnt = 0; rCnt < flowList.getLength(); ++rCnt) {
            Element flowElement = (Element)flowList.item(rCnt);
            BeanFlowInvokerAccessImpl op = new BeanFlowInvokerAccessImpl();
            op.fillInstance(flowElement, this);
            this.mFlowConfigMap.put(op.getFlowName(), op);
            ArrayList list = op.getAiliasFlowNames();
            ListIterator ite = list.listIterator();
            while (ite.hasNext()) {
                String ailias = (String)ite.next();
                this.mMessageMap.put(ailias, op);
            }
        }
    }

    protected Element getRoot(File xmlfile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbfactory.newDocumentBuilder();
        Document doc = builder.parse(xmlfile);
        return doc.getDocumentElement();
    }

    public ResourceManager createResourceManager() {
        return this.mRmFactory.createResourceManager();
    }

    public PropertyEditor findPropEditor(Class cls) {
        return super.getServiceLoader().findEditor(cls);
    }

    public void setResourceManagerFactory(ResourceManagerFactory rmFactory) {
        this.mRmFactory = rmFactory;
    }

    public void setJournal(Journal journal) {
        this.mJournal = journal;
    }

    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    public void setThreadContext(Context threadContext) {
        this.mThreadContext = threadContext;
    }

    public void setEditorFinder(EditorFinder editorFinder) {
        this.editorFinder = editorFinder;
    }
}

