/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import jp.ossc.nimbus.service.graph.DefaultTimeGraphCreatorServiceMBean;
import jp.ossc.nimbus.service.graph.DefaultXYGraphCreatorService;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.Series;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class DefaultTimeGraphCreatorService
extends DefaultXYGraphCreatorService
implements DefaultTimeGraphCreatorServiceMBean {
    protected Class timePeriodClass;
    protected Constructor timePeriodConstructor;
    protected String inputDateFormat;
    protected String outputDateFormat;
    static /* synthetic */ Class class$org$jfree$data$time$RegularTimePeriod;
    static /* synthetic */ Class class$java$util$Date;

    public void setTimePeriodClass(Class clazz) {
        this.timePeriodClass = clazz;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public void setInputDateFormat(String format) {
        this.inputDateFormat = format;
    }

    public String getInputDateFormat() {
        return this.inputDateFormat;
    }

    public void setOutputDateFormat(String format) {
        this.outputDateFormat = format;
    }

    public String getOutputDateFormat() {
        return this.outputDateFormat;
    }

    public void startService() throws Exception {
        super.startService();
        if (this.timePeriodClass == null) {
            throw new IllegalArgumentException("timePeriodClass is null");
        }
        if (!(class$org$jfree$data$time$RegularTimePeriod == null ? (class$org$jfree$data$time$RegularTimePeriod = DefaultTimeGraphCreatorService.class$("org.jfree.data.time.RegularTimePeriod")) : class$org$jfree$data$time$RegularTimePeriod).isAssignableFrom(this.timePeriodClass)) {
            throw new IllegalArgumentException("timePeriodClass is not RegularTimePeriod");
        }
        this.timePeriodConstructor = this.timePeriodClass.getConstructor(class$java$util$Date == null ? (class$java$util$Date = DefaultTimeGraphCreatorService.class$("java.util.Date")) : class$java$util$Date);
        if (this.inputDateFormat == null) {
            throw new IllegalArgumentException("inputDateFormat is null");
        }
    }

    protected JFreeChart createXYGraph(String key, Dataset dataset) throws Exception {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)this.getGraphTitle(), (String)this.getXLabel(), (String)this.getYLabel(), (XYDataset)((XYDataset)dataset), (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        DateAxis dateaxis = (DateAxis)xyplot.getDomainAxis();
        dateaxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.outputDateFormat == null ? this.inputDateFormat : this.outputDateFormat));
        return chart;
    }

    protected Series createNewSeries(String key, String label) throws Exception {
        return new TimeSeries(label, this.timePeriodClass);
    }

    protected Dataset createNewDataset(String key) throws Exception {
        return new TimeSeriesCollection();
    }

    protected void addData(String key, Series series, String x, String y) throws Exception {
        TimeSeries timeSeries = (TimeSeries)series;
        timeSeries.add((RegularTimePeriod)this.timePeriodConstructor.newInstance(new SimpleDateFormat(this.inputDateFormat).parse(x)), Double.parseDouble(y));
    }

    protected void addSeries(String key, Series series, Dataset ds) throws Exception {
        TimeSeriesCollection collection = (TimeSeriesCollection)ds;
        collection.addSeries((TimeSeries)series);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

