/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerCreateException;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactoryService;

public class JMSTopicSubscriberFactoryService
extends JMSMessageConsumerFactoryService {
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector) throws JMSMessageConsumerCreateException {
        return this.createConsumer(session, destination, messageSelector, this.isNoLocal);
    }

    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        if (session == null) {
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if (destination == null) {
            throw new JMSMessageConsumerCreateException("Destination is null.");
        }
        try {
            return ((TopicSession)session).createSubscriber((Topic)destination, messageSelector, noLocal);
        }
        catch (JMSException e) {
            throw new JMSMessageConsumerCreateException(e);
        }
    }

    public TopicSubscriber createDurableSubscriber(Session session, Topic topic, String name) throws JMSMessageConsumerCreateException {
        if (session == null) {
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if (topic == null) {
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        try {
            return ((TopicSession)session).createDurableSubscriber(topic, name);
        }
        catch (JMSException e) {
            throw new JMSMessageConsumerCreateException(e);
        }
    }

    public TopicSubscriber createDurableSubscriber(Session session, Topic topic, String name, String messageSelector, boolean noLocal) throws JMSMessageConsumerCreateException {
        if (session == null) {
            throw new JMSMessageConsumerCreateException("Session is null.");
        }
        if (topic == null) {
            throw new JMSMessageConsumerCreateException("Topic is null.");
        }
        try {
            return ((TopicSession)session).createDurableSubscriber(topic, name, messageSelector, noLocal);
        }
        catch (JMSException e) {
            throw new JMSMessageConsumerCreateException(e);
        }
    }
}

