/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.jmsqueue;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmsqueue.JmsQueueSession;
import jp.ossc.nimbus.service.resource.jmsqueue.JmsQueueSessionServiceMBean;
import jp.ossc.nimbus.service.resource.jmsqueue.QueueTransanctionResource;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import jp.ossc.nimbus.service.semaphore.SemaphoreFactory;

public class JmsQueueSessionService
extends ServiceBase
implements JmsQueueSessionServiceMBean,
JmsQueueSession,
CacheRemoveListener {
    private JndiFinder mJndiFinderService = null;
    private ServiceName mJndiFinderServiceName = null;
    private int mAckMode = 1;
    private boolean mTransanctionMode = false;
    private QueueConnectionFactory mQueueConnectionFactory;
    private ServiceName mSemaphoreFactoryServiceName;
    private SemaphoreFactory mSemaphoreFactory;
    private Semaphore mSemaphore;
    private QueueConnection mConnection;
    private int mSemaphoreCapacity;
    private String userName;
    private String password;
    private String queueConnectionFactoryName;
    private String connectionKey = "QueueConnection";
    private ServiceName connectionCacheMapServiceName;
    private CacheMap connectionCache;

    public void setSemaphoreFactoryServiceName(ServiceName name) {
        this.mSemaphoreFactoryServiceName = name;
    }

    public void setCapacity(int capa) {
        this.mSemaphoreCapacity = capa;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public int getAcknowledgeMode() {
        return this.mAckMode;
    }

    public void setTransanctionMode(boolean mode) {
        this.mTransanctionMode = mode;
    }

    public boolean getTransanctionMode() {
        return this.mTransanctionMode;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setConnectionFactoryName(String name) {
        this.queueConnectionFactoryName = name;
    }

    public String getConnectionFactoryName() {
        return this.queueConnectionFactoryName;
    }

    public void setConnectionCacheKey(String key) {
        this.connectionKey = key;
    }

    public String getConnectionCacheKey() {
        return this.connectionKey;
    }

    public void setConnectionCacheMapServiceName(ServiceName name) {
        this.connectionCacheMapServiceName = name;
    }

    public ServiceName getConnectionCacheMapServiceName() {
        return this.connectionCacheMapServiceName;
    }

    public void startService() throws Exception {
        this.mJndiFinderService = (JndiFinder)((Object)ServiceManagerFactory.getService(this.mJndiFinderServiceName));
        if (this.mSemaphoreFactoryServiceName != null) {
            this.mSemaphoreFactory = (SemaphoreFactory)((Object)ServiceManagerFactory.getService(this.mSemaphoreFactoryServiceName));
        }
        try {
            this.mQueueConnectionFactory = this.queueConnectionFactoryName == null ? (QueueConnectionFactory)this.mJndiFinderService.lookup() : (QueueConnectionFactory)this.mJndiFinderService.lookup(this.queueConnectionFactoryName);
        }
        catch (NamingException e) {
            throw new ServiceException("JMSQUEUESESSIONSERVICE013", "Fail to lookup QueueConnectionFactory", e);
        }
        catch (ClassCastException e) {
            throw new ServiceException("JMSQUEUESESSIONSERVICE014", "found resource is not QueueConnectionFactory.", e);
        }
        try {
            if (this.connectionCacheMapServiceName == null) {
                this.mConnection = this.createConnection();
            } else {
                this.connectionCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.connectionCacheMapServiceName);
                this.connectionCache.put(this.connectionKey, this.createConnection());
            }
        }
        catch (Exception e) {
            throw new ServiceException("JMSQUEUESESSIONSERVICE015", "Fail to Create Connection.", e);
        }
        if (this.mSemaphoreFactory != null) {
            this.mSemaphore = this.mSemaphoreFactory.createSemaphore(this.mSemaphoreCapacity);
            this.mSemaphore.accept();
        }
    }

    public void stopService() {
        try {
            if (this.mConnection != null) {
                this.mConnection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mSemaphore != null) {
            this.mSemaphore.release();
        }
        this.mSemaphore = null;
        if (this.connectionCache != null) {
            this.connectionCache.remove(this.connectionKey);
            this.connectionCache = null;
        }
    }

    public void destory() {
        this.mJndiFinderService = null;
    }

    public void setAcknowledgeMode(int mode) {
        if (mode == 1 || mode == 2 || mode == 3) {
            this.mAckMode = mode;
        }
    }

    public TransactionResource makeResource(String key) throws JMSException {
        QueueSession qSession = null;
        QueueConnection conn = null;
        if (this.mSemaphore != null) {
            this.mSemaphore.getResource();
        }
        try {
            if (this.mConnection == null && this.connectionCache != null) {
                conn = (QueueConnection)this.connectionCache.get(this.connectionKey);
                if (conn == null) {
                    conn = this.createConnection();
                    this.connectionCache.put(this.connectionKey, conn);
                }
            } else {
                conn = this.mConnection;
            }
        }
        catch (JMSException e) {
            try {
                this.mQueueConnectionFactory = (QueueConnectionFactory)this.mJndiFinderService.lookup(this.queueConnectionFactoryName);
            }
            catch (NamingException e1) {
                throw new ServiceException("00013", "Fail to lookup key = " + this.queueConnectionFactoryName, e1);
            }
            if (this.mConnection == null && this.connectionCache != null) {
                conn = (QueueConnection)this.connectionCache.get(this.connectionKey);
                if (conn == null) {
                    conn = this.createConnection();
                    this.connectionCache.put(this.connectionKey, conn);
                    this.connectionCache.getCachedReference(this.connectionKey).addCacheRemoveListener(this);
                }
            }
            conn = this.mConnection;
        }
        qSession = conn.createQueueSession(this.mTransanctionMode, this.mAckMode);
        QueueTransanctionResource tranObj = new QueueTransanctionResource(qSession, conn, this.mSemaphore);
        return tranObj;
    }

    private QueueConnection createConnection() throws JMSException {
        if (this.userName != null) {
            return this.mQueueConnectionFactory.createQueueConnection(this.userName, this.password);
        }
        return this.mQueueConnectionFactory.createQueueConnection();
    }

    public void removed(CachedReference ref) {
        Connection con = (Connection)ref.get();
        if (con != null) {
            try {
                con.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

