/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSMessageProducerCreateException;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactoryServiceMBean;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class JMSMessageProducerFactoryService
extends ServiceBase
implements JMSMessageProducerFactoryServiceMBean {
    protected ServiceName jmsSessionFactoryServiceName;
    protected JMSSessionFactory jmsSessionFactory;
    protected ServiceName destinationFinderServiceName;
    protected JndiFinder destinationFinder;
    protected String destinationName;
    protected Destination destination;
    protected Session session;
    protected boolean isSessionCreate;
    protected boolean isCloseSession;

    public void setJMSSessionFactoryServiceName(ServiceName name) {
        this.jmsSessionFactoryServiceName = name;
    }

    public ServiceName getJMSSessionFactoryServiceName() {
        return this.jmsSessionFactoryServiceName;
    }

    public void setDestinationFinderServiceName(ServiceName name) {
        this.destinationFinderServiceName = name;
    }

    public ServiceName getDestinationFinderServiceName() {
        return this.destinationFinderServiceName;
    }

    public void setDestinationName(String name) {
        this.destinationName = name;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setSessionCreate(boolean isCreate) {
        this.isSessionCreate = isCreate;
    }

    public boolean isSessionCreate() {
        return this.isSessionCreate;
    }

    public void setCloseSession(boolean isClose) {
        this.isCloseSession = isClose;
    }

    public boolean isCloseSession(boolean isClose) {
        return this.isCloseSession;
    }

    public void setJndiFinder(JndiFinder destinationFinder) {
        this.destinationFinder = destinationFinder;
    }

    public void setJmsSessionFactory(JMSSessionFactory jmsSessionFactory) {
        this.jmsSessionFactory = jmsSessionFactory;
    }

    public void startService() throws Exception {
        if (this.jmsSessionFactoryServiceName != null) {
            this.jmsSessionFactory = (JMSSessionFactory)ServiceManagerFactory.getServiceObject(this.jmsSessionFactoryServiceName);
        }
        if (this.destinationFinderServiceName != null) {
            this.destinationFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.destinationFinderServiceName);
            this.destination = this.destinationName == null ? (Destination)this.destinationFinder.lookup() : (Destination)this.destinationFinder.lookup(this.destinationName);
        }
        if (this.isSessionCreate) {
            if (this.jmsSessionFactory == null) {
                throw new IllegalArgumentException("jmsSessionFactoryServiceName must be specified.");
            }
            this.session = this.jmsSessionFactory.getSession();
        }
    }

    public void stopService() throws Exception {
        if (this.isCloseSession && this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this.jmsSessionFactory = null;
        this.destination = null;
    }

    public Session getSession() {
        return this.session;
    }

    public JMSSessionFactory getSessionFactory() {
        return this.jmsSessionFactory;
    }

    public MessageProducer createProducer() throws JMSMessageProducerCreateException {
        return this.createProducer(this.destination);
    }

    public MessageProducer createProducer(Destination dest) throws JMSMessageProducerCreateException {
        return this.createProducer(this.session, dest);
    }

    public MessageProducer createProducer(Session session, Destination dest) throws JMSMessageProducerCreateException {
        if (session == null) {
            throw new JMSMessageProducerCreateException("Session is null.");
        }
        if (dest == null) {
            throw new JMSMessageProducerCreateException("Destination is null.");
        }
        try {
            return session.createProducer(dest);
        }
        catch (JMSException e) {
            throw new JMSMessageProducerCreateException(e);
        }
    }
}

