/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.repository;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.repository.Repository;

public class JNDIRepositoryService
extends ServiceBase
implements Repository,
Serializable {
    private final Map registered = new Hashtable();
    private Properties environment;
    private transient InitialContext context;

    public Object get(String name) {
        if (this.registered.containsKey(name)) {
            return this.registered.get(name);
        }
        try {
            return this.context.lookup(name);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public boolean register(String name, Object obj) {
        boolean exists = false;
        try {
            this.context.lookup(name);
            exists = true;
        }
        catch (NamingException e) {
            exists = false;
        }
        try {
            if (!exists) {
                int index = -1;
                String tmp = name;
                while ((index = tmp.indexOf(47)) != -1) {
                    try {
                        this.context.createSubcontext(tmp.substring(0, index));
                    }
                    catch (NameAlreadyBoundException already) {
                        // empty catch block
                    }
                    if (index == tmp.length() - 1) break;
                    tmp = tmp.substring(index + 1);
                }
            }
            this.context.rebind(name, obj);
        }
        catch (NamingException e) {
            e.printStackTrace();
            return false;
        }
        this.registered.put(name, obj);
        return true;
    }

    public boolean unregister(String name) {
        this.registered.remove(name);
        try {
            this.context.unbind(name);
        }
        catch (NamingException e) {
            return false;
        }
        return true;
    }

    public boolean isRegistered(String name) {
        return this.get(name) != null;
    }

    public Set nameSet() {
        return new HashSet(this.registered.keySet());
    }

    public Set registeredSet() {
        HashSet<Object> result = new HashSet<Object>();
        Iterator registeredNames = this.nameSet().iterator();
        while (registeredNames.hasNext()) {
            Object obj = this.get((String)registeredNames.next());
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    public void setEnvironment(Properties env) {
        this.environment = env;
    }

    public void startService() throws Exception {
        this.context = this.getInitialContext();
    }

    public void destroyService() throws Exception {
        this.context = null;
    }

    private InitialContext getInitialContext() throws NamingException {
        InitialContext context = null;
        context = this.environment == null ? new InitialContext() : new InitialContext(this.environment);
        return context;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.context = this.getInitialContext();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

