/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class MemorySemaphore
implements Semaphore,
Serializable {
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected List waitThreads = new Vector();
    protected Set wakeUpThreads = Collections.synchronizedSet(new HashSet());

    public boolean getResource(long timeOutMiliSecond) {
        return this.getResource(timeOutMiliSecond, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        Thread current;
        block34: {
            boolean bl;
            block33: {
                boolean bl2;
                block32: {
                    boolean bl3;
                    block31: {
                        List list;
                        boolean bl4;
                        block29: {
                            if (maxWaitCount > 0 && this.waitThreads.size() >= maxWaitCount) {
                                return false;
                            }
                            current = Thread.currentThread();
                            List list2 = this.waitThreads;
                            synchronized (list2) {
                                this.waitThreads.add(current);
                                this.wakeUpThreads.add(current);
                            }
                            long timeOutMs = -1L;
                            if (timeOutMiliSecond >= 0L) {
                                timeOutMs = timeOutMiliSecond;
                            }
                            long processTime = 0L;
                            try {
                                while (timeOutMs <= 0L || timeOutMs > processTime) {
                                    if (this.mFourceEndFlg) {
                                        bl4 = false;
                                        Object var15_11 = null;
                                        list = this.waitThreads;
                                        break block29;
                                    }
                                    while (this.mResourceCnt == 0 && (timeOutMs < 0L || timeOutMs > processTime)) {
                                        long proc;
                                        block30: {
                                            proc = 0L;
                                            if (timeOutMs > 0L) {
                                                proc = System.currentTimeMillis();
                                            }
                                            try {
                                                if (!Thread.interrupted()) {
                                                    this.wakeUpThreads.remove(current);
                                                    Thread.sleep(timeOutMs >= 0L ? timeOutMs - processTime : 500L);
                                                    this.wakeUpThreads.add(current);
                                                }
                                            }
                                            catch (InterruptedException e) {
                                                Thread.interrupted();
                                                if (this.wakeUpThreads.contains(current)) break block30;
                                                boolean bl5 = false;
                                                Object var15_12 = null;
                                                List list3 = this.waitThreads;
                                                synchronized (list3) {
                                                    this.waitThreads.remove(current);
                                                    this.wakeUpThreads.remove(current);
                                                    return bl5;
                                                }
                                            }
                                        }
                                        if (timeOutMs <= 0L) continue;
                                        proc = System.currentTimeMillis() - proc;
                                        processTime += proc;
                                    }
                                    MemorySemaphore memorySemaphore = this;
                                    synchronized (memorySemaphore) {
                                        if (this.mFourceEndFlg) {
                                            bl3 = false;
                                            // MONITOREXIT @DISABLED, blocks:[1, 19, 10, 27] lbl59 : MonitorExitStatement: MONITOREXIT : var9_7
                                            break block31;
                                        }
                                        if (this.mResourceCnt > 0 && this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) {
                                            --this.mResourceCnt;
                                            bl2 = true;
                                            // MONITOREXIT @DISABLED, blocks:[1, 19, 26, 10] lbl65 : MonitorExitStatement: MONITOREXIT : var9_7
                                            break block32;
                                        }
                                        if (timeOutMs == 0L) {
                                            bl = false;
                                            // MONITOREXIT @DISABLED, blocks:[1, 19, 25, 10] lbl70 : MonitorExitStatement: MONITOREXIT : var9_7
                                            break block33;
                                        }
                                    }
                                }
                                break block34;
                            }
                            catch (Throwable throwable) {
                                Object var15_17 = null;
                                List list4 = this.waitThreads;
                                synchronized (list4) {
                                    this.waitThreads.remove(current);
                                    this.wakeUpThreads.remove(current);
                                    throw throwable;
                                }
                            }
                        }
                        synchronized (list) {
                            this.waitThreads.remove(current);
                            this.wakeUpThreads.remove(current);
                            return bl4;
                        }
                    }
                    Object var15_13 = null;
                    List list = this.waitThreads;
                    synchronized (list) {
                        this.waitThreads.remove(current);
                        this.wakeUpThreads.remove(current);
                        return bl3;
                    }
                }
                Object var15_14 = null;
                List list = this.waitThreads;
                synchronized (list) {
                    this.waitThreads.remove(current);
                    this.wakeUpThreads.remove(current);
                    return bl2;
                }
            }
            Object var15_15 = null;
            List list = this.waitThreads;
            synchronized (list) {
                this.waitThreads.remove(current);
                this.wakeUpThreads.remove(current);
                return bl;
            }
        }
        Object var15_16 = null;
        List list = this.waitThreads;
        synchronized (list) {
            this.waitThreads.remove(current);
            this.wakeUpThreads.remove(current);
            return false;
        }
    }

    public boolean getResource(int maxWaitCount) {
        return this.getResource(-1L, maxWaitCount);
    }

    public boolean getResource() {
        return this.getResource(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeResource() {
        Object object;
        if (this.mResourceCnt < this.mInitialResource) {
            object = this;
            synchronized (object) {
                ++this.mResourceCnt;
            }
        }
        object = this.waitThreads;
        synchronized (object) {
            Thread waitThread;
            if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0))) {
                this.wakeUpThreads.add(waitThread);
                waitThread.interrupt();
            }
        }
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCapacity(int capa) {
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            if (this.mInitialResource == -1) {
                this.mInitialResource = capa;
                this.mResourceCnt = capa;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceRemain() {
        int cnt;
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            cnt = this.mResourceCnt;
        }
        return cnt;
    }

    public int getWaitingCount() {
        return this.waitThreads.size();
    }

    public void release() {
        this.mFourceEndFlg = true;
        while (this.waitThreads.size() != 0) {
            this.freeResource();
        }
    }

    public void accept() {
        this.mFourceEndFlg = false;
    }
}

