/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmsqueue.JmsQueueSession;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.jms.MessageCreator;
import jp.ossc.nimbus.service.writer.jms.ObjectMessageCreator;
import jp.ossc.nimbus.service.writer.jms.QueueWriterServiceMBean;

public class QueueWriterService
extends ServiceBase
implements QueueWriterServiceMBean {
    private static final String JMSQW = "JMSQW";
    private static final String JMSQW0 = "JMSQW0";
    private static final String JMSQW00 = "JMSQW00";
    private static final String JMSQW000 = "JMSQW000";
    private static final String JMSQW0000 = "JMSQW0000";
    private static final String JMSQW00001 = "JMSQW00001";
    private static final String JMSQW00002 = "JMSQW00002";
    private static final String JMSQW00003 = "JMSQW00003";
    private static final String JMSQW00004 = "JMSQW00004";
    private static final String JMSQW00005 = "JMSQW00005";
    private static final String JMSQW00006 = "JMSQW00006";
    private static final String JMSQW00007 = "JMSQW00007";
    private static final String JMSQW00008 = "JMSQW00008";
    private static final String JMSQW00009 = "JMSQW00009";
    private static final String DEFAULT_MSG_CREATOR_CLASS_NAME = ObjectMessageCreator.class.getName();
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private ServiceName jmsQueueSessionServiceName;
    private JmsQueueSession queueSessionFactory;
    private String queueName;
    private int priority = 4;
    private String deliveryMode;
    private int delivery = 2;
    private long lifeTime = 0L;
    private String jmsMessageCreatorClassName = DEFAULT_MSG_CREATOR_CLASS_NAME;
    private MessageCreator messageCreator;

    public void startService() throws Exception {
        if (this.jndiFinderServiceName == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new ServiceException(JMSQW00001, message.findEmbedMessage(JMSQW00001, "jndiFinderServiceName"));
        }
        if (this.jmsQueueSessionServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.jndiFinder == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new ServiceException(JMSQW00001, message.findEmbedMessage(JMSQW00001, "jmsQueueSessionServiceName"));
        }
        if (this.jmsQueueSessionServiceName != null) {
            this.queueSessionFactory = (JmsQueueSession)ServiceManagerFactory.getServiceObject(this.jmsQueueSessionServiceName);
        }
        if (this.queueSessionFactory == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new ServiceException(JMSQW00001, message.findEmbedMessage(JMSQW00001, "jmsQueueSessionServiceName"));
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Class.forName(this.jmsMessageCreatorClassName, true, NimbusClassLoader.getInstance());
        this.messageCreator = (MessageCreator)clazz.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(WritableRecord rec) throws MessageWriteException {
        TransactionResource resource = null;
        try {
            resource = this.queueSessionFactory.makeResource(null);
        }
        catch (Exception e) {
            this.getLogger().write(JMSQW00002, e);
            throw new MessageWriteException(e);
        }
        try {
            QueueSession session = (QueueSession)resource.getObject();
            Queue queue = null;
            try {
                queue = (Queue)this.jndiFinder.lookup(this.queueName);
            }
            catch (NamingException e) {
                this.getLogger().write(JMSQW00003, (Object)this.queueName, (Throwable)e);
                throw new MessageWriteException(e);
            }
            QueueSender sender = null;
            try {
                sender = session.createSender(queue);
            }
            catch (JMSException e) {
                this.getLogger().write(JMSQW00004, e);
                throw new MessageWriteException(e);
            }
            Message message = null;
            try {
                message = this.messageCreator.createMessage((Session)session, rec);
            }
            catch (Exception e) {
                this.getLogger().write(JMSQW00005, e);
                throw new MessageWriteException(e);
            }
            try {
                if (message != null) {
                    sender.send(message, this.delivery, this.priority, this.lifeTime);
                }
            }
            catch (JMSException e) {
                this.getLogger().write(JMSQW00006, e);
                try {
                    resource.rollback();
                }
                catch (Exception ex) {
                    this.getLogger().write(JMSQW00007, ex);
                }
                throw new MessageWriteException(e);
            }
            try {
                resource.commit();
            }
            catch (Exception e) {
                this.getLogger().write(JMSQW00008, e);
                throw new MessageWriteException(e);
            }
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            try {
                resource.close();
            }
            catch (Exception e) {
                this.getLogger().write(JMSQW00009, e);
            }
            throw throwable;
        }
        try {
            resource.close();
        }
        catch (Exception e) {
            this.getLogger().write(JMSQW00009, e);
        }
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setJmsQueueSessionServiceName(ServiceName name) {
        this.jmsQueueSessionServiceName = name;
    }

    public ServiceName getJmsQueueSessionServiceName() {
        return this.jmsQueueSessionServiceName;
    }

    public void setQueueName(String name) {
        this.queueName = name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setDeliveryMode(String mode) throws IllegalArgumentException {
        this.deliveryMode = mode;
        if ("NON_PERSISTENT".equals(this.deliveryMode)) {
            this.delivery = 1;
        } else if ("PERSISTENT".equals(this.deliveryMode)) {
            this.delivery = 2;
        } else {
            throw new IllegalArgumentException("Unsupported delivery mode : " + mode);
        }
    }

    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setJMSMessageCreatorClassName(String name) {
        this.jmsMessageCreatorClassName = name;
    }

    public String getJMSMessageCreatorClassName() {
        return this.jmsMessageCreatorClassName;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void setQueueSessionFactory(JmsQueueSession queueSessionFactory) {
        this.queueSessionFactory = queueSessionFactory;
    }
}

