/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jp.ossc.nimbus.core.ServiceLoaderConfig;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;

class Utility {
    public static final String SYSTEM_PROPERTY_START = "${";
    public static final String SYSTEM_PROPERTY_END = "}";
    private static final String DEFAULT_SERVICE_FILE_PROPERTY_KEY = "jp.ossc.nimbus.service.url";
    private static final String DEFAULT_SERVICE_FILE = "nimbus-service.xml";

    Utility() {
    }

    public static URL getDefaultServiceURL() {
        String urlString = System.getProperty(DEFAULT_SERVICE_FILE_PROPERTY_KEY);
        URL url = null;
        if (urlString != null) {
            try {
                url = Utility.convertServicePathToURL(urlString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (url != null) {
                return url;
            }
        }
        url = Utility.class.getClassLoader().getResource(DEFAULT_SERVICE_FILE);
        return url;
    }

    public static URL convertServicePathToURL(String path) throws IllegalArgumentException {
        if (path == null || path.length() == 0) {
            return Utility.getDefaultServiceURL();
        }
        URL url = null;
        File localFile = new File(path);
        if (localFile.exists()) {
            if (!localFile.isFile()) {
                throw new IllegalArgumentException("ServicePath must be file : " + localFile);
            }
            try {
                url = localFile.toURL();
            }
            catch (MalformedURLException e) {}
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL resource = classLoader.getResource(path);
            if (resource != null) {
                url = resource;
            }
        }
        if (url == null) {
            throw new IllegalArgumentException("ServicePath not found : " + path);
        }
        return url;
    }

    public static String replaceSystemProperty(String str) {
        String result = str;
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if (endIndex == -1 || startIndex > endIndex) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = System.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceSystemProperty(result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceSystemProperty(result);
        }
        return result;
    }

    public static String replaceManagerProperty(ServiceManager manager, String str) {
        String result = str;
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if (endIndex == -1 || startIndex > endIndex) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = manager.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceManagerProperty(manager, result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceManagerProperty(manager, result);
        }
        return result;
    }

    public static String replaceServiceLoderConfig(String str, ServiceLoaderConfig config) {
        if (config == null) {
            return str;
        }
        String result = str;
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if (endIndex == -1 || startIndex > endIndex) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = config.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceServiceLoderConfig(result.substring(endIndex + SYSTEM_PROPERTY_END.length()), config);
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceServiceLoderConfig(result, config);
        }
        return result;
    }

    public static String replaceServerProperty(String str) {
        String result = str;
        int startIndex = result.indexOf(SYSTEM_PROPERTY_START);
        if (startIndex == -1) {
            return result;
        }
        int endIndex = result.indexOf(SYSTEM_PROPERTY_END);
        if (endIndex == -1 || startIndex > endIndex) {
            return result;
        }
        String propStr = result.substring(startIndex + SYSTEM_PROPERTY_START.length(), endIndex);
        String prop = null;
        if (propStr != null && propStr.length() != 0) {
            prop = ServiceManagerFactory.getProperty(propStr);
        }
        if (prop == null) {
            return result.substring(0, endIndex + SYSTEM_PROPERTY_END.length()) + Utility.replaceServerProperty(result.substring(endIndex + SYSTEM_PROPERTY_END.length()));
        }
        if ((result = result.substring(0, startIndex) + prop + result.substring(endIndex + SYSTEM_PROPERTY_END.length())).indexOf(SYSTEM_PROPERTY_START) != -1) {
            return Utility.replaceServerProperty(result);
        }
        return result;
    }
}

