/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.graph.AbstractTickUnitAdjusterServiceMBean;
import jp.ossc.nimbus.service.graph.TickUnitAdjuster;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;

public abstract class AbstractTickUnitAdjusterService
extends ServiceBase
implements TickUnitAdjuster,
AbstractTickUnitAdjusterServiceMBean {
    protected int displayGraduationCount;
    protected int unitCountMultiple;
    protected boolean isDomain;
    protected int axisIndex = -1;
    protected String formatPattern;

    public void setDisplayGraduationCount(int count) {
        this.displayGraduationCount = count;
    }

    public int getDisplayGraduationCount() {
        return this.displayGraduationCount;
    }

    public void setUnitCountMultiple(int multiple) {
        this.unitCountMultiple = multiple;
    }

    public int getUnitCountMultiple() {
        return this.unitCountMultiple;
    }

    public void setDomain(boolean isDomain) {
        this.isDomain = isDomain;
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    public void setAxisIndex(int index) {
        this.axisIndex = index;
    }

    public int getAxisIndex() {
        return this.axisIndex;
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void createService() throws Exception {
    }

    public void startService() throws Exception {
        if (this.displayGraduationCount <= 0) {
            throw new IllegalArgumentException("displayGraduationCount must be specified.");
        }
        if (this.unitCountMultiple <= 0) {
            throw new IllegalArgumentException("unitCountMultiple must be specified.");
        }
        if (this.axisIndex < 0) {
            throw new IllegalArgumentException("axisIndex must be specified.");
        }
        if (this.formatPattern == null) {
            throw new IllegalArgumentException("formatPattern must be specified.");
        }
    }

    public void stopService() throws Exception {
    }

    public void destroyService() throws Exception {
    }

    public void adjust(XYPlot xyPlot) {
        ValueAxis axis = null;
        axis = this.isDomain() ? xyPlot.getDomainAxis(this.getAxisIndex()) : xyPlot.getRangeAxis(this.getAxisIndex());
        this.adjust(axis);
    }

    protected abstract void adjust(ValueAxis var1);
}

